# Secure Boot signature database (db) for SpinetiX products

"db" directory contains the signed Secure Boot signature database (db)
certificates, one per file, signed with the SpinetiX KEK. See README in
this directory for general information.

The owner GUID for Microsoft db certificates is as specified in [Windows
Secure Boot Key Creation and Management
Guidance](https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/windows-secure-boot-key-creation-and-management-guidance),
which currently is `77fa9abd-0359-4d32-bd60-28f4e78f784b` for all.

The owner GUID for SpinetiX db certificates is
`012af9b0-238f-462b-962b-269052b49c4a`.

The procedure to generate the signed EFI variable update file (i.e., the
`*.siglist.signed` files) for each db certificate, using `sbsigntools` and
`openssl`, is as follows.

1. Get the db certificate in DER form, if the certificate was in PEM form
   convert it.
```
openssl x509 -in db-cert.pem -outform DER -out db-cert.der
```

2. Verify the db certificate.
```
openssl x509 -in db-cert.der -inform DER -noout -text
```

3. Create the `EFI_SIGNATURE_LIST` structure with `sbsiglist`, where
   `OWNER_GUID` is the owner GUID that should appear in the EFI variable
   update file.
```
sbsiglist --owner OWNER_GUID --type x509 --output db-cert.der.siglist db-cert.der
```

4. Sign the `EFI_SIGNATURE_LIST` structure with `sbvarsign`, where
   `kek-cert.pem` is the signing KEK certificate and `kek-cert-key.pem` its
   private key, both in PEM format.
```
sbvarsign --cert kek-cert.pem --key kek-cert-key.pem \
        --attr NON_VOLATILE,BOOTSERVICE_ACCESS,RUNTIME_ACCESS,TIME_BASED_AUTHENTICATED_WRITE_ACCESS,APPEND_WRITE \
        --output db-cert.der.siglist.signed \
        db db-cert.der.siglist
```
