<?php
/* @var $this ConfigController */

$list = $serialConfig->getFileList( true );
$files = array();
foreach ( $list as $path => $name ){
     $file = array(
        'path' => $path,
        'name' => $name,
        'target' => substr($path,4,-4),
        'system' => substr($path,0,3) == 'sys' || $path == "[disabled]",
        'disable' => $path == "[disabled]",
    );
    if ( $file['disable'] )
        $file['target'] = false;
    $files[] = $file;
}
$fsmSettings = array(
    array(
        'name' => 'Disabled',
        'val' => "disabled"
    ),
    array(
        'name' => 'Simple',
        'val' => 'simple'
    )
);
if ( Yii::app()->branding->hasRight('peripheralsFSMAdvanced') || $serialConfig->settings == 'advanced' ){
    $fsmSettings[] = array(
        'name' => 'Advanced',
        'val' => 'advanced'
    );
}

$selectConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Serial Port Automation",
    'id' => "FSM",
    'nbBox' => 1,
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );

    echo $selectConfig->activeDropDownList( $serialConfig, "settings", $serialConfig->getFileList(), array(
        'data-bind' => 'options: fsmSettings, optionsText: "name", optionsValue: "val"'
    ), true );
    echo CHtml::openTag("div", array( "data-bind" => "if: settings() === 'disabled'"));
        echo CHtml::activeHiddenField( $serialConfig, 'href', array( 'value' => "[disabled]") );
    echo CHtml::closeTag("div");
    
    echo CHtml::openTag("div", array( "data-bind" => "if: settings() === 'simple'"));
        $desc = "<p>Please enter the name of the command and the data string needed to control your monitor.</p>";
        $desc .= "<p>Any character can be escaped using its hex-encoded character code, prefixed with \x:<ul>";
        $desc .= "<li>The end of line symbol ('\\n') has character code 0A in hex, so it must be written as '\\x0A'</li>";
        $desc .= "<li>The byte string '7E 50 4E 0D' must be written as '\\x7E\\x50\\x4E\\x0D'</li>";
        $desc .= "<li>XML notation ( i.e. &amp;#x0D; ), single character escape sequences ( i.e. '\\r' ) and FSM %c{...} ( i.e. %c{13} ) notation will be automatically converted ( i.e. to '\\x0D' )</li>";        
        $desc .= "<li>Printable ASCII chars can be used without ecoding ( i.e. 'PowerOff\\x0A' )</li>";
        $desc .= "</ul></p>";
        $desc .= "<p>The complete documentation for the protocol string syntax can be found <a href='http://support.spinetix.com/wiki/Serial_port_protocol_files'>here</a></p>";
        
        echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $desc, array(  ) );
        echo CHtml::activeHiddenField( $serialConfig, 'href', array( 'value' => "[simple]") );
        $headers = array( 
            $serialConfig->getAttributeLabel( "simpleFSMCommand.name"),
            $serialConfig->getAttributeLabel( "simpleFSMCommand.value"),
            ""        
        );
        $options = array(
            "data-bind" => "foreach: commands",
            "sizes" => array( "col-xs-2", "col-xs-9", "col-xs-1" )
        );
        $row = array();
        $row[] = CHtml::textField( "", "", $selectConfig->itemOptions( array(
            "data-bind" => "value: name, attr: { name: 'SerialConfig[simpleCommands]['+\$index()+'][name]'}",
            'placeholder' => "CommandName"
        ) ) );
        $row[] = CHtml::textField( "", "", $selectConfig->itemOptions( array(
            "data-bind" => "value: value, attr: { name: 'SerialConfig[simpleCommands]['+\$index()+'][value]'}"
        ) ) );
        $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), "#", array(
            "data-bind" => "click: \$parent.removeCommand, css: { disabled: \$parent.commands().length === 1 && name() === '' && value() == ''}",
            "class" => "btn btn-sm btn-warning btn-block"
        ) );
        $this->widget('BsRow', array( 
            'options' => array( 'class' => 'table-responsive'),            
            'content' => $selectConfig->table( $headers, array( $row ), $options) 
        ));
        $this->widget('BsRow', array( 'cols' => array( 
            array( 'sizes' => array( 'sm' => 6, 'md' => 5 ), 
                'offsets' => array( 'sm' => 6, 'md' => 0 ),
                'content' => CHtml::link( "Add", "#", array(
                                "data-bind" => "click: addCommand",
                                "class" => "btn btn-sm btn-default btn-block"
                            ))
                )
        )));
    echo CHtml::closeTag("div");
    echo CHtml::openTag("div", array( "data-bind" => "if: settings() === 'advanced'"));
        $headers = array(
            "Name",
            "Active",
            "Download",
            "Delete",            
        );    
        $options = array(
            "data-bind" => "foreach: realfiles",
            "sizes" => array( "col-sm-9", "col-sm-1", "col-sm-1", "col-sm-1" )
        );
        $row = array();
        $row[] = CHtml::tag( "span", array(
            "data-bind" => "text: name"
        ), "");    
        $row[] = BsHtml::activeRadioButton( $serialConfig, 'href', array(
            'uncheckValue' => null,
            'data-bind' => 'value: path, checked: $parent.href, attr: { id: "Select" + $index()}'
        ) );
        $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-download"), "" ), array( 'fsmView' ), array(
            "data-bind" => "attr: { href: '".CHtml::normalizeUrl(array( 'fsm/view' ))."/target/' + encodeURIComponent( target ) + '/system/' + (system?'1':'0') }",
            "class" => "btn btn-sm btn-default btn-block"
        ) );
        $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), array( 'fsm/delete' ), array(
            "data-bind" => "click: \$parent.doRemoveFSM, hidden: system",
            "class" => "btn btn-sm btn-warning btn-block"
        ) );
        $this->widget('BsRow', array( 'options' => array( ),
            'options' => array( 'class' => 'table-responsive'),    
            'content' => $selectConfig->table( $headers, array( $row ), $options ) 
        ));
       
        $selectConfig->moreButtons = array( $this->widget('ActionButton', array( 
                                'options' => array( "data-bind" => "visible: settings() === 'advanced'"),
                                'label' => 'Add Protocol File', 
                                'block' => true,
                                'file' => CHtml::activeName( $serialConfig, "uploadedfile" ),
                                'args' =>   "{ ".
                                                "url: '". CHtml::normalizeUrl( array( 'fsm/add' ) ). "', ".    
                                                "done: addFSM" .
                                            "}" 
            ), true ) 
        );
    echo CHtml::closeTag("div");
    
$this->endWidget();
$this->activeObservable( $serialConfig, array( "href" ));
?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.files = ko.observableArray( <?php   
    echo CJavaScript::encode( $files );
?> );
yiiModel.fsmSettings = ko.observableArray( <?php   
    echo CJavaScript::encode( $fsmSettings );
?> );
yiiModel.realfiles = ko.computed( function() {
    var f = yiiModel.files();
    var r = [];
    for ( var i=0; i<f.length; i++ ){
        if ( f[i].target )
            r.push( f[i] );
    }
    return r;
});
yiiModel.doRemoveFSM = function( model, ev ) {
    var item = this;
    var btn = $(ev.currentTarget);
    var opt = {
        url: btn.attr("href"),
        data: { target : item.target  },
        type: 'POST'
    };
    yiiModel.doAjax( yiiModel, ev, opt, function( reponse ) {
        yiiModel.files.remove( item );
    });
};
function addFSM( e, data ) {
    var response = data.result;
    if ( response.success ){        
        var f = yiiModel.files();
        for (var i=0; i<f.length; i++ ) {
            if ( response.data.target === f[i].target ) {
                return; // in case we updated a file
            }
        };
        yiiModel.files.push( response.data );        
    }
};
yiiModel.commands = ko.observableArray( <?php
    $commands = array();
    foreach ($serialConfig->getSimpleCommands() as $simpleFSMCommand ){
        $commands[] = array(
            "name" => "js:ko.observable(".CJavaScript::encode( $simpleFSMCommand['name'] ).")",
            "value" => "js:ko.observable(".CJavaScript::encode( $simpleFSMCommand['value'] ).")"
        );
    }
    if ( count( $commands ) == 0 ){
        $commands[] = array(
            "name" => "js:ko.observable('')",
            "value" => "js:ko.observable('')"
        );
    }
    echo CJavaScript::encode( $commands );
?> );
yiiModel.removeCommand = function() {
    if ( yiiModel.commands().length > 1 ){
        yiiModel.commands.remove(this);
    } else {
        yiiModel.commands( [ {
            name: ko.observable(''),
            value: ko.observable('')
        } ] );
    }    
    yiiModel.commands.remove(this);
};
yiiModel.addCommand = function() {
    
    yiiModel.commands.push({
        name: ko.observable(''),
        value: ko.observable('')
    });
};
//]]></script>
