<?php
class ContentAction extends CAction
{
    static function live()
	{
        if ( !Yii::app()->branding->hasRight('contentLiveSource') ){
            return array();
        }
        $hasErrors = false;
        $sourceConfig = new SourceConfig;
        if ( isset($_POST['NetworkSource']) ){
            foreach ( $_POST['NetworkSource'] as $source ) {
                $networkSource = new NetworkSource;
                $networkSource->setAttributes( $source );
                if ( $networkSource->name != "" || $networkSource->uri != "" ){
                    $sourceConfig->addLiveSource( $networkSource );   
                }
            }
            if ( $sourceConfig->validate() ) {
                $sourceConfig->save();        
            } else {
                $hasErrors = true;
            }
        } else if (isset($_POST['SimpleFormId']) &&  $_POST['SimpleFormId'] == "Live" ){
            if ( $sourceConfig->validate() ) {
                $sourceConfig->save();        
            } else {
                $hasErrors = true;
            }
        }
        if ( !$hasErrors ){
            $sourceConfig->load();
        }
		return array( 
            'sourceConfig' => $sourceConfig,
        );
	}
    static function download()
	{
        if ( !Yii::app()->branding->hasRight('pullMode') ){
            return array();
        }
        $pullModeConfig = new PullModeConfig;
        $pullModeConfig->load();
        if ( isset($_POST['SyncSource']) ){
            
            $pullModeConfig->resetSyncSource();
            foreach ( $_POST['SyncSource'] as $source ) {
                $syncSource = new SyncSource;
                $syncSource->setAttributes( $source );
                if ( $syncSource->uri != "" ){
                    $pullModeConfig->addSyncSource( $syncSource );   
                }
            }
            if ( $pullModeConfig->validate() ) 
                $pullModeConfig->save();            
        }
        
        if ( isset($_POST['PullModeConfig']) ){
            $pullModeConfig->setScenario('manual');
            $pullModeConfig->setAttributes( $_POST['PullModeConfig'] );
            if ( $pullModeConfig->validate() )
                $pullModeConfig->save();
        }
        
		return array( 
            'pullModeConfig' => $pullModeConfig,
        );
	}
    static function splash()
	{
        $splashScreen = new SplashScreen;

        $splashScreen->load();

        return array(
            'splashScreen' => $splashScreen
        );
	}
    public function run()
    {
        $options = array( );
        $options += self::live(  );
        $options += self::download(  );
        $options += self::splash(  );
        $this->controller->render( 'content', $options );
    }
}