<?php

require_once dirname(__FILE__).'/MainInfo.php';

class BrandingInfoBase {
    var $vendor = "[No branding found]";
    var $product = "[No branding found]";
    var $mediacheck = 200;
    var $extendedFormat = true;
    var $maintitle = "[No branding found]";
    var $email = "support@spinetix.com";
    var $releasepkg = "spinetix-release";
    var $linkfirmware = "<a href='http://www.spinetix.com/support'>No branding found</a>";
    var $hwTempPath = "";
    var $hwTempFileIndex = "";
    var $rights = array();
    
    public $serialPorts = array();
    
    public $videoOutputs = array();
    public $hasVideoOutputSelector = false;

    public $audioOutputs = array();

    protected $licenses = array();
    protected $license = 'ARYA';
    protected $features;
    protected $licenseRights;
    protected $licenseData = array();

    public function __construct()
    {
        $model = getDeviceModel();

        if ($branding = self::getBranding('branding', $model, false)) {
            foreach ($branding as $name => $value) {
                $this->$name = $value;
            }
        }

        if (
            ($branding = self::getBranding('output-display', $model, true)) !==
                false
        ) {
            $this->videoOutputs = $branding;
            if (
                !$this->videoOutputs ||
                count(array_filter($this->videoOutputs, function($output) {
                    return $output !== false;
                })) > 1
            ) {
                $this->hasVideoOutputSelector = true;
            }
        }

        if ($branding = self::getBranding('output-audio', $model, true)) {
            $this->audioOutputs = $branding;
        }
    }

    public function hasLicense()
    {
        $this->loadLicense();
        return $this->license !== 'ARYA';
    }

    public function hasValidLicense()
    {
        $this->loadLicense();
        return $this->license !== 'ARYA' && $this->license !== 'EXPIRED';
    }

    public function getLicense()
    {
        $this->loadLicense();
        return $this->license;
    }

    public function getLicenses()
    {
        $this->loadLicense();
        return $this->licenses;
    }

    public function getFeatures()
    {
        $this->loadLicense();
        return $this->features;
    }

    public function getLicenseData()
    {
        $this->loadLicense();
        return $this->licenseData;
    }

    public function hasRight($name){
        return in_array($name, $this->rights)
            || $this->hasRightFromLicense($name);
    }

    protected static function getBranding($name, $model, $match) {
        $file = "/usr/share/resources/default/interface/{$name}.json";
        if (
            ($branding = @file_get_contents($file)) &&
            ($branding = json_decode($branding, true))
        ) {
            if ($match) {
                foreach ($branding as $pattern => $modelBranding) {
                    if (preg_match($pattern, $model)) {
                        return $modelBranding;
                    }
                }
            } elseif (isset($branding[$model])) {
                return $branding[$model];
            }
            return array();
        }
        return false;
    }

    protected function loadLicense()
    {
        if ($this->features !== null) {
            return true;
        }
        
        $this->features = array();
        $this->licenseRights = array();

        $info = @file_get_contents('/run/licensecheck/license-features.json');
        if (!$info) return false;

        $info = json_decode($info, true);

        if ( !isset( $info["features"] ) ) return false;

        $FeatureRightsMap = array(
            // WIDGETS
            "HMP" => array( 'displayAR', 
                            'NTP',
                            'contentProject', 'pullMode',
                            'firmware', 'log', 'security'
                          ),   
            "COM" => array( 'peripherals', 'peripheralsSerial', 'peripheralsFSM' ),
            // KIOSK
            "INTER" => array( 'interactivity'  ),
            "HTML" => array( 'HTML', 'webRtc' ),
            // SYSTEMS 
            "MULTI" => array( 'multiscreen', 'displayAdvanced', 'displayCustom', 'netAPI' ), 
            "STREAM" => array( 'streaming', 'networkWatchdog', 'peripheralsUSBAPI', 'peripheralsFSMAdvanced' )
        );
        foreach ( $info["features"] as $feature ) {
            if ( !isset( $feature["name"] ) || !isset( $feature["source"] ) || !isset( $feature["valid"] ) ) continue;
            $n = $feature["name"];
            if (strpos($n, '#') === 0) {
                continue;
            }
            if ( $n[0] === "_" && !$feature["valid"] ) $this->licenses[$feature["source"]] = "EXPIRED";
            if (!$feature["valid"]) continue;

            if ( $n[0] === "_") {
                $this->licenses[$feature["source"]] = substr($n, 1);
            } else {
                array_push( $this->features, $n);
            }

            if ( !isset( $FeatureRightsMap[ $n ] ) ) {
                array_push( $this->licenseRights, $n );
                continue;
            }
            foreach ( $FeatureRightsMap[ $n ] as $right ) {
                array_push( $this->licenseRights, $right );
            }
        }

        $licenseTypes = array('ARYA', 'EXPIRED', 'WIDGETS', 'KIOSK', 'SYSTEMS');
        $licenseLevels = 
            array_combine($licenseTypes, array_keys($licenseTypes));
        foreach ($this->licenses as $source => $type) {
            if (isset($licenseLevels[$type]) && 
                $licenseLevels[$type] > $licenseLevels[$this->license]) {
                $this->license = $type;
            }
        }

        $this->licenseData = $info;

        return true;
    }

    protected function hasRightFromLicense($name)
    {
        $this->loadLicense();
        return in_array($name, $this->licenseRights);
    }
}

$branding_file="/usr/share/resources/default/interface/branding.php";
if( PHP_OS == "WINNT" ) {
    $branding_file="/SpinetiX/sources/genesis/trunk/branding/hmp350/SpinetiX/interface/branding.php";
}
if ( file_exists($branding_file) ){
    include $branding_file;
} else {
    class BrandingInfo extends BrandingInfoBase {
        
    }
}
