<?php
/* @var $this OperationController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "USB",
    'id' => "USB",
) );
  if ( Yii::app()->branding->product != "DiVA" ){
        
    $formConfig->errorSummary( $sourceConfig );
    echo CHtml::beginForm(  array ( "", "#" => 'USB' ), "POST", array( 'class' => "") )."\n";
        echo CHtml::hiddenField('SimpleFormId', $formConfig->id )."\n";
        if ( Yii::app()->branding->hasRight('peripheralsUSBAPI') ){
            echo $formConfig->activeCheckBox( $playerConfig, "usbIOAPI" );
        }
        echo $formConfig->activeCheckBox( $sourceConfig, "useUSB", array(), true );
        $this->widget('BsRow', array(
                    'cols' => array(                
                        array( 'offset' => 9, 'size' => 3, 
                            'content' => $this->widget('ActionButton', array( 
                                'label' =>'Apply', 'type' => 'primary',
                                'block' => true, 
                                'post' => true 
                                ), true )
                        )
                    )
        ));
    echo CHtml::endForm();
  }  
    $formConfig->errorSummary( $usbStorageInfo );
    
    if ( !$usbStorageInfo->hasUSB() ){
        echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO,
                "No USB storage devices (e.g., USB stick) currently attached"
        );
    } else {
        echo CHtml::openTag("div", array( "class"=> "row") );
        foreach ($usbStorageInfo->storage as $idx => $usbStorage) {
            
            $formConfig->errorSummary( $usbStorage )  ."\n";
            echo CHtml::openTag("div", array( 'data-bind'=> "with: usb$idx", "class"=> "col-md-6") );
            echo CHtml::tag("h5", array(), "USB Device # " . ( $idx + 1 ) );
            
            $desc = "";
            if ( $usbStorage->isUserAvailable() ){
                if ( !$usbStorage->writable ){
                    $desc .= CHtml::tag("span", array( ), "USB storage must be specially formatted to use it as writable local storage, otherwise it is used as read-only.");                    
                }                
            }
            
            $desc .= $formConfig->activeItemValue($usbStorage, "usedFor", array(), "yiiModel.usb".$idx);
            
            $desc .= $formConfig->activeItem( $usbStorage, "size", 
                            CHtml::tag("span", array( 'class' => 'help-block'), $usbStorage->getSizeMBytes() ." MB" ) 
                     );
            
            echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $desc, array( 'closeText' => false ) );
            
            if ( !$usbStorage->isUserAvailable() && Yii::app()->branding->hasRight('peripheralsUSBCopy') ) {
                echo CHtml::beginForm( array( "usb/publish" ), 'POST' );
                echo CHtml::activeHiddenField($usbStorage, "sysfs_device_path" );
                echo CHtml::hiddenField("action", "publish" );
                $this->widget( 'DialogButton' , array(
                    'label' =>'Publish USB Content',
                    'ko' => '$root.doPublish',
                    'level' => BsHtml::ALERT_COLOR_WARNING,
                    'content' => "Publish content from the USB storage will replace previously published content on the ".Yii::app()->branding->product,
                ));
                echo CHtml::endForm();
            }

            if ( $usbStorage->writable && Yii::app()->branding->hasRight('peripheralsUSBCopy') ){
                echo CHtml::beginForm( array( "usb/publish" ), 'POST' )."\n";
                echo CHtml::hiddenField("action", "save" )."\n";
                echo CHtml::activeHiddenField($usbStorage, "sysfs_device_path" )."\n";
                $this->widget( 'DialogButton' , array(
                    'label' =>'Copy to USB',
                    'ko' => '$root.doPublish',
                    'level' => BsHtml::ALERT_COLOR_WARNING,
                    'content' => "Copy ".Yii::app()->branding->product." internal storage to USB will replace all content on the USB storage.",
                ));                  
                echo CHtml::endForm()."\n";                
            }
            
            // format
            echo CHtml::beginForm( array( "usb/format" ), 'POST' )."\n";
            echo CHtml::activeHiddenField($usbStorage, "sysfs_device_path" )."\n";
            $this->widget( 'DialogButton' , array(
                'label' =>'Format',
                'ko' => '$root.doFormat',
                'level' => BsHtml::ALERT_COLOR_WARNING,
                'content' => "Formating a USB storage device erases all content on it.",
            ));
            
            echo CHtml::endForm() ."\n"; 
            
            $this->observable( "isUsed", $usbStorage->isUsed(), "yiiModel.usb".$idx );
            echo CHtml::openTag("div", array( 'data-bind'=> "if: isUsed") );
                echo CHtml::beginForm( array( "usb/unmount" ), 'POST' )."\n";
                echo $formConfig->activeHiddenField($usbStorage, "forceUnmount", array(), "yiiModel.usb".$idx )."\n";
                echo CHtml::hiddenField("index", $idx )."\n";
                $this->widget( 'DialogButton' , array(
                    'label' =>'Disconnect',
                    'options' => array( 'data-bind' => "text: forceUnmount()?'Force Disconnect':'Disconnect'"),
                    'ko' => "function(model, ev) { \$root.doDisconnect( $idx, model, ev); }",
                    'content' => false,
                ));

                echo CHtml::endForm()."\n";
            echo CHtml::closeTag("div");
            echo CHtml::closeTag("div");
        }
        echo CHtml::closeTag("div");
    }
    
$this->endWidget();

$publishDst = CHtml::normalizeUrl( array("usb/publish") );
$formatDst = CHtml::normalizeUrl( array("usb/format") );
?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.doPublish = function( model, ev ) {
    var publishId = null;
    var publishInfoId = null;
    
    function checkPublish(){
        var options = {  
            type    : 'POST',
            data    : { action : 'status', id: publishId },
            url     : "<?php echo $publishDst; ?>",
            cache   : false,
            dataType:'json'
        };
        yiiModel.doAjax( yiiModel, ev, options, function( ev, response ){
            if ( response.data.state === 'finished' ) {
                spxapi.ui.removeMessage( publishInfoId );
                var txt = "Statistics:<ul>";
                txt += "<li>Uploaded: " + response.data.file_cnt.new +" file(s)</li>"; 
                txt += "<li>Modified: " + response.data.file_cnt.modified +" file(s)</li>";
                txt += "<li>Deleted: " + response.data.file_cnt.deleted +" file(s)</li>";
                txt += "<li>Total transfered: " + response.data.total_bytes/1000 +" Kbytes</li>";
                txt += "</ul>";
                publishInfoId = spxapi.ui.message( { 
                    title: "Publish USB Finished", 
                    type: "info", 
                    sticky: false,
                    text: txt
                } );
            } else {
                setTimeout( checkPublish ,10000);
            }
        }, function() {
            spxapi.ui.removeMessage( publishInfoId );
        });
    }    
    yiiModel.doAjaxForm( model, ev, 
        function( ev, response ) {
            publishInfoId = spxapi.ui.message( { 
                type: 'info', 
                sticky: true,
                text: "Publish USB Started"
            } );
            publishId = response.data;
            setTimeout( checkPublish ,10000);
        }
    );
};
yiiModel.doFormat = function( model, ev ) {
    var btn = $(ev.target); 
    var id;
    var pid;
    function refresh( response ) {
        var data = response.data;
        if ( data.finished) {
            btn.button('reset');            
        } else {
            btn.button('loading');
            setTimeout( update, 5000 );
        }
    };
    function update( ) {
        yiiModel.doAjax( model, ev, {
            type    : 'POST',
            data    : { pid : pid, id: id },
            url     : "<?php echo $formatDst; ?>",
            cache   : false,
            dataType:'json',
        }, function( ev, response ){
            refresh( response )
        });       
    };
    yiiModel.doAjaxForm( model, ev, 
        function( ev, response ) {
            id = response.data.id;
            pid = response.data.pid;                        
            update( );
        }
    );
};
yiiModel.doDisconnect = function( idx, model, ev ) {
    yiiModel.doAjaxForm( model, ev, 
        function( ev, response ) {
            if ( response.data ){
                yiiModel['usb'+idx].usedFor( response.data.usedFor );            
                yiiModel['usb'+idx].isUsed( response.data.isUsed );
                yiiModel['usb'+idx].forceUnmount( response.data.forceUnmount );
            }
        }
    );
};
//]]></script>