<?php
/* @var $this OperationController */

$this->registerSpxScript( 'firmware.js' );
$configFirmware = array(
    'urlNetCheck' => CHtml::normalizeUrl(array("operation/checkNetwork")),
    'urlFirmwareStatus' => CHtml::normalizeUrl(array("/main/firmware", "handle" => "SRC", "source" => "SOURCE"))
);

$formUpdate = $this->beginWidget('SimpleForm', array( 
    'title' => "Firmware Update",
    'id' => "Firmware",
    'button' => "Check Now",
    'action' => array ( 'ko' => 'checkFirmwareAction' )    
) );

    

    $info = $formUpdate->activeItemValue( $firmwareUpdate, "firmwareVersionLong" );
    $info .= $formUpdate->activeItemValue( $firmwareUpdate, "updaterVersionLong" );
    if ( $firmwareUpdate->spxjslibsVersion!==false ) {
        $info .= $formUpdate->activeItemValue( $firmwareUpdate, "spxjslibsVersionLong" );
    }

    $formUpdate->errorSummary( $firmwareUpdate );
     
    $info .= "Information about new firmware releases is available at " .
                                    Yii::app()->branding->linkfirmware;
    
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $info, array( 'closeText' => false ) );
    
    $this->widget('SimpleForm', array( 
        'dataBind' => 'if: firmwareStatus().logs',
        'nbBox' => false,
        'title' => "Logs",
        'hide' => true,
        'desc' => CHtml::tag("pre", array( 'data-bind'=>'foreach: firmwareStatus().logs' ),
            "<!-- ko text: \$data + \"\\n\" --><!-- /ko -->")
    ) );
    
    $updatesourceList = array(
        "base" => $firmwareUpdate->updateuri, 
        "local-usb" => "USB Key" 
    );    
    echo $formUpdate->activeDropDownList( $firmwareUpdate, "updatesource", $updatesourceList, 
        array( 'data-bind' => 'bootstrapSelect: updatesource') 
        );

$this->endWidget();

$this->activeObservable($firmwareUpdate, array( 
    'updatesource'
) );

?>
<script type="text/javascript" >
//<![CDATA[
extendModel( yiiModel );
extendModelFirmware( yiiModel, <?php echo CJavaScript::encode( $configFirmware ); ?> );

yiiModel.ipChecked.subscribe( function( newValue ) {
    if ( newValue.executed && !newValue.success ){
        spxapi.ui.message( { 
            type: 'warning', 
            title: "Conectivity Error",
            sticky: true,
            text: newValue.reason
        } );
    }
});
var updateAvailableInfoId = null;

yiiModel.firmwareInfo.subscribe( function( newValue ) {
    var title = yiiModel.firwareInfoTitle();
    var text = yiiModel.firwareInfoText();
    
    if ( newValue.reason ) {
        if ( updateAvailableInfoId ){
            spxapi.ui.removeMessage( updateAvailableInfoId );
        }
        updateAvailableInfoId = spxapi.ui.message( { 
            type: 'warning', 
            title: title,
            sticky: true,
            text: text
        } );
        if ( newValue.logs ){
            yiiModel.firmwareStatus({
                started: false,
                logs: newValue.logs
            });
        }
    }
    if ( newValue.executed && newValue.success ) {
        if ( updateAvailableInfoId ){
            spxapi.ui.removeMessage( updateAvailableInfoId );
        }
        var options = {
            type: 'info', 
            title: title,
            sticky: true
        };
        if ( newValue.updates > 0 ) {
            options.body = "<p>" + text + "</p>";
            options.button = {
                 name: "Update Now",
                 action: firmwareUpdateAction,
                 class: 'btn-default'
            };
        } else {
            options.text = text;
        }
        updateAvailableInfoId = spxapi.ui.message( options ); 
    }    
}); 
 
function checkFirmwareNow( model, btn, source, forceCheck, status, ipCheck ) {
    btn.button('loading');
    var sub = model.firmwareInfo.subscribe( function( newValue ) {
        if ( newValue.executed || newValue.canceled ){
            btn.button('reset');
            sub.dispose();
        }
    });
    model.checkFirmware( source, forceCheck, status, ipCheck );
}


yiiModel.checkFirmwareAction = function( model, ev ) {
    checkFirmwareNow( model, $(ev.target), model.updatesource(), true, null,
        false );
};


function firmwareUpdateAction( ev ){
    yiiModel.updateStart();
}


// check the firmware now
$(function() {
    checkFirmwareNow( yiiModel, $("#Firmware .btn-primary"), 'base', false,
        <?php echo CJavaScript::encode($firmwareUpdate->updater->
        fastNoUpdateCheck() ? $firmwareUpdate->getStatus() : null); ?>, true );
});


//]]></script>