<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => 'Wi-Fi',
    'id' => 'Wi-Fi'
));
    $formConfig->errorSummary($wifiInfo);
    if (!empty($wifiInfo->networks)) {
        if ($ipConfig->netiface != IPConfig::NET_WIFI) {
            echo BsHtml::alert(
                BsHtml::ALERT_COLOR_WARNING, 'Currently configured network ' . 
                'is ' . $ipConfig->getNetifaceSelect()[$ipConfig->netiface] . 
                '. Wi-Fi is not used even if connected.');
        }
        $headers = array('Name', 'Security', 'Signal', 'Connected');
        $table = array();
        foreach ( $wifiInfo->networks as $network ){
            $table[] = array(
                $network->name, $network->security, $network->signal, 
                $network->connected ? CHtml::tag('span', array('class' => 
                'fa fa-check')) : '');
        }
        echo BsHtml::alert(
            BsHtml::ALERT_COLOR_INFO, 
                $formConfig->table( $headers, $table, array(
                    'sizes' => array( 'col-sm-3', '', '', '', '', '', '', '' ),
                    'sizes' => array( 'col-sm-3', '', '', '', '', '', '', '' )
                )) , 
                array('closeText' => false , 'class' => 'table-responsive')
        );
    } else {
        echo BsHtml::alert(
            BsHtml::ALERT_COLOR_INFO, 'No networks currently configured.');
    }
    if ( Yii::app()->request->isPostRequest  ){
        // this is a hack to prevent browser from opening a popup in case the last action was a POST.
        $script = 'location.assign("'.$this->createUrl( '/controlcenter/main/network', array('re'=>'load', '#'=>'Wi-Fi') ).'");';
    } else {
        $script = 'location.reload()';
    }
    $this->widget( 'DialogButton' , array(
        'label' => 'Refresh',
        'script' => $script,
        'content' => false
    ));
    $this->widget( 'DialogButton' , array(
        'label' => 'Reconfigure',
        'script' => 'location.assign("/wifi")',
        'level' => BsHtml::ALERT_COLOR_WARNING,
        'content' => "Pressing 'Reconfigure' will the start the Wi-Fi " . 
        "configuration process. The current Wi-Fi and network " . 
        "configuration will be reset."
    ));
$this->endWidget();

