<?php
header('Content-type: application/json');

if ( Tools::doShutdown() )
    Tools::shutdown();

if ( !isset( $errors ) )
    $errors = array();
if ( !isset( $messages ) ){
    $messages = Tools::getMessages();  
}

if ( !isset( $reboot ) ) {
    if ( Tools::doShutdown() && !Tools::checkInstallationmode() ) {    
        $reboot = Tools::$shutdownReason;
    }else {
        $reboot = false;
    }
}
if ( !isset( $pendingChangeList ) ){
    if ( Tools::checkInstallationmode() ){
        $pendingChangeList = array();
        foreach ( Tools::getPendingChangeList() as $idx=>$change ){
            $pendingChangeList[] = $change;
        }        
    } else 
        $pendingChangeList = false;
}
if ( !isset( $data ) )
    $data = (object)array();

if ( !isset( $success ) ) {
    if ( count( $errors ) == 0 )
        $success = true;
    else 
        $success = false;    
}

echo json_encode( array(
    'success' => $success,
    'reboot' => $reboot,
    'pendingChangeList' => $pendingChangeList,
    'errors' => $errors,
    'data' => $data,
    'messages' => $messages,
    'redirect' => CHtml::normalizeUrl( Tools::$redirect ),
    'reload' => Tools::$reload
) );
