<?php

/**
 * Description of WebstorageAPIConfig
 *
 * @author jr
 */
class WebstorageAPIConfig extends Token {
    
    public function init() {
        $this->setPrefix( "webstorage" );
    }
    public function rules() {
		$res = array(
            array( "token", 'length', 'min' => 10, 'max' => 64),
            array( "token", 'match', 'pattern' => "/^[-a-zA-Z0-9._+@]*$/"),
            array( "enableToken", 'checkToken' ),            
        );
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'token'=>'Security Token',
            'enableToken' => 'Enable security token access to the Webstorage API',
		);
    } 
    public function addTokenError( ){
        $this->addError( "token", "Security Token is required");
    }

}
