<?php
class DisplayAction extends CAction
{
    
    static function display( $playerConfig = null, $screenSettings = null, $simpleFormId = "Display" ){
        if ( !$playerConfig ){
            $playerConfig = new PlayerConfig;
        }
        
        if ( !$screenSettings ){
            $screenSettings = new ScreenSettings('display');
            $screenSettings->load($playerConfig);
        }
        
        $validate = false;
        $simple = false;
        if ( $simpleFormId == "Display" ) {
            if(
                isset($_POST['ScreenSettings']) &&
                $_POST['ScreenSettings']['modeSelect'] == 'multiOutput'
            ) {
                return array( 
                    'playerConfig' => $playerConfig,
                    'screenSettings' => $screenSettings,
                );
            }
            if( isset($_POST['PlayerConfig']) ){
                $playerConfig->setScenario( 'display'  );
                $playerConfig->setAttributes( $_POST['PlayerConfig'] );
                $validate = true;
            }
            if( isset($_POST['ScreenSettings']) ){
                $screenSettings->setAttributes( $_POST['ScreenSettings']);
                $validate = true;
                $simple = $_POST['ScreenSettings']['modeSelect'] == 'simple';
            }
        }
        if ( $validate ){
            if ( $playerConfig->validate() && $screenSettings->validate() ) {
                if ( $simple || $screenSettings->check() !== false ) {
                    $playerConfig->saveConfig();
                    $screenSettings->save();
                    // load the full config to display the page
                    $screenSettings->load($playerConfig);
                }
            }
        }
        return array( 
            'playerConfig' => $playerConfig,
            'screenSettings' => $screenSettings,
        );
    }
    
    static function audio( $playerConfig = null, $simpleFormId = "Audio" ) {
        if ( !$playerConfig ){
            $playerConfig = new PlayerConfig;
        }
        
        if ( $simpleFormId == "Audio" && isset( $_POST['PlayerConfig'] ) ) {
            $playerConfig->setScenario( 'display'  );
            $playerConfig->setAttributes( $_POST['PlayerConfig'] );
            if ( $playerConfig->validate()  ) {
                $playerConfig->saveConfig();
            }
        }
		return array( 
            'playerConfig' => $playerConfig 
        );
    }
    
    static function power(){
        $power = new Power();
        $power->load();
        if( isset($_POST['Power']) ) {
            $power->setScenario( 'display'  );
            $power->setAttributes( $_POST['Power'] );
            if ( $power->validate() )
                $power->save();            
        } 
		return array(
            'power' => $power,            
        );
    }
    
    static function other( $playerConfig = null, $screenSettings = null, $simpleFormId = "Other" ) {
        if ( !$playerConfig ){
            $playerConfig = new PlayerConfig;
        }
        if ( !$screenSettings ){
            $screenSettings = new ScreenSettings('display');
            $screenSettings->load($playerConfig);
        }
        
        if ( $simpleFormId == "Other" && isset( $_POST['PlayerConfig'] ) ) {            
            $playerConfig->setScenario( 'display'  );
            $playerConfig->setAttributes( $_POST['PlayerConfig'] );
            if ( $playerConfig->validate()  ) {
                $playerConfig->saveConfig();
            }
        }
        
        
        if ( $simpleFormId == "Other" && isset($_POST['ScreenSettings']) ){
            $screenSettings->setScenario( 'display'  );
            $screenSettings->setAttributes( $_POST['ScreenSettings']);
            if ( $screenSettings->validate() ) {
                $screenSettings->save();
                // load the full config to display the page
                $screenSettings->load($playerConfig);
            }
        }
        
		return array( 
            'playerConfig' => $playerConfig,
            'screenSettings' => $screenSettings
        );
    }
    
    public function run()
    {
        $simpleFormId = isset($_POST['SimpleFormId'])?$_POST['SimpleFormId']:"";
        
        $playerConfig = new PlayerConfig;
        $options = array( );
        
        $screenSettings = new ScreenSettings('display');
        $screenSettings->load($playerConfig);
        
        $options += self::display( $playerConfig, $screenSettings, $simpleFormId );
        $options += self::audio( $playerConfig, $simpleFormId );
        $options += self::power( );
        $options = self::other( $playerConfig, $screenSettings, $simpleFormId ) + $options;
        
        $screenInfo = new ScreenInfo;
        $screenInfo->load();
		$options['screenInfo'] = $screenInfo;        
        
        $this->controller->render( 'display', $options );
    }
}
