<?php

class checkIPv4 extends CValidator  {
    public $allowEmpty = true;
    
    public function validateAttribute( $object, $attribute ){
        $value = $object->$attribute;
        
        if ( $this->allowEmpty && trim( $value ) == "" ) return true;
        $vals=explode( ".",trim( $value) );
        if (count($vals)!=4) {
            $object->addError($attribute,'Format non valid. '.'Valid format xxx.xxx.xxx.xxx');
            return false;
        }
        $str = "";
        $allOk = true;
        foreach ($vals as $idx => $val) {            
            if (!is_numeric($val) || $val<0 || $val>255) {
                $str .="xxx.";
                $allOk = false;                
            } else {
                $str .= $val.".";
            }
        }
        if ( !$allOk ){
            $object->addError($attribute,'Format non valid. '.'Valid format '. substr($str,0, -1) . ', where xxx is between 0-255');;
        }
        if ($vals[0]==0) {
            $object->addError($attribute,'Format non valid. '.'First value cannot be 0');
        }
        if ($vals[0]==255 && $vals[1]==255 && $vals[2]==255 && $vals[3]==255) {
            $object->addError($attribute,'Format non valid. '.'255.255.255.255 is not a valid address.');
        }
    }
}