<?php

class m170213_120000_project extends CDbMigration
{
    public function createTask( $name, $desc, $operations ){
        $auth=Yii::app()->authManager;
        $task = $auth->createTask($name,$desc);
        foreach ( $operations as $opp => $desc ){
            $auth->createOperation( $opp, $desc );
            $task->addChild( $opp );
        }
        return $task;
    }
	
   // Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
        $auth=Yii::app()->authManager;

       
        $this->createTask( 'manageProject','manage (add, edit, remove) project', array( 
            'viewProject' => 'view project',
            'uploadProject' => 'upload project',
            'copyProject' => 'copy project',
            'deleteProject' => 'delete project',
            'editProject' => 'edit project'
        ) );
        
        $auth->createOperation( 'uploadBackup', 'upload backup' );
        
        $roles = $auth->getRoles();
        $roles['content']->addChild( 'manageProject' );        
        $roles['content']->addChild( 'uploadBackup' );        
        $roles['authenticated']->addChild('viewProject');
        
        $auth->save(); 
	}

    public function safeDown()
	{
		$auth=Yii::app()->authManager;
        $roles = $auth->getRoles();
        $roles['content']->removeChild( 'manageProject' );        
        $roles['content']->removeChild( 'uploadBackup' );        
        $roles['authenticated']->removeChild('viewProject');
        $auth->removeAuthItem('manageProject');        
        
        $auth->removeAuthItem('viewProject');
        $auth->removeAuthItem('uploadProject');
        $auth->removeAuthItem('copyProject');
        $auth->removeAuthItem('deleteProject');
        $auth->removeAuthItem('editProject');
        
        $auth->save();
	}

}