<?php

include_once( dirname(__FILE__).'/../utils/MaintenanceJobs.php' );

class m150507_000000_default_users extends CDbMigration
{
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
        $user = User::model()->findByAttributes(array('username'=>'admin'));
        if ( !$user ){
            $user = new User();
            $user->username = "admin";
            $user->password = "admin";
            $user->verifyPassword = "admin";
            $user->lowSecurityPassword = true;
            if ( $user->save() ) {
                $user->userRights->admin = true;
                if ( !$user->userRights->save() ) {                    
                    trigger_error("Cannot save admin user rigths", E_USER_WARNING);
                    foreach ( $user->userRights as $attrib => $desc ){
                        trigger_error("$attrib: ".implode("; ", $desc), E_USER_WARNING);
                    }
                    return false;
                }
            } else {                                
                trigger_error("Cannot save admin user", E_USER_WARNING);
                foreach ( $user->getErrors() as $attrib => $desc ){
                    trigger_error("$attrib: ".implode("; ", $desc), E_USER_WARNING);
                }
                return false;
            }
        }
        if ( !$user->updateHttpdSecurity() ) {   
            trigger_error("Cannot update httpd security", E_USER_WARNING);
            foreach ( $user->getErrors() as $attrib => $desc ){
                trigger_error("$attrib: ".implode("; ", $desc), E_USER_WARNING);
            }            
        }
        return true;
	}

}