<?php

// This is the configuration for yiic console application.
// Any writable CConsoleApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
    'runtimePath' => '/var/cache/spxmanage/yii-runtime',
	'name'=>'Maintenance',

	// preloading 'log' component
	'preload'=>array('log'),
    'import'=>array(
		'application.components.*',
        'application.models.*',
        'application.modules.api.components.*',
        'application.modules.api.models.*',
        'application.modules.controlcenter.components.*',
        'application.modules.controlcenter.models.*',
	),
	// application components
	'components'=>array(
		'db'=>array(
			'connectionString' => 'sqlite:/var/lib/spxmanage/ui/ui.db'
		),
        'dbassets'=>array(
			'connectionString' => 'sqlite:/srv/raperca/interface/protected/assets.db',
            'class'            => 'CDbConnection',
            'initSQLs' => array( 'PRAGMA synchronous = NORMAL;' )
		),
        'authManager'=>array( 
            'class'=>'CDbAuthManager',
            'defaultRoles'=>array('authenticated', 'guest'),
        ),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'MySysLogRoute',
					'levels'=>'error, warning',
                    'identity'=> 'spxmanage.yiic',
                    'facility'=> LOG_USER
				),
			),
		),
	),
);