<?php
class WebUser extends CWebUser {
    protected $autentication_path = "";
    
	public function init() {
        parent::init(); 
        
        $wizard = new Wizard();
        if( $this->getIsGuest() && $wizard->getWelcome() ){
            // auto log the user
            $identity=new UserIdentity('admin', 'admin');
            $identity->authenticate();
            if ( $identity->errorCode === UserIdentity::ERROR_NONE ){
                $this->login($identity );
                $this->setState('autolog', true);
            }
        }
        
        $language = $this->getState('lang');;
        if ( $language=='auto' || $language=="" || $language==null ){
            $user = new User();            
            $language = strtr( Yii::app()->getRequest()->getPreferredLanguage($user->getSupportedlanguages() ), "_", "-");                
        } 
        if ( $language !== "" && $language != null ){
            Yii::app()->setLanguage( $language );
        }        
        openlog("spxmanage.yii", LOG_ODELAY|LOG_PID, LOG_USER);        
	}
    public function checkAccess($operation, $params=array ( ), $allowCaching=true ){        
        Yii::log("checkAccess($operation, ".(count($params)>0?print_r($params,true):"()").", ".($allowCaching?"true":"false"). ")", 'debug', 'spx.user');
        if ( strpos($operation, "External" ) && !Yii::app()->branding->hasRight('contentLiveSource') ){
            return false;           
        }
        if ( strpos($operation, "Project" ) && !Yii::app()->branding->hasRight('contentProject') ){
            return false;           
        }
        if ( ( strpos($operation, "Media") || strpos($operation, "Playlist") || strpos($operation, "Playout") || strpos($operation, "Schedule") || strpos($operation, "Apps") ) && !Yii::app()->branding->hasRight('CreateSchedule') ){
            return false;           
        }
        return parent::checkAccess($operation, $params, $allowCaching);
    }
    public function loginRequired()
	{
        $app=Yii::app();
        
		$request=$app->getRequest();
 
		if( $request->getIsAjaxRequest() )
		{			
            http_response_code( 403 );
            
			header('Content-type: application/json');
            header('Access-Control-Allow-Origin: *');
            header('Access-Control-Allow-Methods: POST, GET, PUT, DELETE');

            header('Cache-Control: no-cache');
            header('Pragma: no-cache');	
		}

		parent::loginRequired();
	}
    public function afterLogin( $fromCookie ){
        
        // touch only on regular log-in
        if ( !$fromCookie ){
            $authentication_path = ini_get( 'session.save_path' );
            $id = yii::app()->getSession()->getSessionID();
            touch( $authentication_path ."/auth_".$id );
            $this->saveExpiryDateToFile($authentication_path ."/auth_".$id);
            if ( $this->checkAccess('monitoring') ){
                touch( $authentication_path ."/auth_monitoring_".$id );
            }
            if ( $this->checkAccess('content') ){
                touch( $authentication_path ."/auth_content_".$id );
            }
            if ( $this->checkAccess('admin') ){
                touch( $authentication_path ."/auth_admin_".$id );
            }
        }
    }
    public function beforeLogout( ){
        $id = yii::app()->getSession()->getSessionID();
        $authentication_path = ini_get( 'session.save_path' );
        if (file_exists( $authentication_path ."/auth_".$id ) ){
            unlink( $authentication_path ."/auth_".$id );
        }
        if (file_exists( $authentication_path ."/auth_monitoring_".$id ) ){
            unlink( $authentication_path ."/auth_monitoring_".$id );
        }
        if (file_exists( $authentication_path ."/auth_content_".$id ) ){
            unlink( $authentication_path ."/auth_content_".$id );
        }
        if (file_exists( $authentication_path ."/auth_admin_".$id ) ){
            unlink( $authentication_path ."/auth_admin_".$id );
        }
        $this->setState('lang', "");
        return true;
    }
    private function saveExpiryDateToFile($filePath) {
        $absoluteAuthTimeout = $this->getState(CWebUser::AUTH_ABSOLUTE_TIMEOUT_VAR);

        if ($absoluteAuthTimeout !== null) {
                $expiryDate = new DateTime('@' . $absoluteAuthTimeout);
                $formattedDate = $expiryDate->format('YmdHis');
                file_put_contents($filePath, $formattedDate);
        }
    }
}
