var Project = function( data, args ) {
    
    args = args || { };
    
    var self = {
        name: ko.observable( ),        
        keywords: ko.observable(),        
        properties: ko.observableArray( [] ).extend({ rateLimit: 0 }),
        id: ko.observable( 'new project' ),
        manage: ko.observable(),
        query: {}
    };
    
    self.fromJS = function( data ) {
        if ( data.id ) {
            self.id( data.id );
        }
        self.manage( data.manage );   
        
        self.name( data.name );
        if ( data.keywords ){
            self.keywords( data.keywords.join(",") );
        }
        self.properties.removeAll();
        self.properties.push( { name: spxapi.t('Name'), type : 'string', value: self.name } );        
        self.properties.push( { name: spxapi.t('Keywords'), type : 'tags', value: self.keywords, options: { tags: keywordsMemory().get() } } );
        
        if ( data.params ){
            for ( var i=0; i<data.params.length; i++ ){
                //var file = data.params[i].name;
                for ( var q in data.params[i].options ){
                    var option = data.params[i].options[q];
                    var value = data.query[q];
                    self.query[q] = ko.observable(value);
                    option.value = self.query[q];
                    
                    self.properties.push( option ); 
                }
            }
        }
        if ( data.active ){
            spxapi.ui.message({
                type: 'info',
                title: spxapi.t('Live Content'),
                text: spxapi.t("This is currently displayed on the screen")            
            });            
        }
    };
    self.fromJS( data );
    
    self.toJS = function(){
        var data = {
            name: self.name()
        };
        if ( self.keywords() ){
            data.keywords = self.keywords().split(",");
        }
        data.query = ko.toJS( self.query );
        return data;        
    };
    self.toJSON = function(){
        return JSON.stringify( self.toJS() );
    };
      
    self.preview = ko.computed( function() {
        var model = spxapi.resources.get( self.id() );
        return model.snapshots.single.src();
    });
    
    

    self.breadcrumbs = ko.observableArray([ { 
        name: self.name,
        active: ko.observable( true ),
        click: self.stopEdit
    } ]).extend({ rateLimit: 0 });

    return self;
};

function ProjectEdit( args ) {
    
    args = args || {};
    var self = this;
    
    self.project = new Project(
        {
            name: spxapi.t("New project"),      
        }, {            
        }
    );
    //console.log( self.project );
    
    self.id = args.id;
    self.status = new ko.dirtyFlag( self.project, true );
    
    self.load = function(){
        if ( self.id ){
            self.project.name( spxapi.t( "Loading ..." ) );
            spxapi.project.get( spxapi.project.uri + self.id + "/" )
            .done( function( data ){
                self.project.fromJS( data );
                self.status.reset();
            });
        } else {
            self.status.reset();
        }
    };
    self.load();
    
    self.saving = ko.observable();
    self.apply = function ( data, event ) {
        spxapi.ui.loading(event.target);
        var params = self.project.toJS();
        if( self.id ) {
            return spxapi.project.update( self.project.manage(), params ).done(function(){
                self.status.reset();                
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        } else {
            return spxapi.project.create( params ).done(function( data ){
                self.status.reset();
                
                // if this is a new item, then we complete it
                var memory = spxapi.storage.get("spx-calendar-new-item" );
                if ( memory ){
                    var newItem = JSON.parse( memory );
                    newItem.title = data.name;
                    newItem.resource = {
                        id: data.id,
                        type: data.type
                    };                    
                    spxapi.storage.set("spx-calendar-new-item", JSON.stringify( newItem ) );
                }                
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        }
    };
    self.cancel = function ( data, event ) { 
        location.href = document.referrer; 
    };
    self.save = function ( data, event ) {
        self.apply( data, event ).done( function() {
            self.cancel( data, event );
        });
    };
    self.updateProject = function ( data, event ) {
        self.project.fromJS( data );
        self.status.reset();
    };
    self.breadcrumbs = ko.computed( function() {
        return self.project.breadcrumbs();
    });
    // Prevent leaving the page with changes
    $(window).bind('beforeunload', function(e){
        if ( self.status.isDirty() ) {
            return spxapi.t( "Some changes have not been saved." );
        } else {
            return;
        }
    });
};
