function extendModelExt( yiiModel, yiiErrors, config ){
    function restartNow( ev ) {
        var data = {};
        data[config.csrfTokenName] = config.csrfToken;
        yiiModel.doAjax( yiiModel, ev, {
            url: config.urlReboot,
            data: data,
            type: 'POST'
        }); 
    }
    function checkRedirect( ){
        if ( yiiModel.redirect ){
            if ( window.location == yiiModel.redirect ){
                //location.reload();
                
                var hash = window.location.hash;                    
                if ( hash && hash !== "#" ){
                    if ( yiiModel.activeFragment ){
                        window.location.hash = yiiModel.activeFragment;
                    }
                    if ( window.location.search ){
                        window.location.search = window.location.search + "&_re=load";
                    } else {
                        window.location.search = "?_re=load";
                    }
                } else {
                    window.location.assign( yiiModel.redirect );
                }                        
            } else {
                window.location.assign( yiiModel.redirect );
            }            
        }
    }
    if ( 'reboot' in yiiModel ) {
        // model already extended
        if ( yiiErrors ){
            yiiModel.addErrors( yiiErrors );    
        }
    } else {
        yiiModel.bootId = config.bootId;
        yiiModel.reboot = ko.observable(  );
        
        yiiModel.checkReboot = function( ) {
            $.ajax({
                url: "/boot-id",
                dataType: 'text'
            }).done( function( data ) {                
                if ( $.trim(data) !== "" && $.trim(data) !== yiiModel.bootId ) {
                    yiiModel.reboot( false );
                    yiiModel.bootId = $.trim(data);
                    checkRedirect( );
                } else {
                    // device did not reboot yet, or is rebooting 
                    if ( yiiModel.reboot() ){
                        setTimeout( yiiModel.checkReboot ,10000); 
                    }
                }
            }).fail( function( jqXHR ) {
                if ( yiiModel.redirect && (jqXHR.status === 404 || jqXHR.status === 403 ) ) {
                    yiiModel.reboot( false );
                    checkRedirect( );          
                } else {
                    // device is not responding yet or has not yet not booted into the expected mode, should try again in a few seconds
                    if ( yiiModel.reboot() ){
                        setTimeout( yiiModel.checkReboot ,10000); 
                    }
                }
            });
        };
        
        yiiModel.reboot.subscribe( function( newValue ) {
            if ( yiiModel.reboot.msg ){
                spxapi.ui.removeMessage( yiiModel.reboot.msg );    
                yiiModel.reboot.msg = null;
            }
            if ( newValue ) {
                setTimeout( yiiModel.checkReboot ,10000); // we know this should take more than 1 minute
                yiiModel.reboot.msg = spxapi.ui.message( { 
                    type: 'warning', 
                    title: "Restart in Progress",
                    sticky: true,
                    text: (newValue!==true?"<p>Reason: <span>"+ newValue +"</span></p>":"") + "<p>Please wait for the device to restart.</p>"
                } );
            }
        } );
        if ( config.bootNow ){
            yiiModel.reboot( true );
            setTimeout( yiiModel.checkReboot ,10000);
        }
        
        yiiModel.instalMode = ko.observable( config.instalMode );
        var pendingChangeListId;
        yiiModel.pendingChangeList = ko.observableArray( ).extend({ rateLimit: 0 });
        yiiModel.pendingChangeList.subscribe(function( newVals ) {
            if ( pendingChangeListId ){
                spxapi.ui.removeMessage( pendingChangeListId );
            }
            if ( newVals.length > 0 ){
                var body = "<ul>";
                for( var i=0; i<newVals.length; i++ ){
                    body += "<li>"+newVals[i]+"</li>";
                }
                body += "</ul>";
                pendingChangeListId = spxapi.ui.message( { 
                    type: 'info', 
                    title: "Pending configuration changes",
                    sticky: true,
                    body: body,
                    button: {
                        name: "Restart Now",
                        action: restartNow,
                        class: 'btn-default'
                    }
                } ); 
            }
        });
        yiiModel.pendingChangeList( config.pendingChangeList );
        yiiModel.addErrors = function( errors ){
            if ( !errors || errors.length == 0 ){
                return;
            }
            var txt = "";
            if ( errors.length > 1 ){
                txt += "<ul>";
                for( var i=0; i< errors.length; i++ ){
                    txt += "<li>" + errors[i] + "</li>";
                }
                txt += "</ul>";
            } else {
                txt = errors[0];
            }
            spxapi.ui.message( { 
                type: 'danger', 
                title: "Error" + (errors.length > 1?"s":""),
                text: txt 
            } );
        };
        yiiModel.addErrors( yiiErrors );
        
        yiiModel.addMessages = function( messages ){
            if ( !messages ){
                return;
            }
            for( var i=0; i< messages.length; i++ ){
                var m = messages[i].match(/<h5>([^<]*)<\/h5>(.*)/);
                var title, message;
                if ( m && m.length == 3 ){
                    title = m[1];
                    message = m[2];
                } else {
                    title = 'info';
                    message = messages[i];
                }
                
                spxapi.ui.message( { 
                    type: 'info', 
                    title: title,
                    text: message 
                } );
            }
        };
        yiiModel.addMessages( config.addMessages );
                    
        yiiModel.updatePlayerResponse = function( response ) {
            this.reboot( response.reboot );
            yiiModel.addErrors( response.errors );            
            yiiModel.addMessages( response.messages );

            if ( response.pendingChangeList === false || response.pendingChangeList === undefined ){
                this.instalMode( false );
                this.pendingChangeList( [] );
            } else {
                this.instalMode( true );
                this.pendingChangeList( response.pendingChangeList );
            }
            if ( response.reload ){
                response.redirect = window.location;
            }
            if ( response.redirect ){
                yiiModel.redirect = response.redirect;                                
                if ( !response.reboot ){                    
                    checkRedirect( );                    
                }
            }
            
        };
        yiiModel.doAjax = function( model, ev, opt, successCallback, failCallback, alwaysCallback ) {
            var btn = $(ev.target);
            var cnt = btn.html();
            var useLoading = btn.html() !== "";
            if ( useLoading )
                btn.button('loading');
            if ( !opt.data ){
                opt.data = {};
            }
            if ( !opt.data[config.csrfTokenName] ){
                opt.data[config.csrfTokenName] = config.csrfToken;
            }
            $.ajax( opt ).done(function ( response ) {  
                if ( useLoading )
                    btn.button('reset');
                yiiModel.updatePlayerResponse( response );
                if ( response.success ) {            
                    if ( successCallback )
                        successCallback( ev, response );
                    if ( alwaysCallback )
                        alwaysCallback( ev, response );
                } else {            
                    if ( failCallback )
                        failCallback( ev, response );  
                    if ( alwaysCallback )
                        alwaysCallback( ev, response );
                }                
            }).fail(function ( jqXHR, textStatus, errorThrown ) {
                var r;
                try {
                    r = JSON.parse( jqXHR.responseText );
                } catch ( e ) {      
                    r = { errors : [ "Some error occured: " + errorThrown ] };
                }            
                yiiModel.updatePlayerResponse( r );
                if ( useLoading )
                    btn.button('reset');
                if ( failCallback )
                    failCallback( ev, null );
                if ( alwaysCallback )
                    alwaysCallback( ev, null );
            });
        };
        yiiModel.doAjaxButton = function( model, ev, successCallback, failCallback, alwaysCallback ) {
            var btn = $(ev.currentTarget);
            var opt = {
                url: btn.attr("href"),
                type: 'POST'
            };
            yiiModel.doAjax( model, ev, opt, successCallback, failCallback, alwaysCallback );
        };
        yiiModel.doAjaxForm = function( model, ev, successCallback, failCallback, alwaysCallback ) {
            var btn = $(ev.currentTarget);
            var form = btn.parents("form");
            var opt = {
                url: form.attr("action"),
                data: form.serialize(),
                type: 'POST'
            };
            yiiModel.doAjax( model, ev, opt, successCallback, failCallback, alwaysCallback );            
        };        
    }
}