<?php
/* @var $this OperationController */

ob_start(); 
$passphraseConfig = $this->beginWidget('SimpleForm', array( 
        'nbBox' => null,
        'labelSize' => 10,
        'inputSize' => 12,
        'formClass' => ""
) );
$dbdata = array(
    "0" => "Use existing secret key",
    "2" => "Regenerate secret key",
    "1" => "Set new passphrase"
);
    echo $passphraseConfig->activeDropDownList( $configBackup, "hasPassphrase", $dbdata, array( ), true );      
    echo CHtml::openTag("div", array( 'data-bind' => 'visible: hasPassphrase() == "1"', 'class' => '') );
        echo CHtml::tag("p", array( "class" => 'col-sm-12' ),
                    "This passphrase will be used to encrypt configuration secrets. ".
                    "The configuration backup can be restored on any player having the same passphrase configured."
        );        
        echo $passphraseConfig->activeTextField( $configBackup, "passphrase", array('data-validate' => "validatePassphrase", "data-placement" => "left" ) );
    echo CHtml::closeTag("div");  
    echo CHtml::tag("div", array( 'data-bind' => 'visible: hasPassphrase() == "0"', 'class' => 'col-sm-12'), 
                "The existing secret key will be used to encrypt configuration secrets. ".
                "Previously generated configuration backups can be restored on this player."
    );
    echo CHtml::tag("div", array( 'data-bind' => 'visible: hasPassphrase() == "2"', 'class' => 'col-sm-12'), 
                "A new secret key will be used to encrypt configuration secrets. ".
                "It will no longer be possible to restore previous configuration backups on this player."
    );
$this->endWidget();
$passphraseStep = ob_get_contents ( );
ob_end_clean();

$this->widget('SPXWizard', array(
    'wizardName' => 'yiiPassphraseWizard',
    'title' => "Configuration Backup Encryption",    
    'pages' => array(        
        array(  'title'=> 'Setup', 
                'content'=> $passphraseStep
        ),            
    ),    
    'failure' => "An error occurred when submitting the configuration. Please reload the page and start setup again.",
    'options' => array(
        'formClass' => 'xxx',
        'show' => false,
        'contentHeight' => 380,
        'contentWidth' => 650
    ),     
    'ajax' => array(
        "type" => "POST",
        "url" => CHtml::normalizeUrl( array( ) ),            
        "dataType" => "json",
        "successFunction" => "yiiModel.updatePlayerResponse",
        "failFunction" => "passphraseFailFunction"
    )         
) );

$box = $this->beginWidget('SimpleForm', array( 
    'title' => "Configuration Backup",
    'button' => "Get Config",
    'id' => 'Backup',
    'action' => array( 
        'post' => array( "backup/get" )  )
) );
    $hasPassphrase = $configBackup->getHasPassphrase();
    
    if ( $hasPassphrase ){
        $desc = "Passphrase configured. Configuration secrets will be encrypted with it and can be restored on any player having the same passphrase configured.";
    } else {
        $desc = "No passphrase configured. Configuration secrets will be encrypted with a secret key and can only be restored on this player.";
    }

    $this->widget( 'DialogButton' , array(
        'label' => "Change Encryption",
        'script' => "yiiPassphraseWizard.show();",
        'level' => BsHtml::ALERT_COLOR_INFO,
        'content' => $desc
    ));
     
    $this->widget( 'DialogButton' , array(
        'label' => "Restore Config",
        'args' => CJavaScript::encode( array(
            'url' => CHtml::normalizeUrl( array( "backup/post" ) ),
            'dropZone' => "js:$('#Backup')"
         )), 
        'file' => CHtml::activeName( $configBackup, 'uploadedfile' ),
        'content' => false
    ));
    
    echo $box->activeCheckBox( $configBackup, "backupPassword" );       

$this->endWidget();
?>
<script type="text/javascript" >
//<![CDATA[
    function passphraseFailFunction( jqXHR, textStatus, errorThrown ){
        //console.log(errorThrown);
        yiiModel.addErrors( [ errorThrown] );
    }
    function validatePassphrase( el ) {
        if ( yiiModel.hasPassphrase() === "0" ){
            el.val("");
        } else if ( yiiModel.hasPassphrase() === "2" ){
            el.val("<?php echo ConfigBackup::$resetString;?>");
        }
        var name = el.val();
        var retValue = {};
        
        var hostnameRE = /^[-a-zA-Z0-9 #!%&*+,.:;=_]*$/;
        if ( !hostnameRE.test(name) ){
            retValue.status = false;
            retValue.msg = "Invalid char used in the passphrase";
        } else {        
            retValue.status = true;
        }

        return retValue;
    }

//]]></script>