<?php

/*
 * Automatic test
 */
include_once "Helpers.php";


class MediaTest extends CDbTestCase {
    
    public function checkListDesc( $desc, $data=null ){
        
        $this->assertArrayHasKey( 'id', $desc );
        
        $name = "\nid: ".$desc['id'];
        
        $this->assertArrayHasKey( 'name', $desc, $name );
        $this->assertArrayHasKey( 'mimeType', $desc, $name );
        $this->assertArrayHasKey( 'type', $desc, $name );
        $this->assertArrayHasKey( 'href', $desc , $name);
        $this->assertArrayHasKey( 'manage', $desc, $name );
        $this->assertArrayHasKey( 'previews', $desc, $name );
        
        $family = explode( "/", $desc['mimeType'] )[0];
        if ( $family=='image' || $family=='video' ) {
            $this->assertArrayHasKey( 'dimension', $desc, $name );
            $this->assertArrayHasKey( 'aspectRatio', $desc, $name );
            
            $this->assertRegExp( "/^\d+x\d+$/", $desc['dimension'], $name );            
        }
        if ( $family=='audio' || $family=='video' ) {
            $this->assertArrayHasKey( 'dur', $desc, $name );            
        }
        
        Helpers::checkKeywords( $this, $desc, $data, $name );
        
        Helpers::checkPreviews( $this, $desc['previews'], $name );
        
        if ( $data ){
            $this->assertEquals($data['id'], $desc['id'], $name );
            $this->assertEquals($data['name'], $desc['name'], $name );
            $this->assertEquals($data['mimeType'], $desc['mimeType'], $name );
            $this->assertEquals(
                    GlobalSettings::$uriBase."media/".$data['id']."/", 
                    $desc['manage'], $name );
            $this->assertEquals(
                    GlobalSettings::$hrefBase."media/".$data['id']."/media.".$data['ext'], 
                    $desc['href'], $name );
            
        }
        // check that the file exist
        $len = strlen( GlobalSettings::$hrefBase );
        $path = GlobalSettings::$fileBase . substr($desc['href'], $len );
        $this->assertTrue( file_exists( $path ), 
                "file $path do not exist\n" );
        
    }
    
    public function checkDesc( $desc, $data=null ){
        
        
        $this->checkListDesc( $desc, $data );
        $name = "\nid: ".$desc['id'];
        
        if ( isset( $desc['parents'] )){
            foreach ( $desc['parents'] as $parent )
                Helpers::checkParent( $this, $parent, $name );
        }
        
        
    }
    
    public function testCreate() {

        $options = array( 'format' => 'jpg', 'width'=>100, 'height'=>100, );
        $data = array (
            'name' => 'test',
            'keywords' => array( 'test', 'automatic' )
        );
        
        $resource = new Resource;
        $resource->attributes = $data;
        $resource->type = "media";
        $this->assertTrue( $resource->save() );
        
        $model = new Media;
        $model->id = $resource->id;
        $model->processFile( $options );
        $this->assertTrue( $model->save() );
        
        $data['mimeType'] = "image/jpg";
        $data['id'] = $resource->id;
        $data['ext'] = "jpg";
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );        
        
        return $data;
    }
    
    /**
     * @depends testCreate
     */
    public function testGet( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db

        $model = Media::model()->findByPk( $id );
        $this->assertNotSame( null, $model );
        $this->assertTrue($model instanceof Media);
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );     
        
    }
    
    /**
     * @depends testCreate
     */
    public function testList( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db
        $models = Media::model()->findAll();
        
        $this->assertTrue( is_array($models) );
        $this->assertTrue( count($models)>0 );
        $has_id = false;
        
        foreach ( $models as $model ){
            $this->assertTrue($model instanceof Media);
            if ( $model->id==$id )
                $has_id = true;
            $this->checkDesc( $model->desc );        
            $this->checkListDesc( $model->listDesc );
        }
        $this->assertTrue( $has_id );
    }
    /**
     * @depends testCreate
     */
    public function testDelete( $data ) {
        
        $id = $data['id'];
        $model = Media::model()->findByPk( $id );
        
        $folder = $model->resource->folder;
        
        $this->assertTrue( $model->delete() );
        
        $new_model = Media::model()->findByPk( $id );
        $this->assertNull( $new_model );
        
        $this->assertFalse( file_exists( $folder ) );
    }
    
    public function createErrorsProvider()
    {
        return array(
            array( "name", null, "jpg", true ),
            array( "name", null, "png", true ),
            
            array( "name", null, "gif", false ),
            array( "name", null, "xxx", false ),
            array( "name", null, "mp4", false ), // we can only fake images, so this will be an error
            
            array( "utf8ä中企", array( "data", "utf8ä中企", "auto" ), "jpg", true ),
            
            );
    }
    /**
     * @dataProvider createErrorsProvider
     * @depends testDelete
     */
    public function testCreateErrors( $name, $keywords, $type, $success ) {
        
        $options = array( 'format' => $type, 'width'=>100, 'height'=>100, );
        
        
        $data = array (
            'name' => $name,
            'keywords' => $keywords?$keywords:array()
        );
        
        $resource = new Resource;
        $resource->attributes = $data;
        $resource->type = "media";
        $this->assertTrue( $resource->save() );
        
        $data['id'] = $resource->id;
        $data['ext'] = $type;
        $data['mimeType'] = "image/".$type;
            
        $model = new Media;
        $model->id = $resource->id;
        $model->processFile( $options );
        
        if ( $success ){
            $this->assertTrue( $model->save() );
            $this->assertFalse( $model->hasErrors() );
                        
            $this->checkDesc( $model->desc, $data );        
            $this->checkListDesc( $model->listDesc, $data );            
            $this->assertTrue( $model->delete() );
            
        } else {
            $this->assertFalse(  $model->save() );        
            $this->assertTrue ( $model->hasErrors() );
            $this->assertTrue( $resource->delete() );
        }
        
    }
}
