#!/bin/sh
#
# Resets the ntp variable data (drift, etc.) if requested and checks
# that the RTC is in sync with the system clock.  This scripts runs
# after ntpdate on start, but before ntpd, and after ntpd has been
# stopped on shutdown.
#

# The file that flags us to reset NTP
FLAG_FILE=/var/spool/spxutils/ntpreset

case "$1" in
    start|restart)
	if [ -f "$FLAG_FILE" ]; then
	    echo -n "reset ntp data"
            driftfile="$(sed -ne '/^[[:space:]]*driftfile/{s/[[:space:]]*driftfile[[:space:]]\+\([^[:space:]]\+\).*/\1/;p}' /etc/ntp.conf )"
	    if [ -f "$driftfile" ]; then
		rm -f "$driftfile"
	    fi
	    rm -f "$FLAG_FILE"
	    sync
	    echo "."
	fi
	spxrtc -l -R -s
	;;
    stop)
	spxrtc -l -R -s
	;;
    reload|force-reload)
	;;
esac



