<?php

/*
 * Automatic test
 */
include_once "Helpers.php";


class PlayoutTest extends CDbTestCase {
    
    public function checkOptions( $options ){
        $this->assertTrue(is_array( $options ) );
        
        if ( isset( $options['dur']) )
            $this->assertInternalType('numeric', $options['dur'] );        
    }
    
    public function checkQuery( $query, $options ){
        $this->assertTrue(is_array( $query ) );             
    }
    public function checkLayerItem( $layer ){
        $info = print_r( $layer, true );
        $this->assertArrayHasKey( 'type', $layer );
        $this->assertArrayHasKey( 'args', $layer );      
        Helpers::checkArgs( $this, $layer['args'] );
        
        $this->assertArrayHasKey( 'data', $layer );
        
        if ( $layer['type'] == 'playlist' ){            
            Helpers::checkPlaylist( $this, $layer['data'] );
        }
        if ( $layer['type'] == 'apps' ){
            $apps = $layer['data'];
            
            $this->assertArrayHasKey( 'id', $apps, $info ); 
            $this->assertArrayHasKey( 'widgetId', $apps, $info ); 
            $this->assertArrayHasKey( 'apps', $apps, $info ); 
            Helpers::checkAppsDesc( $this, $apps['apps'] );
            
            $this->assertArrayHasKey( $apps['widgetId'], $apps['apps']['widgets'], print_r( $apps['apps'], true) ); 
            $widget = $apps['apps']['widgets'][$apps['widgetId']];
            if ( isset( $apps['query'] ) ){
                $query = $apps['query'];
                Helpers::checkQuery( $this, $query, $widget['options'] );                  

                $this->assertArrayHasKey( 'href', $layer['args'] );   

                if ( $apps['apps']['data'] ){
                    $query['variable'] = $apps['apps']['data']['variable'];
                }
                Helpers::checkHrefQuery( $this, $layer['args']['href'], $query );
            }
        }
        
    }

    public function checkListDesc( $desc, $data=null ){
        
        $this->assertArrayHasKey( 'id', $desc, print_r( $desc, true ) );
        $name = "\nid: ".$desc['id'];
        
        $this->assertArrayHasKey( 'name', $desc, print_r( $desc, true ) );
        $this->assertArrayHasKey( 'type', $desc, print_r( $desc, true ) );
        $this->assertEquals($desc['type'], "playout" );
        
        Helpers::checkKeywords( $this, $desc, $data, $name );
        
        $this->assertArrayHasKey( 'href', $desc, print_r( $desc, true ) );
        $this->assertArrayHasKey( 'manage', $desc, print_r( $desc, true ) );
        $this->assertArrayHasKey( 'previews', $desc, print_r( $desc, true ) );
        Helpers::checkPreviews( $this, $desc['previews'], $name );
        
        if ( $data ) {
            $this->assertEquals($data['id'], $desc['id'] );
            $this->assertEquals($data['name'], $desc['name'] );        
            $this->assertEquals(
                    GlobalSettings::$uriBase."playout/".$data['id']."/", 
                    $desc['manage'] );
            $this->assertEquals(
                    GlobalSettings::$hrefBase."playout/".$data['id']."/playout.svg", 
                    $desc['href'] );
        }
        // check that the file exist
        $len = strlen( GlobalSettings::$hrefBase );
        $path = GlobalSettings::$fileBase . substr($desc['href'], $len );
        $this->assertTrue( file_exists( $path ), 
                "file $path do not exist\n" );
    }
    
    public function checkDesc( $desc, $data=null ){
        $this->checkListDesc( $desc, $data );
        $name = "\nid: ".$desc['id'];
        
        if ( isset( $desc['parents'] )){
            foreach ( $desc['parents'] as $parent )
                Helpers::checkParent( $this, $parent, $name );
        }  
        $this->assertArrayHasKey( 'options', $desc );
        $this->checkOptions( $desc['options'] );
        
        $this->assertArrayHasKey( 'layers', $desc );
        $this->assertTrue(is_array( $desc['layers'] ) );
        foreach ( $desc['layers'] as $layer ){
            $this->checkLayerItem( $layer );
        }
    }
    var $mediaType = ['media', 'playlist', 'widget', 'slide'];
    public function testPrepareMedia(  ) {
        $ids = array();
        foreach( $this->mediaType as $i=>$type ){
            switch( $type) {
                case 'media': 
                    $ids[$i] = array( 'id' => Helpers::createMedia( $this, "media $i" ) );
                    break;
                case 'playlist': 
                    $ids[$i] = array( 'id' => Helpers::createPlaylist( $this, "media $i" ) );
                    break;
                case 'widget':                 
                    $widget = array( 'name'=>'widget', 'options' => array( 
                        'set' => array( 'type'=>'text', 'name'=>'Set'),
                        'notset' => array( 'type'=>'text', 'name'=>'Not Set')
                    ));
                    $ids[$i] = Helpers::createApps( $this, "apps $i", "apps $i", array( $widget ) );                    
                    break;                
                case 'slide':
                    $widget = array( 'name'=>'slide', 'viewBox'=> "", 
                        'options' => array( 
                        'set' => array( 'type'=>'text', 'name'=>'Set'),
                        'notset' => array( 'type'=>'text', 'name'=>'Not Set')
                    ));
                    $ids[$i] = Helpers::createApps( $this, "apps $i", "apps $i", array( $widget ) );                    
                    break;                
            }
        }
        return $ids;
    }
    /**
     * @depends testPrepareMedia
     */
    public function testCreate( $media_id ) {
        $layers = array();
        $args = array(
                        'top' => 0,
                        'left' => 0,
                        'width' => 1920,
                        'height' => 1080
                    );
        foreach ( $media_id as $idx=>$desc ){            
            if ( $this->mediaType[$idx] === 'widget'){
                $id = $desc['id'];
                $layers[] = array (
                    'type'  => 'apps',
                    'data' => array( 
                        'id'    => $id,
                        'widgetId' => $desc['widgetIds'][0],
                        'query' => array( 'set' => 'test' ),
                    ),
                    'args' => $args
                );
            } else {
                $id = $desc['id'];
                $m = array( 'id' => $id );
                if( $this->mediaType[$idx] === 'slide' ) {
                    $m['query'] = array( 'set' => 'test' );
                    $m['type'] = 'apps';
                    $m['widgetId'] = $desc['widgetIds'][0];
                } else {
                    $m['type'] = $this->mediaType[$idx];                    
                }
                $layers[] = array (
                    'type' => 'playlist',
                    'data' => array(
                        'media' => array( $m )
                    ),
                    'args' => $args
                );
            }
        }
        // empty playlist
        $layers[] = array (
            'type' => 'playlist',
            'data' => array(),
            'args' => $args
        );
        $data = array (
            'name' => 'test',
            'keywords' => array( 'test', 'auto' ),
            'layers' => $layers
        );
        
        $model = new Playout;
        $model->attributes = $data;
        $ok = $model->save();
        $this->assertTrue( $ok, print_r( $model->getErrors(), true ). print_r( $data, true ) );
        
        $data['id'] = $model->id;
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );        
        
        // check that all media have the playout as parent
        foreach ( $media_id as $idx=>$desc ){
            $id = $desc['id'];
            $type = $this->mediaType[$idx];
            if ( $type == 'slide' || $type == 'widget' )
                $m = Apps::model()->findByPk( $id );
            else if ( $type == 'media' )
                $m = Media::model()->findByPk( $id );
            else 
                $m = Playlist::model()->findByPk( $id );
            
            Helpers::checkMediaParents( $this, $m->desc, $model->id, print_r( $desc, true) );
        }
        return $data;
    }
    
    /**
     * @depends testCreate
     */
    public function testGet( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db

        $model = Playout::model()->findByPk( $id );
        $this->assertNotSame( null, $model );
        $this->assertInstanceOf( 'Playout', $model );        
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );     
        
    }
    
    /**
     * @depends testCreate
     */
    public function testList( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db
        $models = Playout::model()->findAll();
        
        $this->assertTrue( is_array($models) );
        $this->assertTrue( count($models)>0 );
        $has_id = false;
        foreach ( $models as $model ){
            $this->assertTrue($model instanceof Playout);
            if ( $model->id==$id )
                $has_id = true;
            $this->checkDesc( $model->desc );        
            $this->checkListDesc( $model->listDesc );
        }
        $this->assertTrue( $has_id, "Created playout not found in the list" );
    }
    /**
     * @depends testCreate
     */
    public function testDelete( $data ) {
        
        $id = $data['id'];
        $model = Playout::model()->findByPk( $id );
        $this->assertInstanceOf( 'Playout', $model );     
        
        $folder = $model->folder;
        
        $this->assertTrue( $model->delete() );
        
        $new_model = Media::model()->findByPk( $id );
        $this->assertNull( $new_model );
        
        $this->assertFalse( file_exists( $folder ) );
    }
    /**
     * @depends testPrepareMedia
     */
    public function testRemoveMedia( $media_id ) {

        foreach( $this->mediaType as $i=>$type ){
            switch( $type) {
                case 'media': 
                    Helpers::removeMedia( $this, $media_id[$i]['id'], true );
                    break;
                case 'playlist': 
                    Helpers::removePlaylist( $this, $media_id[$i]['id'], true );
                    break;
                case 'slide': 
                case 'widget':
                    Helpers::removeApps( $this, $media_id[$i]['id'], true );
                    break;                
            }
        }    
    }
    
    public function testDependencyDelete(  ) {
        $nbMedia = 3;
        $ids = array();
        $data = array (
            'name' => "some name",
            'keywords' => array( 'test', 'auto', 'delete' ),            
        );
        for( $i=0; $i<$nbMedia; $i++ ){
            $id = Helpers::createPlaylist( $this, "media $i" );
            $data['layers'][]=array(
                'type' => 'playlist',
                'data' => array(
                    'media' => array( 
                        array( 'id' => $id, 'type' => 'playlist' ) 
                        )
                ),
                'args' => array(
                    'top' => 0, 'left' => 0,
                    'width' => 1920, 'height' => 1080
                ),
            );
            $ids[] = $id;
        }
        
        $model = new Playout;
        $model->attributes = $data;
        $this->assertTrue( $model->save() );
        $this->assertFalse( $model->hasErrors() );

        $data['id'] = $model->id;
        $this->checkDesc( $model->desc, $data );        
        $this->checkListDesc( $model->listDesc, $data );
        $layers =  $model->layers;
        $this->assertEquals( count($ids), count($layers) );
        foreach( $ids as $idx=>$id ){
            $this->assertArrayHasKey( 'data', $layers[$idx] );
            $playlist = $layers[$idx]['data'];
            $this->assertArrayHasKey( 'media', $playlist );
            $media = $playlist['media'];
            $this->assertTrue( is_array( $media ));
            $this->assertTrue( count( $media )>0 );
            $this->assertArrayHasKey( 'id', $media[0] );
            
            $this->assertEquals( $id, $media[0]['id'] );
        }
        
        // delete the media
        while ( count( $ids )>0 ){
            $id = array_pop($ids);
            $m = Playlist::model()->findByPk($id );
            $this->assertInstanceOf( 'Playlist', $m );
            
             // check that the media has some parents            
            Helpers::checkMediaParents( $this, $m->desc, $model->id );
            $this->assertTrue( $m->delete() );
            $new_model =  Playout::model()->findByPk( $model->id );
            $this->assertInstanceOf( 'Playout', $new_model );
            
            $nb_empty = 0;
            foreach( $new_model->layers as $layer ){
                if ( count($layer['data']['media'])==0 )
                    $nb_empty++;
            }
            $this->assertEquals( count($ids), count($new_model->layers)-$nb_empty );
            foreach( $ids as $idx=>$id ){
                $layer = $new_model->layers[$idx];
                
                $this->assertArrayHasKey( 'media', $layer['data'] );
                $media = $layer['data']['media'];
                $this->assertTrue( is_array( $media ) );
                $this->assertTrue( count( $media )>0 );
                $this->assertArrayHasKey( 'id', $media[0] );

                $this->assertEquals( $id, $media[0]['id'], print_r($new_model->layers, true) . print_r($ids, true) );
            }
        }

        $this->assertTrue( $model->delete() );
    }
    public function testDependencyCreate(  ) {
        $nbMedia = 3;
        $ids = array();
        $data = array (
            'name' => "some name",
            'keywords' => array( 'test', 'auto', 'create' ),       
        );
        $model = new Playout;
        $model->attributes = $data;
        $this->assertTrue( $model->save() );
        $this->assertFalse( $model->hasErrors() );
        
        $data['id'] = $model->id;
        $this->checkDesc( $model->desc, $data );        
        $this->checkListDesc( $model->listDesc, $data );
        
        $layers = $model->layers;
        $this->assertEquals( 0, count($layers) );
        
        $data2 = array();
        for( $i=0; $i<$nbMedia; $i++ ){
            $id = Helpers::createPlaylist( $this, "media $i" );
            $data2['layers'][]=array(
                'type' => 'playlist',
                'data' => array(
                    'media' => array( 
                        array( 'id' => $id, 'type' => 'playlist' ) 
                        )
                ),
                'args' => array(
                    'top' => 0, 'left' => 0,
                    'width' => 1920, 'height' => 1080
                ),
            );
            $ids[] = $id;
            
            $model->attributes = $data2;
            $this->assertTrue( $model->save() );
            $this->assertFalse( $model->hasErrors() );
            
            $layers =  $model->layers;
            $this->assertEquals( count($ids), count($layers) );
            foreach( $ids as $idx=>$id ){
                $this->assertArrayHasKey( 'data', $layers[$idx] );
                
                $this->assertArrayHasKey( 'media', $layers[$idx]['data'] );
                $media = $layers[$idx]['data']['media'];
                $this->assertTrue( is_array( $media ) );
                $this->assertTrue( count( $media )>0 );
                $this->assertArrayHasKey( 'id', $media[0] );

                $this->assertEquals( $id, $media[0]['id'] );                
            }
            
            $new_model =  Playout::model()->findByPk( $model->id );
            $this->assertInstanceOf( 'Playout', $new_model );

            $this->checkDesc( $new_model->desc, $data );        
            $this->checkListDesc( $new_model->listDesc, $data );
            $this->assertEquals( count($ids), count($new_model->layers) );
            
            $m = Playlist::model()->findByPk( $id );
            $this->assertInstanceOf( 'Playlist', $m );
            Helpers::checkMediaParents( $this, $m->desc, $model->id );
            
        }
        // delete the playout without deleting children first
        $this->assertTrue( $model->delete() );
        
        // delete the media
        while ( count( $ids )>0 ){
            $id = array_pop($ids);
            $m = Playlist::model()->findByPk( $id );
            $this->assertInstanceOf( 'Playlist', $m );
            
             // check that the media do not have parents
            $this->assertArrayNotHasKey( 'parents', $m->desc );
            $this->assertTrue( $m->delete() );            
        }
    }
    
    public function testDependencyAppsWidget(  ) {
                
        $data = array (
            'name' => "some name",
            'keywords' => array( 'test', 'auto', 'delete' ),
            'layers' => array()
        );
        
        $appsData = Helpers::createApps( $this );        
        $data['layers'][] = array(
            'type' => 'apps',
            'data' => array( 
                'id' => $appsData['id'],
                'widgetId' => $appsData['widgetIds'][0],
                'query' => array()
            ),
            'args' => array(
                'top' => 0, 'left' => 0,
                'width' => 1920, 'height' => 1080
            )
        );
        
        $model = new Playout;
        $model->attributes = $data;
        $ok = $model->save();
        $this->assertTrue( $ok, print_r( $model->getErrors(), true ). print_r( $data, true ) );
        
        $this->assertFalse( $model->hasErrors() );
        $data['id'] = $model->id;
        
        $m = Apps::model()->findByPk( $appsData['id'] );
        Helpers::checkMediaParents( $this, $m->desc, $model->id );        
        Helpers::removeApps( $this, $appsData['id'] );
        
        $newModel =  Playout::model()->findByPk( $model->id );
        $this->assertInstanceOf( 'Playout', $newModel );
        
        $this->assertEquals( 0, count($newModel->layers), print_r($newModel->layers, true) );
        
        $this->assertTrue( $model->delete() );
    }
    
    public function testDependencyAppsSlide(  ) {
                
        $data = array (
            'name' => "some name",
            'keywords' => array( 'test', 'auto', 'delete' ),
            'layers' => array()
        );
        
        $appsData = Helpers::createApps( $this );      
        $m = array( 
            'id' => $appsData['id'],
            'query' => array(  ),
            'type' => 'apps',
            'widgetId' => $appsData['widgetIds'][0]
        );
        
        $data['layers'][] = array (
            'type' => 'playlist',
            'data' => array(
                'media' => array( $m )
            ),
            'args' => array(
                'top' => 0, 'left' => 0,
                'width' => 1920, 'height' => 1080
            )
        );
        
        $model = new Playout;
        $model->attributes = $data;
        $ok = $model->save();
        $this->assertTrue( $ok, print_r( $model->getErrors(), true ). print_r( $data, true ) );
        
        $this->assertFalse( $model->hasErrors() );
        $data['id'] = $model->id;
        
        $m = Apps::model()->findByPk( $appsData['id'] );
        Helpers::checkMediaParents( $this, $m->desc, $model->id );        
        Helpers::removeApps( $this, $appsData['id'] );
        
        $newModel =  Playout::model()->findByPk( $model->id );
        $this->assertInstanceOf( 'Playout', $newModel );
        
        $layers = $newModel->layers;
        $this->assertEquals( 1, count($layers), print_r($layers, true) );
        $this->assertArrayHasKey( 'data', $layers[0] );
        $this->assertArrayHasKey( 'media', $layers[0]['data'] );
        $media = $layers[0]['data']['media'];
        $this->assertTrue( is_array( $media ) );
        $this->assertEquals( 0, count( $media ) );
        
        $this->assertTrue( $model->delete() );
    }
    
    public function createErrorsProvider()
    {
        return array(
            array( array( // just name
                        'name' => 'utf8ä中企',
                        'keywords' => array( 'test', 'auto', 'utf8ä中企' ),            
                    ), null, true ),
            array( array( // name and option
                        'name' => 'simple',
                        'options' => array (
                            'dur' => 1,                                                        
                        )
                    ), null, true ),
            array( array( // one media
                        'name' => 'simple',
                ), array( 
                        array() 
                ), true ),            
            array( array( // no name
                    ), null, false ),
            array( array( // duration not a number
                        'name' => 'simple',
                        'options' => array (
                            'dur' => "24s",                                                        
                        )
                    ), null, false ),
            array( array( // wrong options
                        'name' => 'simple',
                        'options' => "dummy",                                                    
                    ), null, false ),
            array( array( 'name' => 'simple',
                ), array( // not an ID
                        array( 'type'=> 'playlist', 'media' => array (
                            array('id' => 'wrong', 'type'=>'media' ) 
                        ) )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( // not existing id
                        array( 'type'=> 'playlist', 'media' => array (
                            array('id' => 123456789, 'type'=>'media' ) 
                        ) )                        
                ), false ),
            array( array( 'name' => 'type',
                ), array( // wrong type
                        array( 'type'=> 'wrong', 
                                'id' => 123456789 
                        )                        
                ), false ),
            array( array( 'name' => 'apps',
                ), array( // not existing widget id
                        array( 'type'=> 'apps', 
                                'id' => 123456789 
                        )                        
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'args' => "dummy"
                     )
                ), false ),            
            );
    }
    /**
     * @dataProvider createErrorsProvider
     * @depends testDelete
     */
    public function testCreateErrors( $data, $layers, $success ) {
        $ids = array();
        if ( $layers ){
            $i = 0;
            for( $i=0; $i<count($layers); $i++ ){
                if ( !isset($layers[$i]['type']) ){
                    $layers[$i]['type'] = 'playlist';
                    $layers[$i]['data'] = array(
                        'media' => array( 
                            array( 'id' => Helpers::createPlaylist( $this, "media $i" ), 'type' => 'playlist' ) 
                            )
                    );
                    $ids[] = $layers[$i]['data']['media'][0]['id'];
                }
                if ( !isset($layers[$i]['args']) ){
                    $layers[$i]['args'] = array(
                        'top' => 0, 'left' => 0,
                        'width' => 1920, 'height' => 1080
                    );
                }
            }
            $data['layers'] = $layers;
        }        
        
        $model = new Playout;
        $model->attributes = $data;
        
        $ok = $model->save();
        
        if ( $success ){
            $this->assertTrue( $ok, print_r( $model->getErrors(), true ) . print_r( $data, true ) );
            $this->assertFalse( $model->hasErrors() );
        
            $data['id'] = $model->id;
            $this->checkDesc( $model->desc, $data );        
            $this->checkListDesc( $model->listDesc, $data );            
            $this->assertTrue( $model->delete() );
            
        } else {
            $this->assertFalse( $model->save(), "Expecting failure: ". print_r($data, true ) );        
            $this->assertTrue ( $model->hasErrors() );            
        }
        if ( $layers ){
            foreach ( $ids as $id ){                
                $model = Resource::model()->findByPk($id );
                $this->assertInstanceOf( 'Resource', $model );                
                $this->assertTrue( $model->delete() );
            }
        }
    }
}
