<?php

require_once dirname(__FILE__).'/../../../utils/WebStorageAPI.php';
/**

 */
class Apps extends Resource
{
    protected $_description = false;
    protected $_widgets = false;
    
    var $_apps = null;
    
    static $appsFile = "apps.json";
    static protected $iconFile = "icon.svg";
    static protected $widgetsPath = "widgets/";
    static protected $interfacePath = "interface/";
    static protected $widgetConfigFile = "widget.json";
    static protected $widgetRenderFile = "widget.svg";
    static protected $widgetPreviewFile = "preview.svg";
    
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{		
        $rules = parent::rules();
        $rules[] = array('appsFile', 
                'file', 'types'=>'7z', 'allowEmpty'=>false, 'on'=>'create' );
        
		return $rules;        
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'id',
		);
	}

    public function init(){
        parent::init();
        $this->type = "apps"; 
    }
    public function defaultScope(){
        return array(
            'condition'=>"type='apps'",
        );
    }
    protected function getFirstText( $dom, $tag ){
        $titles = $dom->getElementsByTagName( $tag );
        foreach( $titles as $title ) {
            if ( !empty($title->textContent) ) {
                $first = substr( trim($title->textContent), 0, 1 );
                if ( $first!="{" && $first!="[" && $first!="#" ) {
                    return trim($title->textContent);                    
                }
            }
        }
        return "";
    }
    protected function getFonts() {
        $fontsFolder = "/etc/spxmanage/fonts/conf.d/";
        $fontsFiles = array( "msttcorefonts.info", "noto-fonts.info", "noto-cjk.info");
        
        $fonts = array();
        foreach ( $fontsFiles as $fontsFile ){
            $file = file_get_contents($fontsFolder . $fontsFile);
            $json = json_decode($file, true);
            foreach ( $json[  "user-families" ] as $value ){
                $family = "\"" . $value["family"] . "\"";
                foreach ( $value["fallbacks"] as $f ){
                    $family .= ",\"$f\"";
                }
                $fonts[] = array( 'name' => $value["family"], 'value' => $value["family"], 'preview' => $family );
            }            
        }
        return $fonts;
    }
    public function getWidgetOptions( $dom ) {
        
        $options = array();
        // List of reagions to be translated
        $regions = array(
            I18N::i( "Africa" ), 
            I18N::i( "America" ), 
            I18N::i( "Antarctica" ), 
            I18N::i( "Arctic" ), 
            I18N::i( "Asia" ), 
            I18N::i( "Atlantic" ), 
            I18N::i( "Australia" ), 
            I18N::i( "Europe" ), 
            I18N::i( "Indian" ), 
            I18N::i( "Pacific" ), 
            I18N::i( "Argentina" ), 
            I18N::i( "Indiana" ), 
            I18N::i( "Kentucky" ), 
            I18N::i( "North Dakota" )             
        );
        // open the widgetfile
        $params = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "properties");        
        $entrys = array();
        foreach( $params as $param ) {            
			for ( $item=$param->firstChild; $item!=null; $item=$item->nextSibling ) {
				if ( $item->nodeType==XML_ELEMENT_NODE ) {
                    if ( $item->localName=='group' ) {
                        $base = $item->getAttribute("name");
                        for ( $item2=$item->firstChild; $item2!=null; $item2=$item2->nextSibling ) {
                            if ( $item2->nodeType==XML_ELEMENT_NODE ) {
                                $name = $item2->getAttribute("name");
                                if ( $name == 'Visible' ){                                    
                                    $item2->setAttribute("name", $base);
                                } 
                                $entrys[ $base .":". $name] = $item2;
                            }
                        }
                    } else {
                        $name = $item->getAttribute("name");
                        $entrys[ $name ] = $item;
                    }
				}
			}
        }
        foreach ($entrys as $name => $entry) {
            if ( substr($entry->localName, 0, 4) == "json" )
                $type = substr($entry->localName, 5);
            else
                $type = $entry->localName;
            
            if ( $type==='data' )
                $type = 'string';
            if ( $type==='integer' )
                $type = 'number';
            if ( !$entry->getAttribute("query") )
                continue;
            if ( !in_array($type, array('string', 'text', 'number', 'boolean', 'choice', 'color') ) ) 
                continue;
            $option = array();
            $option['name'] = $entry->getAttribute("name");
            $option['ui'] = $entry->getAttribute("ui") == "enabled";
            $option['desc'] = $entry->getAttribute("desc");
            $option['type'] = $type;
            if ( $entry->hasAttribute("default") ){
                $option['default'] = $entry->getAttribute("default");
            }

            if ( $type==='number' ){
                if ( $entry->hasAttribute("min") )
                    $option['min'] = (float)$entry->getAttribute("min");
                if ( $entry->hasAttribute("max") )
                    $option['max'] = (float)$entry->getAttribute("max");
                if ( $entry->hasAttribute("step") )
                    $option['step'] = (float)$entry->getAttribute("step");
                if ( isset($option['default']) ){
                    $option['default'] = (float)$option['default'];
                }
            }
            if ( $type==='number' && isset($option['min']) && isset($option['max']) ){
                $option['type'] = $type = 'slider';
            }
            if ( $type==='boolean' ){
                if ( $entry->hasAttribute("true") )
                    $option['true'] = $entry->getAttribute("true");
                if ( $entry->hasAttribute("false") )
                    $option['false'] = $entry->getAttribute("false");
                if ( isset($option['default']) ){
                    $option['default'] = $option['default'] === "true";
                }
            }            
            if ( $type==='choice' ){
                $select = array();
                if ( $entry->hasAttribute("choice") ){
                    if ( $entry->getAttribute( "choice" ) == 'fonts' ){
                        $option['select'] = $this->getFonts();
                    } else {
                        $option['type'] = $entry->getAttribute( "choice" );
                    }                    
                } else {
                    $i = 1 ;
                    if ( $entry->hasAttribute("choice-1") )
                        $add = false;
                    else 
                        $add = true;
                    $idx = ($i<10&&$add)?"0".$i:$i;

                    while ( $entry->hasAttribute("choice-".$idx) ){
                        $val = array( "value" => $entry->getAttribute( "choice-".$idx ) );
                        if ( $entry->hasAttribute("name-".$idx) ){
                            $val['name'] = $entry->getAttribute( "name-".$idx );
                        } else {
                            $val['name'] = $entry->getAttribute( "choice-".$idx );
                        }
                        $select[] = $val;
                        $i++;
                        $idx = ($i<10&&$add)?"0".$i:$i;
                    }
                
                    if ( count($select) == 2 
                            && ( $select[0]['value']=='yes' || $select[0]['value']=='no' )
                            && ( $select[1]['value']=='yes' || $select[1]['value']=='no' )){
                        $option['type'] = 'boolean'; 
                        $option['true'] = $select[0]['value']=='yes' ? $select[0]['name']:$select[1]['name'];
                        $option['false'] = $select[0]['value']=='no' ? $select[0]['name']:$select[1]['name'];
                    } else if ( count($select)>0 ){
                        $option['select'] = $select;                    
                    } else {
                        $option['type'] = 'string';
                    } 
                }
            }
            $q = $entry->getAttribute("query");
            
            $options[ $q ] = $option;
        }
        return $options;
    }
    public function createWidgetPreview( $folder ) {
        $renderFile = $folder . self::$widgetRenderFile;
        $previewFile = $folder . self::$widgetPreviewFile;
        Yii::log("Creating preview for: ".$renderFile, 'info', 'spx.apps');
        if ( !file_exists($renderFile) ){
            Yii::log("Cannot find ".$renderFile, 'warning', 'spx.apps');
            return false;
        }
        $cnt = file_get_contents( $renderFile );        
        $cntFixedPath = str_replace("http://download.spinetix.com/spxjslibs/", "/spxjslibs/", $cnt);
        $cntFixedScripts = preg_replace_callback("/<script\s+xlink:href\s*=\s*\"([^\"\?]+(\?[^\"]+)?)\"\s*\/>/", function ($matches) {                        
            $uri = $matches[1];
            if ( count( $matches ) == 3 && !empty($matches[2])  ) {
                return "<script xlink:href=\"" . $uri . "&amp;_=".uniqid()."\"/>";
            } else {
                return "<script xlink:href=\"" . $uri . "?_=".uniqid()."\"/>";
            }
        }, $cntFixedPath);
        $xml = '<?xml version="1.0" encoding="UTF-8"?>';
        $cntCSS = str_replace($xml, $xml . "\n" . '<?xml-stylesheet href="/api/fonts/system/font-faces.css" type="text/css"?>', $cntFixedScripts);        
        return file_put_contents( $previewFile, $cntCSS );
    }
    public function createWidgetConfig( $folder, $name ) {
        $renderFile = $folder . self::$widgetRenderFile;
        $configFile = $folder . self::$widgetConfigFile;
        $config = array();
        
        Yii::log("Creating config for: ".$renderFile, 'info', 'spx.apps');
        if ( !file_exists($renderFile) ){
            Yii::log("Cannot find ".$renderFile, 'warning', 'spx.apps');
            return false;
        }
        $cnt = file_get_contents( $renderFile );
        $dom = new DOMDocument;
        if ( @$dom->loadXML( $cnt )===false ){
            Yii::log("Cannot load XML for: ".$renderFile, 'warning', 'spx.apps');
            return false;
        }
        $svg = $dom->documentElement;
        if ( !$svg ) {
            Yii::log("Cannot find SVG for: ".$renderFile, 'warning', 'spx.apps');
            return false;
        }
        
        $config['name'] = $this->getFirstText( $dom, "title" );
        if ( $config['name'] == "" )
            $config['name'] = ucfirst( $name );
        
        $config['desc'] = $this->getFirstText( $dom, "desc" );        
        
        if ( $svg->hasAttribute("width") ){
            $config['fixed'] = "width"; 
        }
        if ( $svg->hasAttribute("height") ){
            if ( !isset($config['fixed']) )
                $config['fixed'] = "height";
            else
                $config['fixed'] = "all"; 
        }
        
        if ( $svg->hasAttribute("viewBox") ){
            if ( !isset($config['fixed']) )
                $config['fixed'] = "aspect"; 
            if ( !isset($config['width']) || !isset($config['height']) ){
                $dim = explode(" ", $svg->getAttribute("viewBox") );
                if ( count($dim)==4 ) {
                    $config['width'] = $dim[2];
                    $config['height'] = $dim[3];
                }
            }
        }
        if ( $svg->hasAttribute("dur") && $svg->getAttribute("dur")!='indefinite' ){
            $config['type'] = "slide";
        } else if ( isset($config['fixed']) && $config['fixed'] != "aspect" ){
            $config['type'] = "layer";
        }
        
        $config['options'] = $this->getWidgetOptions( $dom );
        Yii::log("Apps created with ".print_r($config, true), 'info', 'spx.apps');
        return file_put_contents( $configFile, json_encode( $config) );        
    }
    public function widgetPath( $name, $what = "" ) {
        if ( $what == "config" )
            return self::$widgetsPath . $name ."/". self::$widgetConfigFile;
        if ( $what == "render" )
            return self::$widgetsPath . $name ."/". self::$widgetRenderFile;
        if ( $what == "preview" )
            return self::$widgetsPath . $name ."/". self::$widgetPreviewFile;
        return self::$widgetsPath . $name ."/";
    }
    public function loadApps( $list = true, $force = false ) {
        if ( !$force && $this->_description !== false && $list )
            return true;
        $path = $this->getFolder();
        if ( !$path ) {
            $this->addError( 'description', "folder not found" );
            return false;
        }
        if ( !file_exists( $path . self::$appsFile )){
            $this->addError( 'description', "config file missing" );
            return false;
        }
        $apps = file_get_contents( $path . self::$appsFile );
        if ( empty($apps) ){
            $this->addError( 'description', "config file empty" );
            return false;
        }
        $config = json_decode( $apps, true );
        if ( !$config ){
            $this->addError( 'description', "config not valid" );
            return false;
        }

        if ( isset( $config['desc'] ) )
            $this->_description = $config['desc'];
        else
            $this->_description = "";
        
        if ( $list || ( !$force && $this->_widgets ) )
            return true;
        $scriptModTime = filemtime(__FILE__);
        if ( isset( $config['widgets'] ) ){
            $widgets = $config['widgets'];
            $this->_widgets = array();
            
            foreach ( $widgets as $name ){
                if ( file_exists( $path . self::$widgetsPath . $name ) ){                    
                    $configFile = $path . $this->widgetPath( $name, "config");
                    if ( !file_exists( $configFile ) || filemtime($configFile) < $scriptModTime ) {                        
                        // config do not exist, must create it now
                        if ( !$this->createWidgetConfig( $path . $this->widgetPath( $name ), $name ) )
                            continue;
                    }
                    $widget = json_decode( file_get_contents( $configFile ), true );                    
                    $widget['href'] = GlobalSettings::$hrefBase . $this->getLink() . 
                                      $this->widgetPath( $name, 'render' ); 
                    
                    $previewFile = $path . $this->widgetPath( $name, "preview");
                    if ( !file_exists( $previewFile )|| filemtime($previewFile) < $scriptModTime ){
                        if ( !$this->createWidgetPreview( $path . $this->widgetPath( $name ) ) )
                            continue;
                    }
                    $widget['preview'] = GlobalSettings::$uriBase. $this->getLink() .
                                            $this->widgetPath( $name, 'preview' );   
                    if ( $this->hasInterface() && !isset( $widget['options'][ 'variable' ] ) ){
                        $widget['options'][ 'variable' ] = array( 
                            'type' => 'string',
                            'name' => "Shared Variable"
                        );
                    }
                    $this->_widgets[$name] = $widget;       
                } else {
                    $this->addError( 'widgets', "widget not found" .": $name" );
                }
            }            
        } else {
            $this->addError( 'widgets', "no widgets found" );            
            return false;
        }
                
        return true;
    }

    public function getDescription() {
        $this->loadApps();
        return $this->_description;        
    }
    public function getWidgets() {
        $this->loadApps( false );
        return $this->_widgets;
    } 
    public function getWidget( $widgetId ) {
        $this->loadApps( false );
        if ( isset( $this->_widgets[$widgetId] ) )
            return $this->_widgets[$widgetId];
        return null;
    } 
    public function getIcon() {
        $path = $this->getFolder();
        if ( !file_exists( $path . self::$iconFile ) ) {
            copy( GlobalSettings::$systemMedia.self::$iconFile, $path.self::$iconFile );
        }
        return GlobalSettings::$uriBase. $this->getLink() . self::$iconFile;
    }
    public function hasInterface() {
        return file_exists( $this->getFolder() . self::$interfacePath ."index.html");
    }
    public function getUri() {
        if ( $this->hasInterface() )
            return parent::getUri() . self::$interfacePath;
        else 
            return null;
    }
    public function getView() {
        if ( $this->hasInterface() )
            return file_get_contents ( $this->getFolder() . self::$interfacePath . "index.html" );
        else 
            return "";
    }
    /*
    public function getVariable() {
        if ( $this->hasInterface() ) 
            return "spx.". $this->id . ".values";
        else 
            return null;
    }
    */
    public function setAppsFile( $name = null ) {
        if ( !$name )
            $this->_apps = CUploadedFile::getInstance( $this, 'file' );
        else if ( is_array($name) )
            $this->_apps = new UploadedFileTest( $name );
        else if ( $name=="PUT" )
            $this->_apps = new UploadedFilePut();
        else
            $this->_apps = CUploadedFile::getInstanceByName( $name );
    }
    public function getAppsFile( ){
        return $this->_apps;
    }
    
    public function removeChild( $childId, $delayPreview = false ) {
        return true;
    }

    public function getListDesc( $preview = true  ) {
        // should translate the name of the apps and the description, for the moment we use the 
        // translation file, but this is higly un-efficients, as many files must be read when 
        // listing apps. 
        
        $listDesc = array(
            'id' => $this->id,
            'name' => I18N::appsName( $this->getFolder(), $this->name ),
            'desc' => I18N::appsName( $this->getFolder(), $this->getDescription() ),
            'type' => 'apps',
            'keywords' => $this->keywords,
            'icon' => $this->getIcon(),
            'manage' => $this->getManage(),
            'modified' => $this->modified,
            'uri' => $this->getUri()
        );        
        
        return $listDesc;
    }
    public function getDesc( $parents = true, $short = false ) {
        $description = $this->getListDesc(); 
        $description['widgets']= $this->getWidgets();
        $description['i18n'] = I18N::apps( $this->getFolder() ); 
        if ( $parents ) {
            foreach ( $this->parents as $parent ){
                $description['parents'][] = $parent->getListDesc( false );
            }
        }
        
        return $description;
    }    
    public function recover( $file = null ){
        
        $path = $this->getFolder();
        $appsFilename = $path . self::$appsFile;    
        $recover = parent::recover($appsFilename);
        
        if ( !$recover ) {
            $this->loadApps( false );
            if ( $this->hasErrors() ){
                $this->deleteRecover();
                return true;
            }
        }
        return $recover;
    }
    public function afterSave(){
        
        parent::afterSave();
        
        if ( $this->_apps !== null ) {
            if ( !$this->getIsNewRecord() ){
                throw new Exception( "cannot add data" );
            }
            if ( $this->_apps->type == 'dir' ){
                // for unit testing and backup
                rmdir( $this->getFolder() );
                rename($this->_apps->tempName, $this->getFolder() );                
            } else {
                $zip = new ZipHandler;
                if ( $zip->open( $this->_apps->tempName, $this->_apps->extensionName , false  ) ){
                    if ( $zip->extractTo( $this->getFolder() ) === false ){
                        $this->addError('apps', $zip->error );
                        throw new Exception( "create failed" );
                    }
                } else {
                    $this->addError('apps', $zip->error );
                    throw new Exception( "create failed" );
                }   
                if ( !$this->loadApps( false, true ) ){
                    $this->addError('apps', I18N::t("Loading failed") );
                    throw new Exception( "create failed" ); 
                }
            }
            // should check that the apps is signed and valid
        }
    }
    /*
    public function afterDelete(){
        
        parent::afterDelete();
        $variable = $this->getVariable();
        // clear the variable from the storage to not leave mess behind
        if ( $variable ) {
            $storage = new WebStorageAPI();        
            $storage->remove( $this->getVariable() );
        }
    }     
     */
    
    /**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Apps the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    
}
