<?php
function decode($string) {
    $string=preg_replace(
        array('/"\s+"/','/\\\\n/','/\\\\r/','/\\\\t/','/\\\\"/'),
        array('',"\n","\r","\t",'"'),
        $string
    );
    return substr(rtrim($string),1,-1);
}
function load($file,$context){
    $pattern='/(msgctxt\s+"(.*?(?<!\\\\))")?\s+'
        .'msgid\s+((?:".*(?<!\\\\)"\s*)+)\s+'
        .'msgstr\s+((?:".*(?<!\\\\)"\s*)+)/';
    $matches=array();
    $n=preg_match_all($pattern,file_get_contents($file),$matches);

    $messages=array();
    for($i=0; $i<$n; $i++)
    {
        if($matches[2][$i]===$context)
        {
            $id=decode($matches[3][$i]);
            $message=decode($matches[4][$i]);
            $messages[$id]=$message;
        }
    }
    return $messages;
}
$path = dirname(__FILE__).DIRECTORY_SEPARATOR.'protected'.DIRECTORY_SEPARATOR.'messages'.DIRECTORY_SEPARATOR;

header( "Content-Type: application/javascript; charset=utf-8");
header( "Cache-Control: max-age=7200");


if (isset($_GET['lang']) && file_exists( $path.$_GET['lang'].DIRECTORY_SEPARATOR."app.po" ) ){
    
    $messages = load($path.$_GET['lang'].DIRECTORY_SEPARATOR."app.po", 'app');
    //echo "$(function(){\n";
    echo "_spxapi_locale_keys = {\n";
    foreach ($messages as $key => $value ){
        if ( !empty( $value ) ){
            echo "\t\t\"$key\": \"".strtr($value, '"', '\'')."\",\n";
        } 
    }
    echo "\t};\n";    
    echo "console.log(\"Language loaded\");\n";
} else {
   echo "_spxapi_locale_keys = {};\n"; 
}
