<?php
/* @var $this ReportingController */
if (!$screenInfo->monitors) {
    echo BsHtml::alert(BsHtml::ALERT_COLOR_INFO, 'No displays detected.');
    return;
}

if (count($screenInfo->monitors) > 1) {
    $headers = array('Video Output', 'Settings', 'Perfect Sync', 'Top', 'Left');
    $table = array();

    foreach ($screenInfo->monitors as $monitor) {
        $table[] = array(
            $monitor['outputLabel'],
            $monitor['settings'],
            $monitor['sync'],
            $monitor['y'],
            $monitor['x'],
        );
    }

    echo BsHtml::alert(
        BsHtml::ALERT_COLOR_INFO,
        $formConfig->table(
            $headers, 
            $table, 
            array('sizes' => array('', '', '', '', ''))
        ),
        array('closeText' => false , 'class' => 'table-responsive'),
    );
} else {
    $monitor = $screenInfo->monitors[0];
    $data = array();
    if ( isset( $monitor['settings'] ) ) {
        $data[] = array( 'label'=>"Settings", 'value' => $monitor['settings'] );
    }
    $data[] = array('label' => 'Status', 'value' => $monitor['text']);
    $data[] = array('label' => 'Perfect Sync', 'value' => $monitor['sync']);
    $info = $this->widget(
        'DataTable',
        array('data' => $data, 'title' => 'Detected Display'),
        true
    );
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $info );
}
