<?php
class UPnPConfig extends CFormModel
{
    public $file = "/etc/default/spxmanage-spxupnpd";

    var $enabled = 0;

    public function rules()
    {
        $res = array(array("enabled", 'safe'));
        return $res;
    }
    public function attributeLabels()
    {
        return array(
            'enabled' => 'Enable SSDP / UPnP',
        );
    }
    function getStatus($conf)
    {
        if (preg_match("/ENABLEUPNP=(.*)/", $conf, $matches)) {
            if ($matches[1] == 'yes') {
                return 1;
            }
        }
        return 0;
    }
    function load()
    {
        $conf = file_get_contents($this->file);
        $this->enabled = $this->getStatus($conf);
    }

    function save()
    {
        $this->enabled = intval($this->enabled);
        $conf = file_get_contents($this->file);
        $wasEnabled = $this->getStatus($conf);
        if ($wasEnabled == $this->enabled) {
            return;
        }

        $val = $this->enabled ? "yes" : "no";
        Tools::save_file(
            $this->file,
            preg_replace("/ENABLEUPNP=.*/", "ENABLEUPNP=$val", $conf)
        );

        if (
            !Tools::setSafeModeData(
                "discovery-upnp",
                "ENABLEUPNP=" . $val . "\n",
                false
            )
        ) {
            $this->addError(
                'file',
                'Failed saving discovery-upnp configuration for recovery console, please try again.'
            );
            return false;
        }

        Tools::addReason("UPnP " . ($this->enabled ? "enabled" : "disabled"));
    }
}
