<?php
class LLMNRConfig extends CFormModel
{
    public $file = "/etc/default/llmnrd";

    var $enabled = 0;

    public function rules()
    {
        $res = array(array("enabled", 'safe'));
        return $res;
    }
    public function attributeLabels()
    {
        return array(
            'enabled' => 'Enable Windows compatible name resolution (LLMNR)',
        );
    }
    function getStatus()
    {
        if (!file_exists($this->file)) {
            return 1;
        }
        $conf = file_get_contents($this->file);
        if (preg_match("/DISABLE_LLMNRD=(.*)/", $conf, $matches)) {
            if ($matches[1] == '1') {
                return 0;
            }
        }
        return 1;
    }
    function load()
    {
        $this->enabled = $this->getStatus();
    }

    function save()
    {
        $this->enabled = intval($this->enabled);
        $wasEnabled = $this->getStatus();
        if ($wasEnabled == $this->enabled) {
            return;
        }
        if ($this->enabled) {
            unlink($this->file);
            Tools::setSafeModeData("llmnr", null);
        } else {
            Tools::save_file($this->file, "DISABLE_LLMNRD=1\n");
            Tools::setSafeModeData("llmnr", "DISABLE_LLMNRD=1\n", false);
        }

        Tools::addReason("LLMNR " . ($this->enabled ? "enabled" : "disabled"));
    }
}
