<?php

class MyHttpRequest extends CHttpRequest {
    
    /**
	 * Performs the CSRF validation ONLY on POST requests
	 * This is the event handler responding to {@link CApplication::onBeginRequest}.
	 * The default implementation will compare the CSRF token obtained
	 * from a cookie and from a POST field. If they are different, a CSRF attack is detected.
	 * @param CEvent $event event parameter
	 * @throws CHttpException if the validation fails
	 */
    
    public function validateCsrfToken($event)
	{
		if ($this->getIsPostRequest() )
		{
			$cookies=$this->getCookies();
			$userToken=$this->getPost($this->csrfTokenName);
			if (!empty($userToken) && $cookies->contains($this->csrfTokenName))
			{
				$cookieToken=$cookies->itemAt($this->csrfTokenName)->value;
				$valid=$cookieToken===$userToken;
			}
			else {
                if (strncmp($this->getContentType(), 'application/json', 16) === 0)
                {
                    $valid = true;
                }
                else
                {
                    $valid = false;
                }
            }				
			if (!$valid)
				throw new CHttpException(400,Yii::t('yii','The CSRF token could not be verified.'));
		}
	}
}