<?php

class AssetsCommand extends CConsoleCommand {
    
    var $defaultAction = 'update';
    
    public function actionClear() { 
        $dbname = "/srv/raperca/interface/protected/assets.db";
        if (file_exists( $dbname ) )
            unlink ($dbname);
        $dbname2 = "/var/lib/spxmanage/ui/ui.db";
        if (file_exists( $dbname2 ) )
            unlink ($dbname2);
        if ( file_exists( GlobalSettings::$fileBase ) )
            GlobalSettings::rrmdir( GlobalSettings::$fileBase, false );
    }
    public function actionUpdate() { 
        
        $dir = "/usr/share/spxassets/";
        if ( !file_exists($dir) ){
            syslog(LOG_NOTICE, "assets dir not found: ".$dir );
            if( PHP_OS == "WINNT" ) {
                echo "assets dir not found: ".$dir."\n";
            }
            return;
        }
        try {
            if ( Actions::getAction( 'recovery needed' ) ){
                $this->actionRecover();
            }
        } catch (CDbException $e){
            
        }
        $resourceBackup = new ResourceBackup;
        $resourceBackup->allowNewApps = true;
        $objects = scandir( $dir );
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                $base = $dir . $object . "/";
                if (filetype( $base ) == "dir"){
                    $ret = $resourceBackup->checkVersion( $base );
                    if ( $ret === true ){
                        syslog(LOG_NOTICE, "checking: ".$object." -> processing" );
                        if( PHP_OS == "WINNT" ) {
                            echo "checking: ".$object." -> processing\n";
                        }
                        $resourceBackup->filepath = $base. "app.7z";
                        $resourceBackup->restore( );
                        if( PHP_OS == "WINNT" ) {
                            echo implode("\n",$resourceBackup->actions) ."\n";
                        }
                        if ( $resourceBackup->hasErrors() || ( defined('YII_DEBUG') && YII_DEBUG ) ){
                            syslog(LOG_NOTICE, implode("\n",$resourceBackup->actions) );
                        }
                        
                        if ( $resourceBackup->hasErrors() ){
                            $str = "";
                            foreach ( $resourceBackup->getErrors() as $name=> $value ){
                                $str .= implode("; ",$value);
                            }
                            syslog(LOG_WARNING, $str);
                            if( PHP_OS == "WINNT" ) {
                                echo $str ."\n";
                            }  
                            $resourceBackup->clearErrors();
                        }
                        
                    } else if ( $ret === false ){
                        syslog(LOG_NOTICE, "checking: ".$object." -> skip\n" );
                        if( PHP_OS == "WINNT" ) {
                            echo "checking: ".$object." -> skip\n";
                        }
                    } else {
                        syslog(LOG_NOTICE, "checking: ".$object." -> $ret\n" );
                        if( PHP_OS == "WINNT" ) {
                            echo "checking: ".$object." -> $ret\n";
                        }
                    }
                    $resourceBackup->actions = array();
                } 
            }
        }        
        return 0; // exit successfully
    }
    
    public function actionRecover() {  
        if( PHP_OS == "WINNT" ) {
            echo "Starting recover()\n";
        }
        $types = array( "apps", "template", "media", "playout");
        foreach ( $types as $type ){
            $models = Resource::loadAll( $type );             
            if ( $models !== null ){
                foreach($models as $model) {                 
                    if ( !$model->uuid ){
                        continue;
                    }
                    try {
                        $ret = $model->recover();
                        if ( $ret ){
                            syslog(LOG_NOTICE, "recovered: ". $type .": ".$model->name);
                            if( PHP_OS == "WINNT" ) {
                                echo "recovered: ". $type .": ".$model->name."\n";
                            }
                        }
                    } catch(Exception $e) {
                        syslog(LOG_NOTICE, "recovered: ". $type .": ".$model->name. "(".$e->getMessage().")");
                        if( PHP_OS == "WINNT" ) {
                            echo "recovered: ". $type .": ".$model->name. " (".$e->getMessage().": ".print_r($model->errors,true).")"."\n";
                        }                        
                    }                    
                }
            }
        }
    }
    
    public function actionStartup() {
        /* 
         * if the "content not synced" flag is set, sets the "recovery needed" flag.
         * (note that it should never clear either of the flags).        
         */
        if (file_exists( '/srv/raperca/interface/protected/assets.db' )){
            try {
                if ( Actions::getAction( 'content not synced' ) ){
                    Actions::setAction( 'recovery needed', true );
                }
            } catch( Exception $e ) {
                syslog(LOG_NOTICE, "Action table not found: (".$e->getMessage().")");
                if( PHP_OS == "WINNT" ) {
                    echo "Action table not found: (".$e->getMessage().")"."\n";
                } 
            }
        } 
    }
    public function actionShutdown() { 
        /*
         * clear the "content not synced" flag ( leaves the "recovery needed" flag alone)
         */
        if ( Actions::getAction( 'content not synced' ) ){
            Actions::setAction( 'content not synced', false );
        }
    }
    public function actionStatus() { 
        $models = Actions::model()->findAll( );
        foreach( $models as $model ){
            echo $model->name .': '. $model->realValue . " (".$model->value.")\n";
        } 
    }
}