<?php

class DialogButton extends ActionButton {
    
    var $content;
    var $level = BsHtml::ALERT_COLOR_INFO;
    var $rowOptions;
    public function init()
    {
        if ( $this->content === null )
            ob_start();
    }
    public function run()
    {
        if ( $this->content === null ) {
            $this->content = ob_get_contents ( );
            ob_end_clean();
        }
        $cols = array();
        if ( $this->content === false ){
            $offsets = array( 'sm' => 6, 'md' => 9 );
        } else {
            $cols[] = array( 'sizes' => array( 'md' => 9 ), 
                    'content' => BsHtml::alert( $this->level, $this->content, array( 'closeText' => false ))
            );
            $offsets = array( 'sm' => 6, 'md' => 0, 'lg' => 0 );
        }
        $this->block = true;
        ob_start();
        parent::run();
        $button = ob_get_contents ( );
        ob_end_clean();
        if ( $this->content !== false ){
            $options = array( 'class' => 'spx-button-comment-oneline');
        } else {
            $options = array( );
        }
        $cols[] = array( 'sizes' => array( 'sm' => 6, 'md' => 3 ), 'offsets' => $offsets, 
            'options' => $options,
            'content' => $button
        );
        if ( $this->content !== false ){
            $this->controller->addClass( $this->rowOptions, "spx-button-comment" );
        }
        $this->controller->widget('BsRow', array( 'options' => $this->rowOptions, 'cols' => $cols ));  
    }
}