<?php

/**
 * This is the model class for table "Media".
 */
class Media extends AssetsActiveRecord
{   
    protected $exe = "cd /srv/raperca && raperca";
    var $_uploadedfile = null;
    static $mime2ext = array (
        "image/jpg" => "jpg",
        "image/jpeg" => "jpg",        
        "image/png" => "png",
        "image/x-png" => "png",
        
        'video/mp4' => 'mp4',
        'video/x-m4v' => 'm4v',        
        
        'video/x-msvideo' => 'avi',
        'video/avi' => 'avi',
        
        'video/quicktime' => 'mov',
        
        'video/x-matroska' => 'mkv',
        'application/x-matroska' => 'mkv',        
        
        'video/MP2T' => 'ts',
        'video/vnd.dlna.mpeg-tts' => 'ts',
        
        'video/dvd' => 'vob',
        'video/mpeg' => 'vob',
        'video/mpeg-system' => 'vob',
        
        'video/MP2P' => 'm2p',
        
        'video/x-ms-wmv' => 'wmv',
        'audio/x-ms-wma' => 'wma',
        
        'audio/mpeg' => 'mp3', 
        'audio/mpg'=> 'mp3',
        'audio/mpeg3'=> 'mp3',
        'audio/mp3' => 'mp3'
    );
    function init() {
        parent::init();
        if( PHP_OS == "WINNT" ) {
            $this->exe = "C:\\SpinetiX\\sources\\genesis\\trunk\\user\\hmd\\bin_d\\raperca.exe";
            if ( !file_exists( $this->exe ) ){
                $this->exe = "\"C:\\Program Files (x86)\\SpinetiX\\Elementi\\Elementi\\bin\\raperca.exe\"";
            }        
        } else if (file_exists('/opt/sysroot/usr/local/lib/liblive555.so.0')) {
            // this is a Bonsai/Sakura system hacked as Ikebana, need special LD_LIBRARY_PATH
            $this->exe = "cd /srv/raperca && LD_LIBRARY_PATH=/opt/sysroot/lib:/opt/sysroot/usr/lib:/opt/sysroot/usr/local/lib raperca";
        } else {
            $this->exe = "cd /srv/raperca && raperca";
        }
    }
	/**
	 * @return string the associated database table name
	 */
	public function tableName() {
		return 'Media';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
        $format = 'jpeg, jpg, png, mpg, mp4, m4v, mov, wmv';
        if ( Yii::app()->branding->product !== "DiVA" ) {
            $format .= ", jpe, jif, jfif, jfi, avi, vob, ts, m2p, mkv";
        }
        /*
        $rules = $this->resource->rules();
        $rules[] = array('file', 
                'file', 'types'=>'jpg, png, mp4, avi, mov, mp3', 'allowEmpty'=>true );
        $rules[] = array('dur', 'numerical', 'integerOnly'=>false);
        $rules[] = array('fileName, mimeType', 'length', 'max'=>64);
        $rules[] = array('dimension', 'length', 'max'=>10);
        $rules[] = array('aspectRatio', 'length', 'max'=>5);
		return $rules;
        */
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('id, fileName, mimeType', 'required'),
            array('file', 
                'file', 'on' => 'file', 'types'=>$format, 'allowEmpty'=>true ),
			array('id', 
                'numerical', 'integerOnly'=>true),
			array('dur', 
                'numerical', 'integerOnly'=>false),
			array('fileName, mimeType', 
                'length', 'max'=>64),
			array('dimension', 
                'length', 'max'=>10),
			array('aspectRatio', 
                'length', 'max'=>5),			
            array('hidden', 
                'boolean'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
            'resource' => array( self::BELONGS_TO, 'Resource', array( 'id'=>'id' ) ),
		);
	}
    
    public function getResource(){        
        return $this->resource;
    }
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'id',
            'file' => 'file',
			'fileName' => 'fileName',
            'mimeType' => 'mimeType',
			'dur' => 'dur',
			'dimension' => 'dimension',
			'aspectRatio' => 'aspectRatio',
		);
	}
    public function getParents() {
        return $this->resource->parents;
    }
    public function getLink( ) {
        return Resource::resourceLink(  $this->id, 'media' );        
    }
    public function getManage( ) {
        return $this->resource->manage;        
    }
    public function getHref() {
        return $this->resource->getHref() . $this->fileName;
    }
    public function getMedia( ) {
        $file = $this->resource->getFolder() . 'full_'.$this->fileName; 
        if (file_exists( $file) ){
            $lastMod = filemtime( $file ); 
            return $this->resource->getUri() . 'full_' . $this->fileName ."?_=".$lastMod;
        } else {
            $file = $this->resource->getFolder() . $this->fileName; 
            $lastMod = @filemtime( $file ); 
            return $this->resource->getUri() . $this->fileName."?_=".$lastMod;
        }
    }
    public function getType() {
        return $this->resource->type;
    }
    public function getName() {        
        return $this->resource->name;
    }
    public function getUuid() {        
        return $this->resource->uuid;
    }
    public function getListDesc( $preview=true ) {
        if ( $this->resource ) {
            $description = array(
                'id' => $this->id,
                'name' => $this->resource->name,
                'mimeType' => $this->mimeType,
                'type' => 'media',
                'href' => $this->href,
                'manage' => $this->getManage(), 
                'modified' => $this->resource->modified,
                'keywords' => $this->resource->keywords
            );
            if ( $this->isImage() ){
                $description['img'] = $this->getMedia();
            }
            if ( $this->dur )
                $description['dur'] = $this->dur;
            if ( $this->dimension )
                $description['dimension'] = $this->dimension;
            if ( $this->aspectRatio )
                $description['aspectRatio'] = $this->aspectRatio;
            if ( $preview ) {
                $previews = $this->previews;
                if ( count( $previews ) )
                    $description['previews'] = $previews;
            }
            if ( $this->hidden ){
                $description['hidden'] = true;
            }
        } else {
            $description = array(
                'id' => $this->id,
                'name' => 'bad',
                'type' => 'media',
                'mimeType' => $this->mimeType,
                'href' => $this->href,
                'manage' => "",    
                'modified' => $this->resource->modified,
            );
        }
        return $description;
    }
    
    public function getDesc( $parents = true, $short = false ) {
        $description = $this->getListDesc( $parents );
        if ( $parents ) {
            foreach ( $this->parents as $parent ){
                $description['parents'][] = $parent->getListDesc( false );
            }
        }
        return $description; 
    }
    
    public function getFile(){
        return $this->_uploadedfile;
    }
    public function isImage(){
        $mime = explode("/", $this->mimeType );
        if ( count( $mime )==2 && $mime[0] == 'image' ){
            return true;
        }
        return false;
    }
    public function updateFile( $mediaFile ) {
        $mime = explode("/", $this->mimeType );
        $family = $mime[0];
        if ( isset(self::$mime2ext[$this->mimeType]) ){
            $this->setAttribute( 'fileName', "media.".self::$mime2ext[$this->mimeType] );
        } else {
            $this->addError( 'file', I18N::t("Unsupported mime-type ({mimeType}) for uploaded file", array("{mimeType}"=>$this->mimeType)) );
            return false;
        }
        // clear the snapshots
        GlobalSettings::rrmdir( $this->resource->getFolder() . "/previews");
        
        if ( count( $mime )==2 ){
            if ( $family=='image')
                $this->processImage( $mediaFile );
            else if ( $family=='video' )
                $this->processAudioVideo( $mediaFile );
            else if ( $family=='audio' )
                $this->processAudioVideo( $mediaFile, false );
            else 
                $this->addError( 'file', I18N::t("Unsupported family ({family}) for uploaded file", array( "{family}" => $family)  ) );
        } else {
            $this->addError( 'file', I18N::t("Unsupported mime-type ({mimeType}) for uploaded file", array("{mimeType}"=>$this->mimeType)) );
            return false;
        }
        
        if ( !empty($this->dimension) ) {
            $dim = explode( "x", $this->dimension );
            if ( count($dim)!=2 ){
                $this->addError( 'file', I18N::t( "Cannot extract size of uploaded file" ) );
            }else if ( $dim[1]==0 || $dim[0] == 0 )
                $this->setAttribute( 'aspectRatio', "other");
            else if ( $dim[1]/$dim[0] == 0.5625 )
                $this->setAttribute( 'aspectRatio', "16:9");
            else if ( $dim[0]/$dim[1] == 1.5 )
                $this->setAttribute( 'aspectRatio', "15:10");
            else if ( $dim[1]/$dim[0] == 0.75 )
                $this->setAttribute( 'aspectRatio', "4:3");
            else if ( $dim[1]/$dim[0] == 0.625 )
                $this->setAttribute( 'aspectRatio', "16:10");
            else if ( $dim[0]/$dim[1] == 0.5625 )
                $this->setAttribute( 'aspectRatio', "9:16");
            else if ( $dim[1]/$dim[0] == 1.5 )
                $this->setAttribute( 'aspectRatio', "10:15");
            else
                $this->setAttribute( 'aspectRatio', "other");                
        }
    }
    public function processFile( $name = null ) {
        if ( !$name )
            $this->_uploadedfile = CUploadedFile::getInstance( $this, 'file' );
        else if ( is_array($name) )
            $this->_uploadedfile = new UploadedFileTest( $name );
        else if ( $name=="PUT" )
            $this->_uploadedfile = new UploadedFilePut();
        else
            $this->_uploadedfile = CUploadedFile::getInstanceByName( $name );
        if ( !empty( $this->_uploadedfile ) ) {
            $mime = $this->_uploadedfile->type;
            switch ( $mime ) {
                case "video/avi": $mime = "video/x-msvideo"; break;
                case "application/x-matroska": $mime = "video/x-matroska"; break;
                case "video/vnd.dlna.mpeg-tts": $mime = "video/MP2T"; break;
                case "video/mpeg-system": $mime = "video/dvd"; break;
                case "video/mpeg4": $mime = "video/mp4"; break;                
            }            
            if ( $mime == "application/octet-stream" || !isset( self::$mime2ext[$mime]) ){
                foreach ( self::$mime2ext as $mimeType => $ext ){
                    if ( $ext == $this->_uploadedfile->extensionName ){
                        $mime = $mimeType;
                        break;
                    }
                }
            }
            $this->setAttribute( 'mimeType', $mime );
            $this->updateFile( $this->_uploadedfile->tempName );
        }  
        
        return !$this->hasErrors();
    }
    public function resizeJpeg(){
        
        
        $sizes = explode("x", $this->dimension );
        
        $max_width = 3072;
        $max_height = 3072;
        
        if ( $this->mimeType == "image/jpeg" && ( $sizes[0]>$max_width || $sizes[1]>$max_height) ) {
            
            $path = $this->resource->getFolder();
            $file = $this->fileName;
                        
            $exe = "cd /srv/raperca && previewer";
            if( PHP_OS == "WINNT" ){
                $exe = "C:\\SpinetiX\\sources\\genesis\\trunk\\device\\Release\\previewer.exe";
                if ( !file_exists( $exe ) ){
                    $exe = "\"C:\\Program Files (x86)\\SpinetiX\\Elementi\\Elementi\\bin\\previewer.exe\"";
                }
            }
            
            $cmd = $exe . " -r " . escapeshellarg("${max_width}x${max_height}") . " -i " . escapeshellarg($path) . " -o " . escapeshellarg($path) . " " . escapeshellarg($file) . " 2>&1";
            Yii::log($cmd, 'info', 'spx.preview');
            
            $output = array();
            $ret = 10;
            exec( $cmd, $output, $ret );
            
            if ( $ret!=0 ) {
                if ( PHP_OS == "WINNT" ){
                    $width = $sizes[0];
                    $height = $sizes[1];
                    while ( $width>$max_width || $height>$max_height ){
                        $width = round( $width/2 );
                        $height = round( $height/2 );
                    }
                    
                    rename( $path.$file, $path."full_".$file  );
                    $img = imagecreatefromjpeg( $path."full_".$file );
                    if ( $img ) {
                        $thumb = imagecreatetruecolor($width, $height);
                        // Resize
                        imagecopyresized($thumb, $img, 0, 0, 0, 0, $width, $height, $sizes[0], $sizes[1]);

                        imagejpeg( $thumb, $path.$file);
                    } else {
                        return false;
                    }
                    return true;
                }
                $this->addError('file', I18N::t('An error occured while resizing the image') );
                return false;
            } else {
                try {
                    $info = json_decode( implode("\n", $output), true);
                    if ( isset( $info[0]['success'] ) && isset( $info[0]['error'] ) && $info[0]['success'] === false ){
                        $this->addError('file', $info[0]['error'] );
                        return false;
                    }
                } catch ( Exception $e ) {
                    // we don't care
                }
            }
            
            if ( file_exists($path."/resized_".$file) ) {  
                rename( $path.$file, $path."full_".$file  );
                touch( $path.$file );
                $res = rename( $path."resized_".$file, $path.$file );
                
                if ( !$res ) {
                    if ( file_exists( $path.$file ) )
                        unlink( $path.$file );
                    rename( $path."resized_".$file, $path.$file );
                }                
                $info = getimagesize( $path.$file );   
                
                $this->setAttribute( 'dimension', $info[0]."x".$info[1] );
            }
        }
        return true;
    }
    public function processImage( $mediaFile ) {
        if ( !file_exists($mediaFile ) )
            return false;
        $info = getimagesize( $mediaFile );
        if ( $this->mimeType!=$info['mime'] ){
            // corect the type from the file
            //$this->type = $info['mime'];
        }
        $max_width = 3072;
        $max_height = 3072;
        if ( $this->mimeType=="image/png" || $info['mime']=="image/gif") {            
            if ( $info[0]>$max_width || $info[1]>$max_height || $info[0]*$info[1]>2048*2048 ) {// absolute hardware limits 
                $this->addError( 'file', I18N::t("File resolution exceed maximum supported by the system" ) );
                return false;
            }
            if ( filesize( $mediaFile ) > 2*1024*1024 ) {// 2M max file size
                $this->addError( 'file', I18N::t("File size exceed maximum supported by the system" ) );
                return false;
            }            
        }        
        $this->setAttribute( 'dimension', $info[0]."x".$info[1] );
    }
    public function processAudioVideo( $mediaFile, $video=true ) {
        if ( !file_exists($mediaFile ) )
            return false;
        
        $model = Yii::app()->branding->mediacheck;
        $info = pathinfo( $mediaFile );
        $path = $info['dirname'];
        $file = $info['basename'];//.".".$this->_uploadedfile->extensionName ;
        $cmd = $this->exe . " -mediacheck -m " . escapeshellarg($this->mimeType) . " -t " . escapeshellarg($model) . " -d " . escapeshellarg($path) . " " . escapeshellarg($file) . " 2>&1";
        Yii::log($cmd, 'info', 'spx.preview');
        $output = array();
        $ret = -1;
        exec( $cmd, $output, $ret );
        Yii::log(print_r($output, true), 'info', 'spx.preview');
        if ( $ret!=0 ) {
            $this->addError('file', I18N::t('An error occured while checking the format of the video' ));
            return false;
        }
        $result = json_decode( implode( "\n", $output ), true );
        if ( $result === NULL )
            return true; // no check done
        if ( !isset( $result['ok'] ) ) { 
            $this->addError('file', I18N::t('An error occured while checking the format of the video' ) );
            return false;
        } elseif ( $result['ok']==false ) {
            $this->addError('file', I18N::t('File format not supported' )." :\n".$result['error'] );
            return false;
        } elseif ( $result['ok']==true ) {
            // add the metadata for this file 
            $desc = explode(" ", $result['description'] );
            if ( $video && count($desc)>1 ) {                
                $this->setAttribute( 'dimension', $desc[1] );
            } 
            $this->setAttribute( 'dur', $result['dur'] );            
        }
    }
    public function getPreviews() {
        $where = $this->resource->getFolder() ;
        if ( !file_exists( $where . "previews/" ) ){
            // previews do not existe, we generate them now
            $this->generatePreviews( $where );
        }
        return $this->resource->getPreviews();
    }
    public function generatePreviews( $where ) {
        if ( $this->resource->delayPreview ){
            return true;
        }
        // clear up the preview folder and create it
        $path = $where."previews/";
        
        mkdir( $path );
        
        // for the moment we just copy a generic preview 
        $mime = explode("/", $this->mimeType );
        $family = $mime[0];
        copy( GlobalSettings::$systemMedia."$family.png", $path."preview_98x58_0_default.png" );
        
        // should trigger the generation of the preview using an offline mechanism
        if ( $family=='image')
            return $this->generatePreviewsImage( $where );
        else if ( $family=='video' )
            return $this->generatePreviewsVideo( $where );        
    }
    
    public function generatePreviewsImage( $path ) {
        $outpath = $path."previews/";
        $file = $this->fileName;
        $size = explode("x", $this->dimension );
        $forced = false;
        $minSize = 128;
        if ( $size[0]<=$minSize || $size[1]<=$minSize ){
            $forced = true;
            $size[0] *=2;
            $size[1] *=2;
        }
        while ( $forced || ( $size[0]>$minSize && $size[1]>$minSize ) ){
            $size[0] = round( $size[0]/2 );
            $size[1] = round( $size[1]/2 );
            $ret = $this->resource->previewsImage( $size[0]."x".$size[1], $path, $outpath, $file ); 
            if ( !$ret ){
                $this->addErrors( $this->resource->getErrors( ) );
                return false;
            }
            $forced = false;
        }   
        return true;
    }
    public function generatePreviewsVideo( $path ) {
        $outpath = $path."previews/";
        $file = $this->fileName;
        
        $size = explode("x", $this->dimension );
        if ( $size[0]>800 || $size[1]>450 ) {
            $size[0] = round( $size[0]/2 );
            $size[1] = round( $size[1]/2 );
        }
                
        $width = $size[0];
        $height = $size[1];
        $dimension = "{$width}x{$height}";
        // create an SVG for the preview
        $tmp = "tmp.svg";
        $svg =<<<SVG
<?xml version='1.0' encoding='UTF-8'?>
<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' snapshotTime='3s' width='$width' height='$height' viewBox='0 0 $width $height' viewport-fill='black'>"; 
<video xlink:href='$file' width='$width' height='$height' preserveAspectRatio='xMidYMid'/>
</svg>                
SVG;
        file_put_contents($path.$tmp, $svg);
        $cmd = $this->exe . " -preview -s " . escapeshellarg($dimension) . " -pm 1 -d " . escapeshellarg($path) . " " . escapeshellarg($tmp) . " 2>&1";
        Yii::log($cmd, 'info', 'spx.preview');
        
        $output = array();
        $ret = -1;
        exec( $cmd, $output, $ret );
        if ( $ret==0 ) {
            // move to the preview folder
            rename("$path.preview.$tmp.png", $outpath."preview_$dimension.png");
            // create smaller images
            while ( $size[0]>100 && $size[1]>50 ){
                $size[0] = round( $size[0]/2 );
                $size[1] = round( $size[1]/2 );
                $ret = $this->resource->previewsImage( $size[0]."x".$size[1], $outpath, $outpath, "preview_$dimension.png" );            
                if ( !$ret ){
                    $this->addErrors( $this->resource->getErrors( ) );
                    return false;
                }
            }                     
        }  else {
            if ( PHP_OS != "WINNT" ){
                $this->addError('file', I18N::t('An error occured while processing the video' ));
                return false;
            }
        } 
        // remove tmp file
        unlink($path.$tmp);
        return true;
    }
    
    public function recover(){
        $path = $this->resource->getFolder();
        $mediaFilename = $path.$this->fileName;
            
        $recover = $this->resource->recover( $mediaFilename );        
        if ( $recover ){
            if ( !$this->resource->version ){
                $this->delete();
            }
        } else {
            // must re-check the jpeg size in case it was not saved
            $this->resizeJpeg();
        }
        
        return $recover;
    }
    public function beforeSave(){
        if ( $this->_uploadedfile ) {
            $path = $this->resource->getFolder();
            if ( !$path ){
                $this->addError('file',  "path not found"  );                    
                return false;
            }
            // clenup all previous files 
            GlobalSettings::rrmdir( $path, false );
            touch( $path.$this->fileName );
            if ( !$this->_uploadedfile->saveAs( $path.$this->fileName ) ){
                $this->addError('file', "upload media failed".": ".$path.$this->fileName);        
                return false;
            }
            if ( !$this->resizeJpeg() ){
                $this->addError('file', "resize media failed".": ".$path.$this->fileName );        
                return false;              
            }
            //starts creating the previews
            if ( !$this->generatePreviews( $path ) ) {
                return false;
            }
        }
        return parent::beforeSave();
    }
    public function rollback( )            
    {
        return $this->resource->rollback( );
    }
    public function afterDelete(){
        
        parent::afterDelete();
        
        $resource = Resource::model()->findByPk($this->id);
        if ( $resource ) {
            if ( !$resource->delete() ){
                Yii::log("cannot delete resource: ".print_r( $resource->desc, true), 'warning', 'spx.media');
                throw new Exception( "cannot delete resource" );
            }
        }
    }
    
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
        $criteria->with=array(
            'resource',
        );
		$criteria->compare('id',$this->id);
		//$criteria->compare('name','xxx',true);
        $criteria->compare('fileName',$this->fileName,true);
		$criteria->compare('mimeType',$this->mimeType,true);
        $criteria->compare('dur',$this->dur);
		$criteria->compare('dimension',$this->dimension,true);
		$criteria->compare('aspectRatio',$this->aspectRatio,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Media the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
