<?php

class UploadedFileTest extends CUploadedFile {

    var $tempName;
    var $name = null;
    var $type = null;
    var $size = null;
    var $error = 0;
    var $extensionName = null;
    
    public function __construct( $options ) {
        
        $format = $options['format'];
        if ( $format == "file" ){
            $this->tempName = $options['file'];
            $info = pathinfo( $this->tempName );            
            $this->extensionName = strtolower( $info['extension'] );            
            $this->size = filesize($this->tempName);
            foreach ( Media::$mime2ext as $mime => $ext ){
                if ( $ext == $this->extensionName ){
                    $this->type = $mime;
                }
            }
            return;
        } else if ( $format == "7z" ){
            $this->tempName = $options['folder'];
        } else {
            $this->tempName = tempnam( sys_get_temp_dir(), "TEST" );
            $width = $options['width'];
            $height = $options['height'];

            $img = imagecreatetruecolor( $width, $height );                
        } 
        $this->extensionName = $format;
        if ( $format=="jpg"){
            imagejpeg( $img, $this->tempName );
            $this->type = "image/jpg";
            $this->name = "dummy.jpg";            
        } else if ( $format=="png"){
            imagepng( $img, $this->tempName );
            $this->type = "image/png";
            $this->name = "dummy.png";            
        } else if ( $format=="gif"){
            imagegif( $img, $this->tempName );
            $this->type = "image/gif";
            $this->name = "dummy.gif";            
        } else if ( $format=="7z"){            
            $this->type = "dir";
            if ( isset( $options['name'] ) ){
                $this->name = $options['name'];            
            }else {
                $this->name = "dummy";            
            }
        } else {
            imagegif( $img, $this->tempName );
            $this->type = "image/jpg";
            $this->name = "error.jpg";            
            $this->error = UPLOAD_ERR_INI_SIZE;
            $this->size = 0;
        }
        if ( $this->size===null )
            $this->size = filesize($this->tempName);
    }
    public function __destruct() {
        if (file_exists($this->tempName) && is_file($this->tempName))
            unlink( $this->tempName );
    }
    public function saveAs( $file, $deleteTempFile=true ) {
        if ($deleteTempFile)
            return rename( $this->tempName, $file );
        else
            return copy( $this->tempName, $file );
        
    }
    public function getError(){
        return $this->error;
    }
    public function getSize(){
        return filesize($this->tempName);
    }
    public function getExtensionName(){
        return $this->extensionName;
    }
    public function getTempName(){
        return $this->tempName;
    }
}
