<?php
class SnapshotDisplay extends CWidget
{
    var $resolution;
    var $aspect;
    var $orientation;
    var $link;
    var $style = "";
    var $clickToRefresh = false;
    static $orentiationCss = array(
        "rotateRight" => "rotate(90deg)",
        "rotateLeft" => "rotate(270deg)",
    );
    static function isVertical( $orientation ){
        return isset( self::$orentiationCss[$orientation] );
    }
    public function run()
    {        
        if ($this->resolution) {
            $size = explode( "x", $this->resolution);
        } else {
            $size = array(1920, 1080);
        }
        $ar = explode( ":", $this->aspect );
        if ( count($ar) !== 2 || $ar[0] == 0 ){
            $ar = $size;
        }
        $imgWidth = $size[0];
        $imgHeight =  $size[0]/$ar[0]*$ar[1];
        $imgPadding = $ar[1]/$ar[0];
        $orentiationCss = array(
            "rotateRight" => "rotate(90deg)",
            "rotateLeft" => "rotate(270deg)",
        );
        
        $verticalSnapshot = $this->isVertical( $this->orientation );

        if ( $verticalSnapshot ){
            $imgCSS = "";
            $imgStyle = "transform: translateY( ".($ar[0]/$ar[1]*$ar[0]/$ar[1]*50-50)."% ) ".
                        $orentiationCss[$this->orientation].
                        " scale( ".($ar[0]/$ar[1])." ) ;";        
            $imgPadding = "padding-bottom: ".( ( 1/$imgPadding-$imgPadding)*100) . "%;";
        } else {
            $imgCSS = "";
            $imgStyle = "";
            $imgPadding = "";
        }
        $imgStyle .= $this->style;
        if ( $this->link ){
            echo CHtml::openTag("a", array( 
                "style" => "width: 100%;".$imgPadding,
                "href" => CHtml::normalizeUrl($this->link) 
            )). "\n";
        } else {
            echo CHtml::openTag("div", array( 
                "style"=>"width: 100%;".$imgPadding,
            )). "\n";
        }
        
        $options = array( 
            "width" =>  $imgWidth, "height" => $imgHeight,
            "style" => "width:100%; height:auto;" . $imgStyle,
            "class" => $imgCSS,
            "id" => "snapshot"
        );
        if ( $this->clickToRefresh ){
            $options['onclick'] = "var d = new Date(); $('#snapshot').attr('src', '/snapshot?_=' + d.getTime() );";
        }
        echo CHtml::image('/snapshot?_='.uniqid(), "Snapshot" ,$options );
        if ( $this->link ){
            echo CHtml::closeTag("a");
        } else {
            echo CHtml::closeTag("div");
        }
    }
}