<?php

function is_uri_allowed($uri) {

    $info = parse_url($uri);

    if ($info["scheme"] !== "http" && $info["scheme"] !== "https")
        return FALSE;

    $host = $info["host"];
    if (strpos($host, "[") === 0)
        $host = substr($host, 1);
    if (strlen($host) > 0 && strpos($host, "]", strlen($host)-1) === strlen($host)-1)
        $host = substr($host, 0, -1);

    $ips = gethostbynamel($info["host"]);
    if ( ! $ips || count($ips) === 0 )
        return FALSE;

    // The all zero addresses (0.0.0.0 and ::) act as localhost on connect
    // and there are IPv4, IPv6 and IPv4-mapped IPv6 addresses
    $local_ips = array(
        inet_pton("127.0.0.1"),
        inet_pton("0.0.0.0"),
        inet_pton("::1"),
        inet_pton("::"),
        inet_pton("::ffff:127.0.0.1"),
        inet_pton("::ffff:0.0.0.0")
    );
    foreach ($ips as $ip) {
        $num_ip = inet_pton($ip);
        if ( ! $num_ip )
            return FALSE;
        if (in_array($num_ip, $local_ips))
            return FALSE;
        $canonical_ip = inet_ntop($num_ip);
        // Any IPv4 127.x.x.x address may alias localhost
        if (strpos($canonical_ip, "127.") === 0)
            return FALSE;
        if (strpos($canonical_ip, "::ffff:127.") === 0)
            return FALSE;
    }

    return TRUE;
}

function get_http_status_code($headers) {
    if ( ! is_array($headers) )
        return FALSE;
    if ( ! array_key_exists(0, $headers) )
        return FALSE;
    $status_line = $headers[0];
    if ( ! preg_match('#^HTTP/[\S]+[\s]+([\d]+)#', $status_line, $matches) )
        return FALSE;
    return intval($matches[1]);
}

function get_http_redirect_location($headers) {
    foreach ($headers as $h) {
        if ( preg_match('#^LoCation:[\s]+(.*)#i', $h, $matches) )
            return $matches[1];
    }
    return FALSE;
}

function get_uri($uri) {

    $opts = array('http' =>
                  array(
                      'method' => 'GET',
                      'follow_location' => '0',
                      'max_redirects' => '0',
                      'timeout' => '10',
                  ));
    $ctx = stream_context_create($opts);
    $nr_redirects = 0;
    do {
        if ( ! is_uri_allowed($uri) )
            return FALSE;

        $content = file_get_contents($uri, false, $ctx, 0, 4 * 1024 * 1024);
        $status_code = get_http_status_code($http_response_header);
        if ( ! $status_code )
            return FALSE;
        if ($status_code >= 200 && $status_code < 300) {
            return $content;
        } elseif ($status_code && $status_code >= 300 && $status_code < 400) {
            $uri = get_http_redirect_location($http_response_header);
            if ( ! $uri )
                return FALSE;
            $nr_redirects++;
        } else {
            return FALSE;
        }
    } while ($nr_redirects <= 10);

    return FALSE;
}

if ( isset($_GET['uri']) ) {
    $rss = get_uri($_GET['uri']);
    header('Content-Type: text/xml');
    if ( $rss ){                
        echo $rss;      
        exit(0);                  
    } 

    echo '<?xml version="1.0" encoding="utf-8"?>'. "\n";
?>
<rss xmlns:media="http://search.yahoo.com/mrss/" version="2.0">
<channel>
<item><title>RSS Feeds not found, check URI</title>
</item>
</channel>
</rss>
<?php
    exit(0);
}

header("HTTP/1.0 400 Bad Request");
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>Invalid RSS Proxy call</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
</head>
<body>
<h1>Invalid RSS Proxy call</h1>
</body>
</html>
