<?php
class Schedule extends Resource
{
    protected $scheduleFile = "schedule.json";
    protected $_events = null;
    protected $_events_modified = true;
    
    protected $_old_events = null;
    protected $elementiIndexFile = "/srv/raperca/content/index.svg";
    
    public $start = null;
    public $end = null;
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
        $rules = parent::rules();
        $rules[] = array('start, end', 'date', 'format'=>'yyyy-MM-dd');
        $rules[] = array('events', 'validateEvents');
		return $rules;
        
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'events' => 'events',
		);
	}
    public function init(){
        parent::init();
        $this->type = "schedule"; 
        $this->name = "schedule";
    }
    public function defaultScope(){
        return array(
            'condition'=>"type='schedule'",
        );
    }
    public function fixEvents(  ) {
        // fix the event description for the read only data
        foreach( $this->_events as &$event ) {
            if ( isset($event['resource']) ){
                $id = $event['resource']['id'];
                $model = Resource::model()->findByPk($id);
                $event['resource']['previews'] = $model->previews;            
                $event['resource']['name'] = $model->name;
            }
        }
    }
    public function loadEvents( $force=false ) {
        $path = $this->getFolder();
        if ( !$path )
            return false;
        if ( !file_exists( $path . $this->scheduleFile ))
            return false;
        $schedule = file_get_contents( $path . $this->scheduleFile );
        if ( empty($schedule) )
            return false;
        $this->_events = json_decode( $schedule, true );
        $this->fixEvents();
        // add 
        $this->_old_events = $this->_events;
        $this->_events_modified = false;
                
        return true;
    }
    public function saveEvents( $path ) {
        if ( !is_array($this->_events) ){
            throw new Exception ("Events are not set");
        }
        foreach( $this->_events as $idx=>&$event ) {
            if ( isset($event['resource']['previews']) ){
                unset( $event['resource']['previews'] );
            }
        }
        $filepath = $path . $this->scheduleFile;
        if ( !Resource::saveAtomic( $filepath, json_encode( $this->_events ) ) ){
            return false;
        }
        $this->forceReload();
        
        $this->fixEvents( );
        return true;
    }
    static function forceReload() {
        if (file_exists( GlobalSettings::$fileBase."index.svg" ) ){
            touch( GlobalSettings::$fileBase."index.svg" );
        }
    }
    public function checkDay( &$event, $day ) {
        $today = date('N');
        if ( $event['allDay'] ){
            if ( $day == $today ){
                
                return true;            
            }
        } else {
            $startArray = explode(":", $event['startTime'] );
            $start = $day*24*3600 + $startArray[0]*3600+$startArray[1]*60;
            $end = $start + $event['duration'];
            
            $currentArray = explode(":", date('N:G:i') );
            $current = $currentArray[0]*24*3600+$currentArray[1]*3600+$currentArray[2]*60;
            if ( $start <= $current && $end > $current){
                return true;
            }
        }
        
        return false;
    }
    public function getCurrentEvent( ) {
        $now = time();
        if ( $this->_events === null ){
            $this->loadEvents();         
        }
        if ( $this->_events === null ){
            $this->_events = array();
        }
        $activeResource = null;
        $validSource = array();
        foreach($this->_events as $event ){
            if ( isset( $event['default'] ) ) {
                if ( $activeResource === null ){
                    $activeResource = $event;
                }
                continue;
            }            
            $start = strtotime( $event['startDate']);
            if ( $start > $now ){
                continue;
            }            
            if ( isset( $event['endDate'] ) ) {
                $end = strtotime( $event['endDate'] );
                if ( $end < $now ){
                    continue;
                }
            } else {
                $end = $now;
            }
            
            if ( $event['days'] ){
                if ( $event['days'] === true ) {
                    for ( $j=1; $j<8; $j++ ) {
                        if ( $this->checkDay( $event, $j) ) {
                            array_push($validSource, $event);
                        }
                    }
                } else {
                    foreach($event['days'] as $day ){
                        if ( $this->checkDay( $event, $day ) ) {
                            array_push($validSource, $event);
                        }
                        if ( $this->checkDay( $event, $day - 7 ) ) {
                            array_push($validSource, $event);
                        }
                        if ( $this->checkDay( $event, $day + 7 ) ) {
                            array_push($validSource, $event);
                        }
                    }
                } 
            } else {
                if ( $event['allDay'] ){
                    $start = strtotime( $event['startDate'] );
                    $end = $start + 24*3600;                
                    if ( $start <= $now && $end > $now){
                        array_push($validSource, $event);
                    }
                } else {
                    $start = strtotime( $event['startDate'] . "T" . $event['startTime']  );
                    $end = $start + $event['duration'];                
                    if ( $start <= $now && $end > $now){
                        array_push($validSource, $event);
                    }
                }
            }
        }
        if ( count($validSource) == 0 ){
            if ( $activeResource ){
                return $activeResource;
            } else {
                return (object)array();        
            }
        } else if ( count($validSource) == 1 ) {
            return $validSource[0];
        } else {
            $active = null;
            $activeStart = null;
            $activeEnd = null;
            foreach ( $validSource as $event ) {
                if ( $event['allDay'] ){
                    $start = 0;
                    $end = $start + 24*3600;
                } else {
                    $start = strtotime( $event['startDate'] . "T" . $event['startTime']  ) - strtotime( date('Y-m-d') . "T00:00"  ); ;                   
                    $end = $start + $event['duration'];                     
                }
                if ( $active === null ||
                     $activeStart < $start ||
                     ( $activeStart == $start && $activeEnd > $end )
                    ){
                    $active = $event;
                    $activeStart = $start;
                    $activeEnd = $end;
                }
            }
            return $active;
        }
    }
    public function getEvents( $allEvents = false ){
        if ( $this->_events === null ){
            $this->loadEvents();         
        }
        if ( $this->_events === null ){
            $this->_events = array();
        }
        if ( $allEvents ){
            return $this->_events;
        }
        if ( $this->start == null && $this->end == null ){
            return array( $this->getCurrentEvent( ) );
        }
        if ( $this->start != null ){
            $startTime = strtotime( $this->start );
        } else {
            $startTime = time();
        }
        if ( $this->end != null ){
            $endTime = strtotime( $this->end );
        } else {
            $endTime = time();
        } 
        $events = array();
        foreach( $this->_events as $event ){
            if ( isset( $event['startDate'] ) ) {
                $start = strtotime($event['startDate']);
                if ( $start > $endTime ){
                    continue;
                }

                if ( ! isset( $event['endDate'] ) && ( !isset( $event['days'] ) || !$event['days'] ) )  {
                    $end = strtotime($event['startDate']) + 7 * 24 * 3600; // some margin, even are never longer than a week 
                    if ( $end < $startTime ){
                        continue;
                    } 
                }
            }
            if ( isset( $event['endDate'] ) ) {
                $end = strtotime($event['endDate']);
                if ( $end < $startTime ){
                    continue;
                }
            }
            if ( isset( $event['default'] ) ) {
                array_unshift($events, $event);                                 
            } else {                
                $events[] = $event;
            }
        }
        return $events;
    }
    public function setEvents( $events, $allEvents = false ){
        // always set all the event
        $this->_events = $events;        
        $this->_events_modified = true;

    }
    public function addEventsError( $attribute, $desc ){
        $this->addError( $attribute, $desc );
    }
    
    public function validateEvents( $attribute ){
        if ( !is_array( $this->getEvents( true ) ) ){//make sure _events is populated
            $this->addError( $attribute, "should be an array" );
            return false;
        }
        
        if ( $attribute!="events" ){
            $this->addError( $attribute, "should be events" );
            return false;
        }
        $model = External::model()->findByAttributes(array('name'=>"Elementi"));
        if ( $model !== null ){
            $elementiId = $model->id;
        } else {
            $elementiId = 0;
        }
        $now = time();
        $hasElementi = array();        
        $childrens = array();
        $i=0;
        $val = new Validator( $this, "events" );
        $debug = array();
        
        $hasDefault = false;
        foreach( $this->_events as &$event ) {
            $attribute = 'events['.$i.']';
            $isElementi = false;             
            if ( isset( $event['resource'] ) && isset( $event['resource']['id'] ) ) {                                
                if( $event['resource']['id'] == $elementiId){
                    $hasElementi[] = $attribute;
                    $isElementi = true;
                }
            }
            
            if ( isset($event['default'])){
                if ( $hasDefault ) {
                    $this->addEventsError( $attribute.".default", "not allowed" );
                    return false;
                }  
                $hasDefault = true;                 
            } else {
                if ( isset($event['allDay']) && $event['allDay'] ){
                    unset( $event['startTime'] );
                    unset( $event['duration'] );                    
                } else {
                    if ( !isset($event['startTime']) ){
                        $this->addEventsError( $attribute.".startTime", "missing" );
                        return false;
                    } else {
                        $val->validateTime( $event['startTime'], $attribute.".startTime" );
                    }
                    if ( !isset($event['duration']) ){
                        $this->addEventsError( $attribute.".duration", "missing" );
                        return false;
                    } else {
                        $val->validateDur( $event['duration'], $attribute.".duration" );
                    }                    
                }
                if ( !isset($event['startDate']) ){
                    $this->addEventsError( $attribute.".startDate", "missing" );
                    return false;
                } else {
                    $val->validateDate( $event['startDate'], $attribute.".startDate" );
                }                   
                if ( isset($event['endDate']) ){                                        
                    $val->validateDate( $event['endDate'], $attribute.".endDate" );
                    $end = strtotime( $event['endDate'] );                     
                } else {
                    unset( $event['endDate'] );
                }
                
                if ( isset($event['days']) ){
                    if ( is_array( $event['days'] ) ){
                        foreach( $event['days'] as $i=>$v ){
                            if ( !is_numeric($v) || intval($v)<0 || intval($v)>6 ){
                                $this->addError( $attribute.".days[$i]", "should be between 0 and 6" );
                            }
                        }
                    }
                }else {
                    unset( $event['days'] );
                }
            }
            if ( isset($event['default']) && isset($event['powerOff']) ){
                $event['title'] = 'powerOff';
            } else {
                if ( !isset($event['resource']) ){
                    $this->addEventsError( $attribute.".resource", "missing" );
                    return false;
                }
                $resource = &$event['resource'];
                $attribute .= ".resource";       
                if ( !isset($resource['type']) ){
                    $this->addEventsError( $attribute.".type", "missing" );
                    return false;
                }

                $model = $val->validateSingleMedia( $resource, $childrens, $attribute, true, true);
                if ( $model === false ){
                    return false;
                }
                $event['title'] = $model->name;
            }
            $i++;
        }
        // Update the AR relations
        $this->children = $childrens;
                            
        return true;
    }
    public function removeChild( $childId, $delayPreview = false ) {
        $this->delayPreview = $delayPreview;
        $old_events = $this->getEvents( true );
        $new_events = array();
        foreach( $old_events as $event ){
            if( $event['resource']['id'] != $childId )
                $new_events[] = $event;
        }
        $this->setEvents( $new_events, true  );
        
        if ( $this->save() ) {
            return true;
        } else
            return false;
    }
    public function rollback() {
        
        if ( $this->_events_modified && $this->_old_events !== null ) {
            $this->setEvents( $this->_old_events, true );
            if ( !$this->saveEvents( $this->getFolder() ) ){
                throw new Exception(  "rollback failed" );
            }
        }
    }
    
    public function getListDesc( $preview=true ) {
        $description = $this->getEvents();
        return $description;
    }

    public function gethref() {
        return parent::getHref() . $this->scheduleFile;
    }
    
    public function recover( $file = null ){
        
        $path = $this->getFolder();
        $eventsFilename = $path. $this->scheduleFile;
        $recover = parent::recover($eventsFilename);
        
        $scheduleFilename = GlobalSettings::$fileBase."index.svg"; 
        if ( !$recover ) {                   
            if ( !file_exists($scheduleFilename) || filesize($scheduleFilename) == 0 ){
                // schedule has been lost, need to re-write the file  
                $this->saveSchedule();
                Yii::log("Recovering index.svg", 'warning', 'spx.assets');
                $recover = true;
            }
        } 
        
        return $recover;
    }
    public function saveSchedule(){
        $index = file_get_contents( GlobalSettings::$systemMedia."schedule.svg" );
        // fix the link
        $newIndex = str_replace('"link": ""', '"link": "'.$this->gethref().'"', $index );
        Resource::saveAtomic( GlobalSettings::$fileBase."index.svg", $newIndex);      
    }
    public function saveFiles(){
        $path = $this->getFolder();
        if ( !$path ){
            $this->addError( "", "path not found" );
            return false;
        }
        $src = GlobalSettings::$systemMedia."schedule.svg";
        $dst = GlobalSettings::$fileBase."index.svg";
        if ( $this->isNewRecord || !file_exists( $dst ) || filemtime( $src ) > filemtime( $dst) ){
            $this->saveSchedule();
        }
        if ( $this->_events_modified ){
            if ( !$this->saveEvents( $path ) ){
                $this->addError( "", "save failed" );
                return false; 
            }
            $this->etag = $this->computeEtag( $path. $this->scheduleFile );
        }        
        return true;
    }
    public function beforeSave(){
        if ( !$this->isNewRecord && !$this->saveFiles() ){
            return false;
        }
        return parent::beforeSave();
    }
    public function afterSave(){ 
        parent::afterSave();
        
        if ( $this->isNewRecord && !$this->saveFiles() ){
            throw new Exception( "save failed" );
        }        
    }
    public function beforeDelete() {
        $scheduleFilename = GlobalSettings::$fileBase."index.svg";         
        @unlink($scheduleFilename);
        return parent::beforeDelete();
    }
    /**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Playout the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
