<?php

class UsbController extends ControlCenterController
{
    public function actionUnmount()
	{
        $this->ajaxOnly(); 
        $data = array(
            'errors' => array()
        );         
        $idx = Yii::app()->getRequest()->getPost('index');
        if ( $idx !== null ){  
            $usbStorageInfo = new USBStorageInfo;
            $usbStorageInfo->load();
            $usbStorage = $usbStorageInfo->storage[$idx];
            $usbStorage->unmount();             
            $data['errors'] = $this->updateErrors( $usbStorage, $data['errors'] );
            $data['data'] = array(
                'usedFor' => $usbStorage->getUsedFor(),
                'isUsed' => $usbStorage->isUsed(),
                'forceUnmount' => $usbStorage->forceUnmount
            );
            if ( !$usbStorage->hasErrors() ){
                Tools::addMessage( $usbStorage->message);
            }
		} else {
            $data['errors'][] = "No storage provided";
        }
        
        $this->render('/layouts/ajax', $data);         
    }
    public function actionFormat()
    {
        $this->ajaxOnly(); 
        
        $data = array();
        $messages = array( );
        $errors = array();
         
        $usbStorage = new USBStorage;
        if ( isset($_POST['USBStorage']) ) {
            $usbStorage->setAttributes( $_POST['USBStorage'] );
            $usbStorage->formatStart();
            $over = $usbStorage->formatOver();
            $data = array( 	'id'=>$usbStorage->getFormatID(),
                            'pid'=>$usbStorage->getFormatPID(),
                            'logs'=>$usbStorage->formatLogs(),                            
                            'finished'=>$over
                        );
            if ( $usbStorage->hasErrors() ){
                $errors = $this->updateErrors( $usbStorage, $errors );
            } else if ( $usbStorage->message ){
                $messages[] = $usbStorage->message; 
            }
        } else if ( isset($_POST['id']) && isset($_POST['pid']) ){
            $id = $_POST['id'];
            $pid = $_POST['pid'];
            $data['logs'] = $usbStorage->formatLogs( $id );
            if ( $usbStorage->formatOver( $pid ) ){
                $data['finished'] = true;
                if ( $usbStorage->forceFormat ) {
                    $data['forceFormat']=true;
                }
            }
            if ( $usbStorage->hasErrors() ){
                $errors = $this->updateErrors( $usbStorage, $errors );
            } else if ( $usbStorage->message ){
                $messages[] = $usbStorage->message; 
            }
        } else {
            $errors[] = "Missing id";
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $errors,
            'messages' => $messages,
            'data' => $data
        ));         
    }
    public function actionPublish()
    {
        $this->ajaxOnly(); 
        $data = null;
        $errors = array();
        $usbStorage = new USBStorage;
        
        if ( !isset($_POST['action']) )
            $errors[] = "Action not specfied";
        else if ( $_POST['action'] == 'publish' && isset($_POST['USBStorage']) ){
            $usbStorage->setAttributes( $_POST['USBStorage'] );
            $data = $usbStorage->copyFromUsb( );                        
        }else if ( $_POST['action'] == 'save' ){
            $usbStorage->setAttributes( $_POST['USBStorage'] && isset($_POST['USBStorage']) );
            $data = $usbStorage->copyToUsb( );                        
        } else if ( $_POST['action'] == 'status' ){
            if ( !isset($_POST['id']) )
                $errors[] = "Missing id";
            else {
                $data = $usbStorage->copyStatus( $_POST['id'] );
            }
        } else {
            $errors[] = "Action unknown";
        }  
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors($usbStorage, $errors),
            'data' => $data
        ));
    }    
}