<?php

header("Content-type: text/xml");
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Sat, 13 Jan 1973 15:55:00 GMT"); // Date in the past
// CORS
if (isset($_SERVER['HTTP_ORIGIN'])) {
    header("Access-Control-Allow-Origin: " . $_SERVER['HTTP_ORIGIN']);
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400'); // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
        header("Access-Control-Allow-Methods: GET, OPTIONS");
    }
    // that's it
    exit(0);
}
$spxsNS = 'http://www.spinetix.com/namespace/1.0/spxstatus';
$spxsP = 'spxs';

require_once dirname(__FILE__) . '/protected/utils/MainInfo.php'; // for the info
require_once dirname(__FILE__) . '/protected/utils/MaintenanceJobs.php'; // for the info
require_once dirname(__FILE__) . '/protected/utils/Updater.php'; // for the firmware state
require_once dirname(__FILE__) . '/protected/utils/BrandingInfo.php'; // for the branding

function addItem($name, $value, $node, $singleLine = false)
{
    global $output;

    $item = $output->createElement($name);
    $node->appendChild($item);
    if (is_array($value)) {
        $item->appendChild($output->createTextNode("\n"));
        foreach ($value as $n => $v) {
            addItem($n, $v, $item, $singleLine);
        }
    } else {
        $item->appendChild($output->createTextNode($value));
    }
    if (!$singleLine) {
        $node->appendChild($output->createTextNode("\n"));
    }
}

$brandingInfo = new BrandingInfo();
$deviceType = $brandingInfo->product;

// Serial number
$data = getInfoSerial($serial, $model, $hwrdRevision);
$serviceSerial = $data["altSerial"]["service"];

// Main network interface MAC address
$macAddress = getInfoMac();
$macAddress = $macAddress ? $macAddress[array_key_first($macAddress)] : '';

//check safe mode
$safemode = getInfoSafeMode();

// uptime
$uptime = getInfoUpTime();
$bootid = MaintenanceJobs::bootID();

// reboot reason
$bootreason = ParseSyslog::getRebootReason();

// IP addresses
$ip_addrs = getInfoIp($ip, $prefixLength, $ifaceType);
$base_addr = reset($ip_addrs);
$ipv6 = getInfoIpv6($base_addr[3]);


if ($model != "Bonsai") {
    // temperature
    $t = getInfoTemperature();
    $temp = $t['temp'];
    if (is_nan($temp)) {
        $temp = '[not found]';
    }
    $max = $t['max'];
    $crit = $t['crit'];
}

// IP configuration
$netconf = new ipconfigBasics();
$netconf->load();
$dnsconf = new dnsconfigBasics();
$dnsconf->load();

$config_name = "/etc/raperca/spxconfig.xml";
$spxconf = file_get_contents($config_name);
$deviceName = "";
$screenId = "";
$scanpercent = "3";
$orientation = "horizontal";
$maxLatency = "";
$interactLatency = "";
$enableAudio = "off";
$remoteClientsEnabled = "false";
$sharedVarPort = "1234";
if ($spxconf) {
    $domdoc = new DOMDocument();
    $domdoc->loadXML($spxconf);
    $multiscreen = $domdoc->getElementsByTagName("multiscreen");
    if ($multiscreen->length == 1) {
        $multiscreen = $multiscreen->item(0);
        if ($multiscreen->hasAttribute("screenId")) {
            $screenId = $multiscreen->getAttribute("screenId");
        }
    }
    $reporting = $domdoc->getElementsByTagName("reporting");
    if ($reporting->length == 1) {
        $reporting = $reporting->item(0);
        if ($reporting->hasAttribute("deviceName")) {
            $deviceName = $reporting->getAttribute("deviceName");
        }
    }
    if ($deviceName == "") {
        $deviceName = $serial;
    }
    if ($screenId == "") {
        $screenId = $serial;
    }

    $svglib = $domdoc->getElementsByTagName("svglib");
    if ($svglib->length == 1) {
        $svglib = $svglib->item(0);
        if ($svglib->hasAttribute("mute")) {
            $enableAudio = $svglib->getAttribute("mute");
        }
    } else {
        unset($svglib);
    }

    $svgrender = $domdoc->getElementsByTagName("svgrender");
    if ($svgrender->length == 1) {
        $svgrender = $svgrender->item(0);
        if ($svgrender->hasAttribute("overScanMargin")) {
            $scanpercent = $svgrender->getAttribute("overScanMargin");
        }
        if ($svgrender->hasAttribute("screenOrientation")) {
            $orientation = $svgrender->getAttribute("screenOrientation");
        }
        if ($svgrender->hasAttribute("maxLatency")) {
            $maxLatency = $svgrender->getAttribute("maxLatency");
        }
        if ($svgrender->hasAttribute("interactLatency")) {
            $interactLatency = $svgrender->getAttribute("interactLatency");
        }
    } else {
        unset($svgrender);
    }

    $interactivity = $domdoc->getElementsByTagName("interactivity");
    if ($interactivity->length == 1) {
        $interactivity = $interactivity->item(0);
        if ($interactivity->hasAttribute("remoteClientsEnabled")) {
            $remoteClientsEnabled = $interactivity->getAttribute(
                "remoteClientsEnabled"
            );
        }
        if ($interactivity->hasAttribute("sharedVarPort")) {
            $sharedVarPort = $interactivity->getAttribute("sharedVarPort");
        }
    } else {
        unset($interactivity);
    }
}

// Screen info

$screeninfo = new ScreenInfoBasics();
$screeninfo->load();

// Storage size
function isMounted($dir)
{
    $mount = file_get_contents("/proc/mounts");
    $mounts = explode("\n", $mount);
    foreach ($mounts as $mount) {
        $info = preg_split("/\s/", $mount);
        if (count($info) > 1 && $info[1] == $dir) {
            return true;
        }
    }
    return false;
}
function printUsageTable($path, $name, $node)
{
    global $output;

    $di = $output->createElement(trim($name));
    $node->appendChild($di);
    $di->appendChild($output->createTextNode("\n"));

    $info = getDiskInfo($path);

    addItem("available", $info['free'], $di);
    addItem("used", $info['used'], $di);
    addItem("total", $info['tot'], $di);
    addItem("unit", $info['unit'], $di);

    $node->appendChild($output->createTextNode("\n"));
}

// firmware
getInfoFirmware($firmware, $build);

//timezone
if (PHP_OS == 'WINNT') {
    if (file_exists("/etc/localtime.link")) {
        $realpath = file_get_contents("/etc/localtime.link");
    } else {
        $realpath = "../usr/share/zoneinfo/Europe/Zurich";
    }
} else {
    $realpath = readlink("/etc/localtime");
}
$inf = explode("/", $realpath);
if (count($inf) >= 2) {
    $tzarea = $inf[count($inf) - 2];
    $tzcity = $inf[count($inf) - 1];
} else {
    $tzarea = "[unknonw]";
    $tzcity = "[unknonw]";
}

// Pull mode:
$xlinkNS = 'http://www.w3.org/1999/xlink';
// load the config
$config = new DOMDocument();
$config->loadXML(file_get_contents('/etc/raperca/uploaderconf.xml'));
$schedule = $config->getElementsByTagName("schedule");
$selectMode = "Disabled";
if ($schedule->length > 0) {
    $link = $schedule->item(0)->getAttributeNS($xlinkNS, "href");
    if ($link == "uploader.ics") {
        $selectMode = "Automatic";
    } else {
        $selectMode = "Server";
        $icalsource = preg_replace("@$serviceSerial@", "[serial]", $link);
    }
} else {
    // manual

    $proj = $config->getElementsByTagName("action");
    foreach ($proj as $action) {
        $name = $action->getAttribute("summary");
        if ($name == 'publish') {
            $enable_project = 1;
            $project_source = $action->getAttributeNS($xlinkNS, "href");
            $time1 = $action->getAttribute("time");
            $selectMode = "Manual";
        }
        if ($name == 'upload') {
            $enable_log = 1;
            $logsource = $action->getAttributeNS($xlinkNS, "href");
            $time2 = $action->getAttribute("time");
            $logs = $action->getAttribute("type");
            $selectMode = "Manual";
        }
    }
}

// CPU stats
$parser = new ParseLogs();
$offset = true;
if (isset($_GET['offset'])) {
    $offset = $_GET['offset'];
}
$stats = $parser->readStats($offset);
$fileErrors = $parser->readErrors($offset);

// license
if ($model !== 'ikebana') {
    $licenseData = $brandingInfo->getLicenseData();
}

$output = new DOMDocument();

$main = $output->createElementNs($spxsNS, "status");
$output->appendChild($main);
$main->setAttributeNS(
    "http://www.w3.org/2000/xmlns/",
    'xmlns:' . $spxsP,
    $spxsNS
);
$main->setAttributeNS($spxsNS, $spxsP . ':version', '5');

// device info
$device = $output->createElement("device");
$main->appendChild($device);
$device->appendChild($output->createTextNode("\n"));
addItem("name", $deviceType, $device);
addItem("serial", $serial, $device);
addItem("ethmac", $macAddress, $device);
addItem("revision", $hwrdRevision, $device);

$main->appendChild($output->createTextNode("\n"));

// status
$status = $output->createElement("status");
$main->appendChild($status);
$status->appendChild($output->createTextNode("\n"));
addItem("safemode", $safemode ? "on" : "off", $status);
addItem("firmware", strtolower(Updater::getState()), $status);
addItem("bootid", $bootid, $status);
addItem("uptime", $uptime, $status);
addItem("bootReason", $bootreason, $status);

if ($model != "Bonsai") {
    addItem("temp", $temp, $status);
    if ($max) {
        addItem("alarm", "maximum", $status);
    }
    if ($crit) {
        addItem("alarm", "critical", $status);
    }
    if ($offset !== true) {
        $tempHistory = $parser->readTemperature($offset);
        $node = $output->createElement("tempHistory");
        $main->appendChild($node);
        $node->appendChild($output->createTextNode("\n"));
        foreach ($tempHistory as $temp) {
            $tempNode = $output->createElement("sample");
            $node->appendChild($tempNode);
            $tempNode->appendChild($output->createTextNode("\n"));
            addItem("time", $temp['time'], $tempNode);
            addItem("C", $temp['C'], $tempNode);
            addItem("F", $temp['F'], $tempNode);
        }
    }
}

// stats
$statsNode = $output->createElement("stats");
$main->appendChild($statsNode);
$statsNode->appendChild($output->createTextNode("\n"));
foreach ($stats as $line) {
    $sampleNode = $output->createElement("sample");
    $statsNode->appendChild($sampleNode);
    $sampleNode->appendChild($output->createTextNode("\n"));
    foreach ($line as $n => $v) {
        if ($n == "peak") {
            $node = $output->createElement($n);
            $sampleNode->appendChild($node);
            addItem("value", $v, $node, true);
            addItem("unit", "ms", $node, true);
        } elseif ($n == "usage" || $n == "dropFPS" || $n == "dropPeak") {
            $node = $output->createElement($n);
            $sampleNode->appendChild($node);
            addItem("average", $v['average'], $node, true);
            if ($n == "usage") {
                addItem("arm", $v['arm'], $node, true);
                addItem("dsp", $v['dsp'], $node, true);
            }
            if (count($v['max']) == 3) {
                addItem("max1s", $v['max'][0], $node, true);
                addItem("max10s", $v['max'][1], $node, true);
                addItem("max60s", $v['max'][2], $node, true);
            }
            addItem("unit", "%", $node, true);
        } elseif ($n == "buffers") {
            $node = $output->createElement($n);
            $sampleNode->appendChild($node);
            addItem("average", $v['average'], $node, true);
            addItem("min", $v['min'], $node, true);
            addItem("unit", "ms", $node, true);
        } else {
            addItem($n, $v, $sampleNode, true);
        }
    }
}
// errors
$fileErrorNode = $output->createElement("fileErrors");
$main->appendChild($fileErrorNode);
$fileErrorNode->appendChild($output->createTextNode("\n"));
foreach ($fileErrors as $line) {
    $sampleNode = $output->createElement("error");
    $fileErrorNode->appendChild($sampleNode);
    $sampleNode->appendChild($output->createTextNode("\n"));
    foreach ($line as $n => $v) {
        addItem($n, $v, $sampleNode);
    }
}

$time = $output->createElement("time");
$main->appendChild($time);
$time->appendChild($output->createTextNode("\n"));
addItem("date", date("F j, Y, G:i"), $time);
addItem("timezone", "$tzarea/$tzcity", $time);
addItem("GMTOffset", date("P"), $time);
$main->appendChild($output->createTextNode("\n"));

// network info
$network = $output->createElement("network");
$main->appendChild($network);
$network->appendChild($output->createTextNode("\n"));
addItem("deviceName", $deviceName, $network);
addItem("hostname", getInfoHostname(), $network);
addItem("ip", $ip, $network);
addItem("prefixLength", $prefixLength, $network);
addItem("interface", $ifaceType, $network);
foreach ($ipv6 as $ipv6addr) {
    $ipv6node = $output->createElement("ipv6");
    $network->appendChild($ipv6node);
    $ipv6node->appendChild($output->createTextNode("\n"));

    addItem("ipv6addr", $ipv6addr, $ipv6node);
}
if (count($ip_addrs) >= 2) {
    $netother = $output->createElement("secondaryAddresses");
    $network->appendChild($netother);
    reset($ip_addrs);
    while ($addr = next($ip_addrs)) {
        $node = $output->createElement("address");
        $netother->appendChild($node);
        addItem("ip", $addr[0], $node);
        addItem("prefixLength", $addr[1], $node);
				addItem("interface", $addr[2], $node);
				$ipv6sub = getInfoIpv6($addr[3]);
				foreach ($ipv6sub as $ipv6addr) {
					$ipv6node = $output->createElement("ipv6");
					$node->appendChild($ipv6node);
					$ipv6node->appendChild($output->createTextNode("\n"));

					addItem("ipv6addr", $ipv6addr, $ipv6node);
				}
    }
}

$netconfig = $output->createElement("configuration");
$network->appendChild($netconfig);
addItem("interface", $netconf->netiface, $netconfig);
addItem("method", $netconf->dhcp ? 'dhcp' : 'static', $netconfig);
if (!$netconf->dhcp) {
    addItem("ip", $netconf->address, $netconfig);
    addItem(
        "prefixLength",
        net_mask_to_prefix($netconf->netmask),
        $netconfig
    );
    addItem("gateway", $netconf->gateway, $netconfig);
    for ($i = 1; $i <= 3; $i++) {
        $n = "nameserver$i";
        if ($dnsconf->$n) {
            addItem("dns", $dnsconf->$n, $netconfig);
        }
    }
}

$main->appendChild($output->createTextNode("\n"));

// screen info
$screen = $output->createElement("screen");
$main->appendChild($screen);
$screen->appendChild($output->createTextNode("\n"));
addItem("screenID", $screenId, $screen);
addItem("snapshotURI", "http://" . $ip . "/status/snapshot", $screen);
addItem("resolutionWidth", $screeninfo->width, $screen);
addItem("resolutionHeight", $screeninfo->height, $screen);
addItem("verticalRefresh", $screeninfo->refresh, $screen);
addItem("aspectRatio", $screeninfo->aspect, $screen);
addItem("overscanPercent", $scanpercent, $screen);
addItem("orientation", $orientation, $screen);
addItem("powerSave", $screeninfo->powersave, $screen);

$ad = $output->createElement("audio");
$screen->appendChild($ad);
$ad->appendChild($output->createTextNode("\n"));
addItem("mute", $enableAudio, $ad);
$screen->appendChild($output->createTextNode("\n"));

foreach ($screeninfo->monitors as $sc) {
    $di = $output->createElement("display");
    $screen->appendChild($di);
    $di->appendChild($output->createTextNode("\n"));
    foreach ($sc as $name1 => $info) {
        addItem($name1, $info, $di);
    }
    $screen->appendChild($output->createTextNode("\n"));
}

$main->appendChild($output->createTextNode("\n"));

// storage
$storage = $output->createElement("storage");
$main->appendChild($storage);
$storage->appendChild($output->createTextNode("\n"));
printUsageTable("/srv/.shadow-raperca", "content", $storage);
printUsageTable("/", "system", $storage);
$path = realPath("../content");
if (isMounted($path)) {
    printUsageTable($path, "usb", $storage);
}

$main->appendChild($output->createTextNode("\n"));

// storagedevices
$storagedevices = $output->createElement("storagedevices");
$main->appendChild($storagedevices);
$storagedevices->appendChild($output->createTextNode("\n"));
$sizes = getStorageSizes($model);
foreach ($sizes as $size) {
    $storagedevice = $output->createElement("storagedevice");
    $storagedevices->appendChild($storagedevice);
    $storagedevice->appendChild($output->createTextNode("\n"));
    foreach ($size as $name => $value) {
        addItem($name, $value, $storagedevice);
    }
}
$main->appendChild($output->createTextNode("\n"));

// firmware
$version = $output->createElement("version");
$main->appendChild($version);
$version->appendChild($output->createTextNode("\n"));
$fi = $output->createElement("firmware");
$version->appendChild($fi);
$fi->appendChild($output->createTextNode("\n"));
addItem("version", $firmware, $fi);
addItem("build", $build, $fi);

$bi = $output->createElement("bootloader");
$version->appendChild($bi);
$bi->appendChild($output->createTextNode("\n"));
addItem("version", getUBootVersion(), $bi);

$main->appendChild($output->createTextNode("\n"));

// pull mode
$uploader = $output->createElement("uploader");
$main->appendChild($uploader);
$uploader->appendChild($output->createTextNode("\n"));
addItem("mode", $selectMode, $uploader);
if ($selectMode == "Manual") {
    if ($enable_project) {
        addItem("projectSource", $project_source, $uploader);
        addItem("projectTime", $time1, $uploader);
    }
    if ($enable_log) {
        addItem("logDestination", $logsource, $uploader);
        addItem("logTime", $time2, $uploader);
    }
} elseif ($selectMode == "Server") {
    addItem("calendar", $icalsource, $uploader);
}

$main->appendChild($output->createTextNode("\n"));

// license
if ($model !== 'ikebana') {
    $license = $output->createElement("license");
    $main->appendChild($license);
    $license->appendChild($output->createTextNode("\n"));
    addItem("checkDate", $licenseData['checkDate'], $license);
    foreach ($licenseData['features'] as $feature) {
        $features = $output->createElement("features");
        $license->appendChild($features);
        $features->appendChild($output->createTextNode("\n"));
        addItem("name", $feature['name'], $features);
        addItem("source", $feature['source'], $features);
        addItem("endDate", $feature['endDate'], $features);
        addItem("valid", $feature['valid'] ? 1 : 0, $features);
        $license->appendChild($output->createTextNode("\n"));
    }

    $main->appendChild($output->createTextNode("\n"));
}

if (hasPowerMCU()) {
    $powerInfo = getPowerInfo();
    $power = $output->createElement("power");
    $main->appendChild($power);
    addItem("source", getPowerSource($powerInfo), $power);
    addItem("watt", $powerInfo['power'], $power);
    $main->appendChild($output->createTextNode("\n"));
}

echo $output->saveXML();
