<?php

require_once './protected/utils/WebStorageAPI.php';

function webstorage_get( $names=null ) {
  
  if ( $names===null )
    throw new Exception("Missing names");
  
  if ( isset($names['debug']) ){
      $names = $names['debug'];
  }
  if ( !is_array($names) || isset($names['name']) )
      throw new Exception("expect array as argument");
  $store = new WebStorageAPI();
  $ret = array();
  foreach ( $names as $name ){
      $val = $store->get( $name );
      if ( $val===false )
          throw new Exception("Internal error");            
      $ret[] = $val;
  }
  $store->close();
  return $ret;
}

function respond($result, $error = NULL) {
  header("Content-Type: " . 'application/json');
  if ( $error ){
    http_response_code(404);
    $body = json_encode(array( "error" => $error) );
  } else {
    $body = json_encode($result);
  }
  header("Content-Length: " . strlen($body));
  echo $body;
  flush();
}
function process(){

  $verb = $_SERVER['REQUEST_METHOD'];
  try {  
    if ( isset($_GET['name']) && strlen( $_GET['name'] ) < 256 && $verb === "GET"){
      respond( webstorage_get( array( "spx:setup:".$_GET['name'] ) )[0] );             
    } else {
      respond(null, "Not found");
    }
  } catch( Exception $e ) {     
    respond(null, $e->getMessage());
  }  
}

process();