<?php

class m141114_112340_rbac extends CDbMigration
{
	
    public function createTask( $name, $desc, $operations ){
        $auth=Yii::app()->authManager;
        $task = $auth->createTask($name,$desc);
        foreach ( $operations as $opp => $desc ){
            $auth->createOperation( $opp, $desc );
            $task->addChild( $opp );
        }
        return $task;
    }
    public function createRole( $name, $desc, $childrens ){
        $auth=Yii::app()->authManager;
        $role = $auth->createRole($name,$desc);
        foreach ( $childrens as $child ){
            $role->addChild( $child );
        }
        return $role;
    }
    
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
        $auth=Yii::app()->authManager;

        $authenticated = $auth->createRole('authenticated', 'Authenticated user', 
                'return !Yii::app()->user->isGuest;');
        
        $auth->createRole('guest', 'Guest user', 
                'return Yii::app()->user->isGuest;');
        
        
        $this->createTask( 'manageMedia','manage (add, edit, remove) media', array( 
            'viewMedia' => 'view media',
            'uploadMedia' => 'upload media',
            'copyMedia' => 'copy media',
            'deleteMedia' => 'delete media',
            'editMedia' => 'edit media'
        ) );
        $this->createTask( 'managePlaylist','manage (add, edit, remove) Playlist', array( 
            'viewPlaylist' => 'view Playlist',
            'createPlaylist' => 'create Playlist',
            'deletePlaylist' => 'delete Playlist',
            'copyPlaylist' => 'copy Playlist',
            'editPlaylist' => 'edit Playlist'
        ) );
        $this->createTask( 'managePlayout','manage (add, edit, remove) Playout', array( 
            'viewPlayout' => 'view Playout',
            'createPlayout' => 'create Playout',
            'deletePlayout' => 'delete Playout',
            'copyPlayout' => 'copy Playout',
            'editPlayout' => 'edit Playout'
        ) );
        $this->createTask( 'managePlayoutLayers','manage (add, edit, remove) Playout Layers', array( 
            'editPlayoutLayers' => 'edit Playout Layer',
            'addPlayoutLayer' => 'add Playout Layer',
            'deletePlayoutLayer' => 'delete Playout Layer',
        ) );
        $this->createTask( 'manageExternal','manage (add, edit, remove) Live sources', array( 
            'viewExternal' => 'view External',
            'createExternal' => 'create External',
            'deleteExternal' => 'delete External',            
            'editExternal' => 'edit External'
        ) );
        
        
        $this->createTask( 'manageSchedule','manage (add, edit, remove) Schedule', array( 
            'viewSchedule' => 'view Schedule',
            'createSchedule' => 'create Schedule',
            'editSchedule' => 'edit Schedule',
        ) );        
                
        $this->createTask( 'useApps','use (view and edit) Apps', array( 
            'viewApps' => 'view Apps',
            'editApps' => 'edit Apps',                        
        ) );

        $this->createTask( 'manageTemplate','manage (add, edit, remove) Playout template', array( 
            'viewTemplate' => 'view Template',
            'createTemplate' => 'create Template',
            'deleteTemplate' => 'delete Template',
            'copyTemplate' => 'copy Template',
            'editTemplate' => 'edit Template'
        ) );
        
        
        $this->createRole('content', 'Content', array(
            'manageMedia', 'managePlaylist', 'managePlayout', 'managePlayoutLayers', 'manageSchedule', 'viewExternal','useApps', 'viewTemplate' 
        ));
        
        $this->createTask( 'manageMonitoring','view Monitoring information', array( 
            'viewSnapshot' => 'view Snapshot',
            'viewLogs' => 'view Logs'
        ) );
        
        $this->createRole('monitoring', 'Monitoring', array(
            'manageMonitoring'
        ));
        
        $authenticated->addChild('viewMedia');
        $authenticated->addChild('viewPlaylist');
        $authenticated->addChild('viewPlayout');
        $authenticated->addChild('viewSchedule');
        $authenticated->addChild('viewExternal');
        $authenticated->addChild('useApps');        
        
        $this->createTask( 'manageUser','manage (add, edit, remove) User', array( 
            'viewUser' => 'view User',
            'createUser' => 'create User',
            'deleteUser' => 'delete User',
            'updateUser' => 'update User',
            'updateUserRights' => 'edit User Rights'
        ) );
        
        $this->createTask( 'manageConfig','manage Configuration', array( 
            'useWizard' => 'use wizard',
            'useControlCenter' => 'use Control Center',                        
            'createReport' => 'create Report',
        ) );
        
        
        $admin = $this->createRole('admin', 'Administrator', array(
            'content', 'monitoring', 'manageConfig', 'manageUser'
        ));        
        
        
        $manageApps = $this->createTask( 'manageApps','manage (add, remove) Apps', array( 
            'uploadApps' => 'upload Apps',
            'deleteApps' => 'delete Apps',                        
        ) );
        $manageApps->addChild('useApps');
        
        // Special rights for the advanced item menu, not assigned to any users by defaults
        $auth->createOperation('useAdvancedConfig','view Control Center advanced options');        
        
        $this->createRole('advanced', 'Advanced', array(
            'useAdvancedConfig', 'manageTemplate', 'manageApps'
        ));
        
        $auth->save();
	}

    public function safeDown()
	{
		$auth=Yii::app()->authManager;
        $auth->clearAll();
	}

}