<?php
class WebStorage extends CFormModel {
	
    protected $folder="/srv/raperca/webstorage/";
    
    var $origine;
    
    public function rules() {
		$res = array(
            array( "origine", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'origine'=>'Storage origine',
		);
	}
    
    function getOrigineList() {
        $result = array();
        $haslocal = false;
        if ( !file_exists( $this->folder ) )
            return $result;
        $handle = opendir( $this->folder );
        if ( $handle ) {
            while ( false !== ($entry = readdir($handle)) ) {
                $origine = false;
                if ( $entry=="local.db" ) {
                    $origine = array();
                    $origine['proto'] = "";
                    $origine['host'] = "local";
                    $origine['name'] = "local";
                    
                    $haslocal = true;
                } else if ( substr($entry, -3)==".db" ) {
                    $origine = array();
                    $st = strpos( $entry, "_" );
                    $proto = substr( $entry, 0, $st );
                    if ( $proto =="http" || $proto =="https" ) {
                        $ed = strrpos( $entry, "_" );
                        $port = substr( $entry, $ed+1, -3 );
                        $host = substr( $entry, $st+1, $ed-$st-1 );
                        $name = $proto . "://" . $host;
                        if ( $port=="0" || ($port=="80" && $proto =="http") || ($port=="443" && $proto =="http3") ) {
                            // don't shot the port
                        } else {
                            $name .= ":".$port;
                        }
                    } else {
                        $port = "";
                        $host = substr( $entry, $st+1, -3 );
                        $name = $host;
                    }
                    $origine['proto'] = $proto;
                    $origine['name'] = $name;
                    $origine['host'] = $host;
                    $origine['port'] = $port;
                } 
                if ( $origine!==false ) {                
                    // lets get the content of the storage using SQL
                    $db = new PDO("sqlite:".$this->folder.$entry);
                    $db->setAttribute(PDO::ATTR_TIMEOUT, 5); // 5 sec of timeout should be enough
                    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    try {
                        $s = $db->prepare("PRAGMA page_size;");
                        $s->execute( );
                        $res = $s->fetchAll(PDO::FETCH_ASSOC);
                        $page_size = $res[0]['page_size'];
                        
                        $s2 = $db->prepare("PRAGMA page_count;");
                        $s2->execute( );
                        $res2 = $s2->fetchAll(PDO::FETCH_ASSOC);
                        $page_count = $res2[0]['page_count'];
                        
                        $origine['size'] = round( $page_count*$page_size/1024 );
                        
                        /*
                        $s = $db->prepare("SELECT (KEY,VALUE) FROM WEBSTORAGE");
                        $s->execute( );
                        
                        $origine['data'] = print_r( $s->fetchAll(PDO::FETCH_ASSOC), true );
                        */
                    } catch (Exception $e) { 
                        $origine['size'] = "error";
                    }
                    
                    $result[] = $origine;     
                }
            }
            closedir($handle);
        } 
        if ( !$haslocal ) {
            // add local storage anyway to the answer
            $origine['proto'] = "";
            $origine['host'] = "local";
            $origine['name'] = "local";
            $origine['size'] = 0;
            $origine['quota'] = 1024;
            
            $result[] = $origine;
        }
        return $result;
    }
    
    function clear() {
        $jobs = new MaintenanceJobs;
        if ( $jobs->clearWebstorage() ) {
            exec('sync'); // make sure the clean-cache file is on stable storage
            Tools::addReason("clear webstorage");
        }
    }
    
}
