<?php

require_once dirname(__FILE__).'/MainInfo.php';

class BrandingInfoBase {
    var $vendor = "[No branding found]";
    var $product = "[No branding found]";
    var $mediacheck = 200;
    var $extendedFormat = true;
    var $maintitle = "[No branding found]";
    var $email = "support@spinetix.com";
    var $releasepkg = "spinetix-release";
    var $linkfirmware = "<a href='http://www.spinetix.com/support'>No branding found</a>";
    var $hwTempPath = "";
    var $hwTempFileIndex = "";
    var $rights = array();

    public $serialPorts = array();

    protected $licenses = array();
    protected $license = 'ARYA';
    protected $features;
    protected $licenseRights;
    protected $licenseData = array();

    public function __construct()
    {
        $data = getInfoSerial($serial, $model, $hardware);
        $model = explode("|", $model);
        $model = count($model) >= 2 ? $model[1] : $model[0];
        if (($branding = @file_get_contents(
            '/usr/share/resources/default/interface/branding.json'))
            && ($branding = json_decode($branding, true))
            && isset($branding[$model])
        ) {
            foreach ($branding[$model] as $name => $value) {
                $this->$name = $value;
            }
        }
    }

    public function hasLicense()
    {
        $this->loadLicense();
        return $this->license !== 'ARYA';
    }

    public function hasValidLicense()
    {
        $this->loadLicense();
        return $this->license !== 'ARYA' && $this->license !== 'EXPIRED';
    }

    public function getLicense()
    {
        $this->loadLicense();
        return $this->license;
    }

    public function getLicenses()
    {
        $this->loadLicense();
        return $this->licenses;
    }

    public function getFeatures()
    {
        $this->loadLicense();
        return $this->features;
    }

    public function getLicenseData()
    {
        $this->loadLicense();
        return $this->licenseData;
    }

    public function hasRight($name){
        return in_array($name, $this->rights)
            || $this->hasRightFromLicense($name);
    }

    protected function loadLicense()
    {
        if ($this->features !== null) {
            return true;
        }
        
        $this->features = array();
        $this->licenseRights = array();

        $info = @file_get_contents('/run/licensecheck/license-features.json');
        if (!$info) return false;

        $info = json_decode($info, true);

        if ( !isset( $info["features"] ) ) return false;

        $FeatureRightsMap = array(
            // WIDGETS
            "HMP" => array( 'displayAR', 
                            'NTP',
                            'contentProject', 'pullMode',
                            'firmware', 'log', 'security'
                          ),   
            "COM" => array( 'peripherals', 'peripheralsSerial', 'peripheralsFSM' ),
            // KIOSK
            "INTER" => array( 'interactivity'  ),
            "HTML" => array( 'HTML', 'webRtc' ),
            // SYSTEMS 
            "MULTI" => array( 'multiscreen', 'displayAdvanced', 'displayCustom', 'netAPI' ), 
            "STREAM" => array( 'streaming', 'networkWatchdog', 'peripheralsUSBAPI', 'peripheralsFSMAdvanced' )
        );
        foreach ( $info["features"] as $feature ) {
            if ( !isset( $feature["name"] ) || !isset( $feature["source"] ) || !isset( $feature["valid"] ) ) continue;
            $n = $feature["name"];
            if (strpos($n, '#') === 0) {
                continue;
            }
            if ( $n[0] === "_" && !$feature["valid"] ) $this->licenses[$feature["source"]] = "EXPIRED";
            if (!$feature["valid"]) continue;

            if ( $n[0] === "_") {
                $this->licenses[$feature["source"]] = substr($n, 1);
            } else {
                array_push( $this->features, $n);
            }

            if ( !isset( $FeatureRightsMap[ $n ] ) ) {
                array_push( $this->licenseRights, $n );
                continue;
            }
            foreach ( $FeatureRightsMap[ $n ] as $right ) {
                array_push( $this->licenseRights, $right );
            }
        }

        $licenseTypes = array('ARYA', 'EXPIRED', 'WIDGETS', 'KIOSK', 'SYSTEMS');
        $licenseLevels = 
            array_combine($licenseTypes, array_keys($licenseTypes));
        foreach ($this->licenses as $source => $type) {
            if (isset($licenseLevels[$type]) && 
                $licenseLevels[$type] > $licenseLevels[$this->license]) {
                $this->license = $type;
            }
        }

        $this->licenseData = $info;

        return true;
    }

    protected function hasRightFromLicense($name)
    {
        $this->loadLicense();
        return in_array($name, $this->licenseRights);
    }
}

$branding_file="/usr/share/resources/default/interface/branding.php";
if( PHP_OS == "WINNT" ) {
    $branding_file="/SpinetiX/sources/genesis/trunk/branding/hmp350/SpinetiX/interface/branding.php";
}
if ( file_exists($branding_file) ){
    include $branding_file;
} else {
    class BrandingInfo extends BrandingInfoBase {
        
    }
}
