<?php
/* @var $this UserController */

$defaultUser = $users[0];

function skipItem( $name ){
    if ( $name == "advanced" && !Yii::app()->user->checkAccess('useAdvancedConfig') ){
        return true;
    }
    if ( $name == "monitoring" && !Yii::app()->branding->hasRight('security') ){
        return true;
    }
}
$rights = $defaultUser->userRights->getAllRights();
$mainRow = $this->beginWidget('BsRow' );

$mainRow->beginCol( 12, array( 'data-bind'=> "css: { 'col-lg-6': user.show }") );
$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "User Management",
    'id' => 'UserManagement',    
) );
    $headers = array( 
        $defaultUser->getAttributeLabel( "username"),
        $defaultUser->getAttributeLabel( "hasSRP"),
        "",
        ""
    );
    $options = array(
        "data-bind" => "foreach: users",
        "sizes" => array( "col-xs-9", "col-xs-1","col-xs-1", "col-xs-1" )
    );
    
    $row = array();
    $row[] =CHtml::textField( "username", "username", $formConfig->itemOptions( array(
        "disabled" => "disabled",
        "data-bind" => "value: username"
    ) ) );
    $row[] =CHtml::tag( "i", array("class"=> "fa fa-2x", "data-bind" => "css: srp, attr: { title: srpTitle }" ) );
    /*
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-pencil"), "" ), array( 'user/update'), array(
        "data-bind" => "click: \$parent.removeUser" . Yii::app()->user->id!=1?", css: { disabled: id() == 1 }":"",
        "class" => "btn btn-sm btn-default btn-block"
    ) );
    */
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-pencil"), "" ), "#", array(
        "data-bind" => "click: \$parent.editUser, css: { hidden: id() == 1 }",
        "class" => "btn btn-sm btn-default btn-block"
    ) );
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), array( 'user/delete'), array(
        "data-bind" => "click: \$parent.removeUser, css: { hidden: id() == 1 || id() == ".Yii::app()->user->id." }",
        "class" => "btn btn-sm btn-warning btn-block"
    ) );
    $this->widget('BsRow', array( 
        'options' => array( 'class' => 'table-responsive'),            
        'content' => $formConfig->table( $headers, array( $row ), $options) 
    ));
    $this->widget('BsRow', array( 'cols' => array( 
        array( 'sizes' => array( 'sm' => 6, 'md' => 5 ), 
            'offsets' => array( 'sm' => 6, 'md' => 0 ),
            'content' => CHtml::link( "New", array( 'user/add'), array(
                            "data-bind" => "click: newUser",
                            "class" => "btn btn-sm btn-default btn-block"
                        ))
            )
    )));
$this->endWidget();
$mainRow->endCol();
$mainRow->beginCol( array( 'sizes' => array( 'xs'=>12, 'lg'=>6 ) ) );
$userConfig = $this->beginWidget('SimpleForm', array( 
    'title' => array( "", array( 
        'data-bind' => "text: user.id()?'Update User':'New User'"
    )),
    'button' => array( "", array( 
        'data-bind' => "text: user.id()?'Apply':'Create'"
    )),
    'action' => array( 'post' => array("user/update" ),
        'ko' => "saveUser"
    ),
    'dataBind' => 'visible: user.show'
) );
    
    echo CHtml::openTag("div", array( "data-bind" => "with: user") );
        echo $userConfig->activeHiddenField( $defaultUser, "id", array( ), "yiiModel.user" );    
        echo $userConfig->activeTextField( $defaultUser, "username", array( "data-bind" => "disable: id()==1 " ), "yiiModel.user" );    
        echo $userConfig->activePasswordField( $defaultUser, "password", array(), "yiiModel.user" );    
        echo $userConfig->activePasswordField( $defaultUser, "verifyPassword", array(), "yiiModel.user" );  
        
        ob_start(); 
        echo $userConfig->activeCheckBox( $defaultUser->userRights, 'default', array(
            'data-bind' => 'disable: true',
            'offset' => 0
        ), false , true );
        foreach ( $rights as $name=>$desc ){
            if ( skipItem( $name ) ){
                continue;
            }
            echo $userConfig->activeCheckBox( $defaultUser->userRights, $name, array(
                'data-bind' => 'disable: '.$name.'Disabled',
                'offset' => 0
            ), "yiiModel.user", true );        
        }
        $rightsData = ob_get_contents ( );
        ob_end_clean();
        echo $userConfig->activeItem( $defaultUser->userRights, 'title', $rightsData );
    echo CHtml::closeTag("div");
$this->endWidget();
$mainRow->endCol();

$this->endWidget();

$deleteUrl = CHtml::normalizeUrl(array("user/delete"));

?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.user.show = ko.observable();
<?php
    foreach ( $rights as $name=>$desc ){
        if ( skipItem( $name ) ){
            continue;
        }
        $txt = 'yiiModel.user.'.$name.'Disabled = ko.computed(function(){'."\n";
        $txt .='    var d = false;'."\n";
        foreach ( $desc['depends'] as $d ){
            $txt .= '    d = d || yiiModel.user.'.$d."();\n";
        }
        $txt .= "    if ( d ) { yiiModel.user.$name(true); } ";
        $txt .= "    return d;\n";
        $txt .= "});\n";
        echo $txt;
    }
?>
    
yiiModel.users = ko.observableArray( <?php
    $usersList = array();
    foreach ($users as $i => $user ){
        $items = array(
            "username" => "js:ko.observable('".$user->username."')",            
            "srp" => $user->getHasRSP()?'fa-check text-success':'fa-warning text-warning',
            "srpTitle" => $user->getHasRSP()?'':'Update user password to enable SRP',
            "id" => "js:ko.observable('".$user->id."')",            
        );        
        foreach ( $rights as $name=>$desc ){
            $items[$name] = "js:ko.observable('".$user->userRights->$name."')";  
        }
        $usersList[] = $items;
    }
    echo CJavaScript::encode( $usersList );
?> );
function createUser( src ){
    return <?php
    $items = array(
        "username" => "js:ko.observable( src.username() )",            
        "srp" => 'fa-check text-success',
        "srpTitle" => "",
        "id" => "js:ko.observable( src.id() )",            
    );        
    foreach ( $rights as $name=>$desc ){
        if ( skipItem( $name ) ){
            continue;
        }
        $items[$name] = "js:ko.observable( src.$name() )";  
    }    
    echo CJavaScript::encode( $items );
?>;
}
function updateRights( src, target ){
<?php
    foreach ( $rights as $name=>$desc ){
        if ( skipItem( $name ) ){
            continue;
        }
        echo "    target.$name( src?src.$name():false )"."\n";
    }
?>  
}

yiiModel.removeUser = function( model, ev ) {    
    var user = this;
    var btn = $(ev.currentTarget);
    var opt = {
        url: btn.attr("href"),
        data: { id: model.id() },
        type: 'POST'
    };
    yiiModel.doAjax( yiiModel, ev, opt, function( ev, response ){
        if ( response.success ){
            yiiModel.users.remove(user);    
        }
    });
    return false;
};
yiiModel.editedUser;
yiiModel.editUser = function() {    
    yiiModel.editedUser = this;
    yiiModel.user.username( yiiModel.editedUser.username() );
    yiiModel.user.id( yiiModel.editedUser.id() );
    yiiModel.user.password( "" );
    yiiModel.user.verifyPassword( "" );
    updateRights( yiiModel.editedUser, yiiModel.user );
    yiiModel.user.show( true );  
    return false;
};
yiiModel.newUser = function() {
    yiiModel.editedUser = null;
    yiiModel.user.username( "" );
    yiiModel.user.id( "" );
    yiiModel.user.password( "" );
    yiiModel.user.verifyPassword( "" );
    updateRights( false, yiiModel.user ); 
    yiiModel.user.show( true );    
};
yiiModel.saveUser = function( model, ev ) {
    // ajax to save  
    yiiModel.doAjaxForm( model, ev, function( ev, response ) {
        
        if ( response.success ){
            if ( yiiModel.editedUser ) {
                yiiModel.editedUser.username( response.data.username );
                updateRights( yiiModel.user, yiiModel.editedUser );        
            } else {        
                yiiModel.user.id(response.data.id);
                yiiModel.users.push( createUser( yiiModel.user ) );
            }   
            yiiModel.user.show( false );
        }
    });
    return false;
};

//]]></script>
