<?php
/* @var $this ConfigController */

$properties = array('title' => "Serial", 'id' => "Serial");
if (Yii::app()->device->model === 'ikebana' 
    || !empty($serialConfig->devices)
) {
    $properties['button'] = "Apply";
    $properties['action'] = array ( 'post' => array() );
}
$formConfig = $this->beginWidget('SimpleForm', $properties);
    $formConfig->errorSummary( $serialConfig );
    if (Yii::app()->device->model === 'ikebana' 
        || !empty($serialConfig->devices)
    ) {
        echo $formConfig->activeCheckBox( $serialConfig, "enableSerial", array(), true );
        echo CHtml::openTag("div", array( 'data-bind'=>'visible: enableSerial') );
            if (Yii::app()->device->model !== 'ikebana') {
                echo $formConfig->activeDropDownList($serialConfig, 'device',
                    $serialConfig->devices, array(), true);
                echo $formConfig->activeHiddenField($serialConfig, 'name',
                    array('data-bind' => 'value: name()'));
            }
            echo $formConfig->activeDropDownList($serialConfig, "baudRate", $serialConfig->toList('baudRate'));
            echo $formConfig->activeDropDownList($serialConfig, "byteSize", $serialConfig->toList('byteSize'));
            echo $formConfig->activeDropDownList($serialConfig, "parity", $serialConfig->toList('parity'));
            echo $formConfig->activeDropDownList($serialConfig, "stopBits", $serialConfig->toList('stopBits'));
        echo CHtml::closeTag("div");
    } else {
        echo BsHtml::alert(
            BsHtml::ALERT_COLOR_INFO, "No serial devices currently attached.");
    }
$this->endWidget();

?>

<script>
yiiModel.name = ko.computed( function() {
    const devices = <?php echo CJavaScript::encode($serialConfig->devices);?>;
    if (devices.length === 0) return '';
    return devices[yiiModel.device()];
});
</script>
