<?php
/* @var $this OperationController */

$form = $this->beginWidget('SimpleForm', array( 
    'title' => "Support",
    'id' => "Support",
) );
if ( !yii::app()->user->ikebanaBetaFeatureRemove ) {
    $this->widget( 'DialogButton' , array(
        'label' => "Start Self Test",
        'link' => array("/controlcenter/diagnosis"),
        'level' => BsHtml::ALERT_COLOR_INFO,
        'content' => "Starts a set of self tests to verify the hardware components of the ".Yii::app()->branding->product,
    ));
}
    $txt = "Before contacting ".Yii::app()->branding->vendor." support team ".
    "(<a href='mailto://".Yii::app()->branding->email."'>".Yii::app()->branding->email."</a>), ".
    "please generate a status report with all display attached to the ".Yii::app()->branding->product.".\n";
    
    echo CHtml::beginForm( array( "operation/report" ), "GET");
    $this->widget('BsRow', array(
        'cols' => array( 
            array( 'sizes' => array( 'md' => 9 ), 
                   'content'=> BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $txt, array( 'closeText' => false ))
            ),
        )
    ));    
    $this->widget('BsRow', array(
        'cols' => array( 
            array( 'sizes' => array( 'md' => 9 ), 
                   'content'=> $form->checkBox( "Generate extended report (this can take up to 5 minutes)", 
                                                "extended", false )
            ),
            array( 'sizes' => array( 'sm' => 6, 'md' => 3 ), 
                'offsets' => array( 'sm' => 6, 'md' => 0 ), 
                'content' => $this->widget('ActionButton', array( 
                    'label' =>'Get Report',
                    'block' => true, 
                    'post' => array("operation/report") 
                    ), true )
            )
        )
    ));
    echo CHtml::endForm();
    
    if ( Yii::app()->user->checkAccess('useAdvancedConfig') ) {
        $this->widget( 'DialogButton' , array(
            'rowOptions' => array( 'data-bind' => 'visible: remoteSupport()',),
            'label' => "Remote Support",
            'link' => array("operation/remoteSupport", 'enable'=>'stop' ),
            'ko' => "switchRemoteSupport",
            'level' => BsHtml::ALERT_COLOR_INFO,
            'content' => "Services for remote ".Yii::app()->branding->vendor." support are running.",
        ));
        $this->widget( 'DialogButton' , array(
            'rowOptions' => array( 'data-bind' => 'hidden: remoteSupport()',),
            'label' => "Remote Support",
            'link' => array("operation/remoteSupport", 'enable'=>'start' ),
            'ko' => "switchRemoteSupport",
            'level' => BsHtml::ALERT_COLOR_INFO,
            'content' => "Start services for remote ".Yii::app()->branding->vendor." support on the ".Yii::app()->branding->product." for diagnostic and debugging purposes.\n".
                         "Note: the first time it takes a considerable amount of time to start support services, please be patient.",
        ));
    }
$this->endWidget();

$this->observable('recoveryMode', false );
$this->observable('remoteSupport', $maintenance->checkSSH() );
?>
<script type="text/javascript" >
//<![CDATA[
   
yiiModel.switchRemoteSupport = function( model, ev ) {
    var self = this;
    this.doAjaxButton( model, ev, 
        function( ev, response ) {
            yiiModel.remoteSupport( response.data.enabled );
        }
    );
};



//]]></script>