<?php
/* @var $this MainController */

$this->registerSpxScript( 'firmware.js' );
$configFirmware = array(
    'urlNetCheck' => CHtml::normalizeUrl(array("operation/checkNetwork")),
    'urlFirmwareStatus' => CHtml::normalizeUrl(array("/main/firmware", "handle" => "SRC"))
);
$summary = CHtml::normalizeUrl(array("main/summary"));

if ( Yii::app()->user->checkAccess('useControlCenter') ){
    $tempLink = "You can increase the shutdown temperature using the ". CHtml::link("configuration page", array('system', "#"=>"Hardware") ) .".";
    $maintenanceLink = CHtml::link("Go to Maintenance...", array( 'operations' ,'#'=> 'Maintenance' ) );
    $ipConfigLink = CHtml::link("Go to IP Configuration...", array( 'network' ,'#'=> 'IP' ) );
    $displayLink = CHtml::link("Go to Display...", array( 'display' ,'#'=> 'Display' ) );
    $storageLink = CHtml::link("Manage Content...", array( 'content' ,'#'=> 'Download' ) ) ."<br/>" .
                   CHtml::link("Reset Storage...", array( 'operations' ,'#'=> 'Reset' ) );
    $logLink = CHtml::link("Show logs...", array( 'logs' ,'#'=> 'Current' ) );
    $fimrwareLink = CHtml::link("Go to Firmware Update...", array( 'operations' ,'#'=> 'Firmware' ) );
    $timeLink = CHtml::link("Set time...", array( 'system' , '#'=> 'DateTime' ) );
} else {
    $tempLink = "";
    $maintenanceLink = CHtml::link("Show logs...", array( 'logs' ,'#'=> 'Current' ) ); 
    $ipConfigLink = "";
    $displayLink = "";
    $storageLink = "";
    $logLink = CHtml::link("Show logs...", array( 'logs' ,'#'=> 'Current' ) );    
    $fimrwareLink = "";
    $timeLink = "";
}

if (Yii::app()->device->model !== 'Bonsai') {
    if ( $basicInfo->getTemp_max() || $basicInfo->getTemp_crit() ) {
        $this->widget("Gritter", array(
            'title' => "Maximum temperature reached",
            'desc' => "The player will shutdown if the condition persists." ." ".
            $tempLink,
        ));
    }
}

ob_start();

$info = array(
    array( 'label'=>"Name", 'value' => $playerConfig->deviceName ),
    array( 'label'=>"Time zone" , 'value' => $timeSettings->getTimeZoneString() ),
);
if ($screenInfo->settingsStr) {
    $info[] = array( 'label'=>"Display settings" , 'value' => $screenInfo->settingsStr );
}

$table =  $this->widget('DataTable', array( 'data' => $info ), true );

$this->beginWidget('bootstrap.widgets.BsPanel', array(
    'title' => 'Current Settings',
    'beforeBody' => $table
));

if ( $ARYAEnabled ){
    $this->widget('BsRow', array(
        'cols' => array( 
            array( 
                'size' => 6,
                'content' => $this->widget( 'ActionButton' , array(
                    'label' => "Disable ARYA",
                    'link' => array("operation/arya", "enable" => false),
                    'ko' => 'doAjaxButton',
                    'block' => true,
                    'type' => "primary"
                ), true )
            )            
        )
    ));
} else {
    if ( Yii::app()->user->checkAccess('useControlCenter') ){
        if ( Yii::app()->branding->hasRight('ARYA') ){
            $this->widget('BsRow', array(
                'cols' => array( 
                    array( 
                        'size' => 6,
                        'content' => $this->widget( 'ActionButton' , array(
                            'label' => "Enable ARYA",
                            'link' => array("operation/arya"),
                            'ko' => 'doAjaxButton',
                            'block' => true,
                            'type' => "primary"
                        ), true )
                    ),
                    array( 
                        'size' => 6,
                        'content' => BsHtml::button('Configuration Wizard', array(
                            'block' => true,                 
                            'color' => BsHtml::BUTTON_COLOR_PRIMARY, 
                            'data-bind' => "click: function() { yiiWizard.show(); }" 
                        ) )
                    )
                )
            ));
        } else {
            $this->widget('BsRow', array(
                'cols' => array(                     
                    array( 
                        'size' => 6,
                        'offset' => 6,
                        'content' => BsHtml::button('Configuration Wizard', array(
                            'block' => true,                 
                            'color' => BsHtml::BUTTON_COLOR_PRIMARY, 
                            'data-bind' => "click: function() { yiiWizard.show(); }" 
                        ) )
                    )
                )
            ));
        }
    } else {
        echo $logLink;
    }
}
$this->endWidget();

$this->beginWidget('bootstrap.widgets.BsPanel', array(
    'title' => 'Quick Links'
));
    $cockpitEnabled = $pullModeConfig->cockpitUri != null;
    $cockpitHost = "https://cockpit.spinetix.com";
    $cockpitUri = "/users/remote_login";
    $cockpitNewPlayer = "/users/concentrator_url.json";

    if ( $cockpitEnabled ){
        $cockpitTxt = BsHtml::linkButton('Open in Cockpit', array( 'block' => true, 'target' => '_blank', 'url' => $cockpitHost . '/players/'.$this->serviceSerial ."/search") ) ;
    } else if ( Yii::app()->user->checkAccess('useControlCenter') ){
        $cockpitTxt = 
            CHtml::beginForm(  array( ), "POST" ).
            CHtml::activeHiddenField($pullModeConfig, "cockpitUri", array( 'id' => 'CockpitUri' )) .        
            $this->widget('ActionButton', array( 
                    'label' => 'Monitor by Cockpit', 
                    'options' => array( 'id' => 'CockpitMonitor' ),
                    'block' => true, 
                    'post' => true
            ), true ) .
            CHtml::endForm() .
            BsHtml::linkButton('Configure Cockpit', array( 'id' => 'GoSystem', 'block' => true, 'url' => array( "main/system", "#" => 'Cockpit' )) );
    } else {
        $cockpitTxt = "";
    }
    if ( Yii::app()->user->checkAccess('useControlCenter') ){
        $this->widget('BsRow', array(
        'cols' => array( 
            array( 'size' => 6, 
                'content' => $this->widget('ActionButton', array( 
                    'label' => 'Restore Config', 
                    'block' => true, 
                    'link' => array( "backup/post" ), 
                    'file' => CHtml::activeName( $configBackup, 'uploadedfile' ) 
            ), true ) ),
            array( 'size' => 6, 'content' => $cockpitTxt ),
            array( 'size' => 6, 
                'content' => $this->widget('ActionButton', array( 
                    'label' => 'Generate Report', 
                    'block' => true, 
                    'link' => array("operation/report") 
            ), true ) ),
            array( 'size' => 6, 
                'content' => $this->widget('ActionButton', array( 
                    'label' => 'Restart Now', 
                    'block' => true, 
                    'link' => array("operation/reboot", 'reboot'=>true, ), 
                    'ko' => 'doAjaxButton' 
            ), true ) ),
        ) ) );
    } else {
        $this->widget('BsRow', array(
        'cols' => array( 
            array( 'size' => 6, 'content' => $cockpitTxt ),
            array( 'size' => 6, 
                'content' => $this->widget('ActionButton', array( 
                    'label' => 'Generate Report', 
                    'block' => true, 
                    'link' => array("operation/report") 
            ), true ) ),            
        ) ) );
    }
$this->endWidget();

if (Yii::app()->user->checkAccess('useControlCenter')) {
    $this->beginWidget(
        'bootstrap.widgets.BsPanel', 
        array('title' => 'SpinetiX Pairing PIN')
    );
    echo CHtml::tag("p", array(
        'style' => 'text-align: center; font-size: 200%',
        'data-bind' => 'text: pin'
    ));
    $this->widget('BsRow', array('cols' => array(array(
        'size' => 6,
        'offset' => 6,
        'content' => BsHtml::button(
            'Show', 
            array('block' => true, 'data-bind' => "click: checkPin")
        )
    ))));
    $this->endWidget();
}

$Settings = ob_get_contents ( );
ob_end_clean();

$verticalSnapshot = SnapshotDisplay::isVertical( $playerConfig->orientation );
ob_start(); 
$this->beginWidget('bootstrap.widgets.BsPanel', array(
    'title' => 'Snapshot'
));
    echo CHtml::openTag("div", array( 
        "class"=>"content",  "style" => "min-height: 110px;"      
    )). "\n";
    
    $this->widget('SnapshotDisplay', array(
        'resolution' => $screenInfo->resolution,
        'aspect' => $screenInfo->aspect,
        'orientation' => $playerConfig->orientation,
    ) );
        
    echo CHtml::tag("div", array( "style" => "margin-top: 15px;" ) , " " );
    /*
    
    echo CHtml::tag("div", array(
        "id" => 'snapshot',
        "class" => "spx-preview spx-preview-fixed-item spx-preview-background",
        "style" => "background-image: url(/snapshot);"
    ), " ");       
    
     */
    echo CHtml::closeTag("div");      
      
    $this->widget('BsRow', array(
        'cols' => array( 
            array( 
                'size' => 6, 'offset' => 6,
                'content' => BsHtml::button('Refresh', array(
                    'block' => true,                 
                    'data-bind' => "click: function() { var d = new Date(); $('#snapshot').attr('src', '/snapshot?_=' + d.getTime() ); }"
                ) )
            )
        )
    ));
$this->endWidget();
$Snapshot = ob_get_contents ( );
ob_end_clean();

ob_start(); 
$this->beginWidget('bootstrap.widgets.BsPanel');
    if ( $verticalSnapshot ){
        $sizes = array( 'xs' => 6, 'sm' => 4, 'md' => 6, 'xl' => 4);  
    } else {
        $sizes = array( 'xs' => 6, 'sm' => 4, 'md' => 3, 'xl' => 2 );        
    }
    $row = $this->beginWidget('BsRow');
        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'MODEL', 
                            'text' => $basicInfo->product
                        ), true ) 
        ) );
        $firmwareAlert = "js: firmwareInfo().executed && ( !firmwareInfo().success || firmwareInfo().updates > 0)";
        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'FIRMWARE', 
                            'text' => "js: summaryData.firmware",
                            'alert' => $firmwareAlert,
                            'popover' => array( "Firmware", "js:firwareInfoTextButton"),
                            //'link' => array( 'operations' ,'#'=> 'Firmware' ) 
                        ), true ) 
        ) );
        if ( Yii::app()->device->model !== 'ikebana' ) {
            $licenses = array();
            foreach (Yii::app()->branding->getLicenses() as $source => $type) {
                if ($source === 'software') {
                    $label = 'DSOS';
                } else {
                    $label = ucwords(trim($source));
                }
                $licenses[] = array('label' => $label, 'value' => $type);
            }
            if (count($licenses)) {
                $popover = array("License", $this->widget(
                    'DataTable', array('data' => $licenses), 
                    true
                ));
            } else {
                $popover = array();
            }
            $row->addCol( array( 
                'sizes'=>$sizes, 
                'content'=> $this->widget('ButPro', array( 
                                'title' => 'LICENSE', 
                                'text' => Yii::app()->branding->getLicense(),
                                'popover' => $popover
                            ), true ) 
            ) );            
        }
        $macAddresses = array();
        foreach ($basicInfo->mac as $interface => $address) {
            if (strpos($interface, "e") === 0) {
                $label = 'MAC LAN';
            } elseif (strpos($interface, "wlan") === 0) {
                $label = 'MAC Wi-Fi';
            } else {
                continue;
            }
            $macAddresses[] = array('label' => $label, 'value' => $address);
        }
        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'SERIAL NUMBER', 
                            'text' => $this->serial,
                            'popover' => array("Serial Number", $this->widget(
                                'DataTable', array('data' => $macAddresses), 
                                true
                            ))
                        ), true ) 
        ) );
        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'UP TIME', 
                            'text' => 'js:summaryData.uptime',
                            'popover' => array( "Up Time", $maintenanceLink )
                        ), true ) 
        ) );
        const MAX_TIME_DIFFERENCE = 60 /* seconds */;
        ob_start();
        $time = array(
            array( 'label' => "Time", 'value' => 
                '<span data-bind="text: moment(summaryData.time(), ' .
                '\'D MMM YYYY H:mm:ss\').format(\'HH:mm:ss\')"></span>' ),
            array( 'label' => "Date", 'value' => 
                '<span data-bind="text: moment(summaryData.time(), ' .
                '\'D MMM YYYY H:mm:ss\').format(\'D MMMM YYYY\')"></span>' ),
        );
        $this->widget('DataTable', array( 'data' => $time ));
        echo CHtml::openTag("div", array("data-bind" => 
            "visible: timeAlert()"
        ));
            echo CHtml::tag('p', array(), 'Time on the player seems to be ' .
                'off by more than ' . MAX_TIME_DIFFERENCE . ' seconds.'
            );
        echo CHtml::closeTag("div");
        echo $timeLink;
        $popoverContent = CJavaScript::encode(ob_get_clean());
        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'PLAYER TIME', 
                            'text' => "js: moment( summaryData.time(), " .
                                "'D MMM YYYY H:mm:ss').format('HH:mm')",
                            'alert' => "js: timeAlert()",
                            'options' => array('data-bind' => 'popover: ' .
                                '{dataContent: ' . $popoverContent . ', title: ' .
                                '"Player Time", placement: "bottom", ' .
                                'addCloseButtonToTitle: false, whiteList}')
                        ), true ) 
        ) );
        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'CPU LOAD', 
                            'text' => "js:summaryData.cpuInfo && summaryData.cpuInfo.usage && summaryData.cpuInfo.usage.average() + '%' || 'UNKNOWN'",
                            'popover' => array( "CPU Load", "js:cpuInfoText"),
                        ), true ) 
        ) );

        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'STORAGE', 
                            'text' => "js: Math.round( summaryData.storage.used() / summaryData.storage.tot() *100 ) + '%'", 
                            'alert'=> "js: summaryData.storage.free() / summaryData.storage.tot() < 0.05", 
                            'popover' => array( "Storage", "js:storageInfoText"), 
                        ), true ),                    
        ) );
        $popover = $displayLink ? array('Display', $displayLink) : false;
        if ($playerConfig->hasMultipleVideoOutputs()) {
            $row->addCol( array( 
                'sizes'=>$sizes, 
                'content'=> $this->widget('ButPro', array( 
                                'title' => 'DISPLAY', 
                                'text' => 'Multi-output',
                                'popover' => $popover,
                            ), true ) 
            ) );    
        } else {
            $row->addCol( array( 
                'sizes'=>$sizes, 
                'content'=> $this->widget('ButPro', array( 
                                'title' => 'DISPLAY', 
                                'text' => "js: summaryData.screenInfo.text",
                                'alert' => "js: summaryData.screenInfo.alert",
                                'popover' => $popover,
                            ), true ) 
            ) );    
        }
        $networkPopover = false;
        if ( $basicInfo->isZeroConf() ){
            $network = "LIMITED";
            $networkAlert = true;
            $networkPopover = array( "Limited network conectivity",
                "This device is using a Zeroconf IP address (link-local) and thus it has limited network conectivity." ." ".
                "Possible causes are: no DHCP server is available or the assigned static IP address is already in use." .
                $ipConfigLink
            );
        } else {
            $networkAlert = "js:ipChecked().executed && !ipChecked().success";
            $network = "js: !ipChecked().executed?'CHECKING...':(!ipChecked().success?'NO INTERNET':'OK')";               
            $networkPopover = array( "Network", "js:networkInfoText" );
        }

        $row->addCol( array( 
            'sizes'=>$sizes, 
            'content'=> $this->widget('ButPro', array( 
                            'title' => 'NETWORK', 
                            'text' => $network,
                            'alert' => $networkAlert,
                            'popover' => $networkPopover
                        ), true ) 
        ) );
        if ( $basicInfo->powerMCU ) {
            $popoverTitle = 
                "js: summaryData.power.source() == 3 ? 'Power Source' : ''";
            $popoverContent = "js: summaryData.power.source() == 3 ? " .
                "'Only one power source should be connected. To deactivate " .
                "PoE, turn it off on the network switch.' : ''";
            $row->addCol( array( 
                'sizes'=>$sizes, 
                'content'=> $this->widget('ButPro', array( 
                                'title' => 'POWER SOURCE', 
                                'text' => "js: powerSource",
                                'alert' => 
                                    'js: summaryData.power.source() == 3',
                                'popover' => 
                                    array($popoverTitle, $popoverContent)
                            ), true ) 
            ) );
            $row->addCol( array( 
                'sizes'=>$sizes, 
                'content'=> $this->widget('ButPro', array( 
                                'title' => 'POWER', 
                                'text' => "js: summaryData.power.power() && " .
                                    "summaryData.power.power().toString() + " .
                                    "' W' || 'UNKNOWN'"
                            ), true ) 
            ) );
        }
    $this->endWidget();
$this->endWidget();
$Info = ob_get_contents ( );
ob_end_clean();

$main = $this->beginWidget('BsRow');
if ( $verticalSnapshot ) {
    $main->addCol( array(
        'sizes' => array( 'md' => 6, 'xl' => 8 ),
        'content' => $Info . $Settings
    ));    
    $main->addCol( array(
        'sizes' => array( 'md' => 6, 'xl' => 4 ),
        'content' => $Snapshot
    ));    
} else {
    $main->addCol( array(
        'sizes' => array( 'md' => 12 ),       
        'content' => $Info
    ));
    $main->addCol( array(
        'sizes' => array( 'md' => 6 ),
        'content' => $Settings
    ));    
    $main->addCol( array(
        'sizes' => array( 'md' => 6 ),
        'content' => $Snapshot
    ));    
}
$this->endWidget();

$this->renderPartial('wizard', array( 
    'timeSettings' => $timeSettings,
    'playerConfig' => $playerConfig,
    'screenSettings' => $screenSettings,
    'wizard' => $wizardConfig,
    'user' => $user,
    'manual' => !$wizard
) );

if ($wizard) { 
    $hasLicense = Yii::app()->device->model === 'ikebana' 
        || Yii::app()->branding->hasLicense();
?>
<script>
<?php 
    if (!$hasLicense) { 
?>
function showActivationDialog() {
    spxapi.ui.modalDialog({
        contentHeight: '100%',
        contentWidth: 650,
        title: 'Player Activation',
        body: 
            '<p>No DSOS license is activated on this player. It can be used as-is with ARYA, but one is needed before it can be used with Elementi or a third-party CMS.</p>' +
            '<ul style="line-height: 200%">' + 
                '<li>To use this player with ARYA, click here: <a href="https://arya.spinetix.cloud/setup/' + '<?php echo $this->serial ?>' + '"><strong>ARYA Setup</strong></a></li>' +
                '<li>To use this player with Elementi or a third-party CMS, click here: <a href="https://activate.spinetix.com"><strong>DSOS License Activation</strong></a></li>' +
            '</ul>',
    });
};

$(function() {
    showActivationDialog();
});
<?php 
    } else { 
?>
$(function() {
    yiiWizard.show();
});
<?php 
    } 
?>
</script>
<?php 
}
?>

<script type="text/javascript" >
//<![CDATA[
extendModel( yiiModel );
extendModelFirmware( yiiModel, <?php echo CJavaScript::encode( $configFirmware ); ?> );


yiiModel.firwareInfoTextButton = ko.computed( function() {
   var txt = "<p>" + yiiModel.firwareInfoText() + "</p>";
   var info = yiiModel.firmwareInfo();
<?php if (Yii::app()->user->checkAccess('useControlCenter')) {
   echo "    var link = ".CJavaScript::encode( $fimrwareLink ).";\n";
?>
   if ( info.executed && info.success && info.updates>0 ){
       txt += "<button onclick=\"firmwareUpdateAction()\" class=\"btn btn-default pull-right\">Update Now</button>";
   } 
   if ( !info.success ) {
       txt += link;
   }
<?php } ?>
    return txt;
});

yiiModel.summaryData =  ko.mapping.fromJS( <?php echo CJavaScript::encode( $data );?>);

const MAX_TIME_DIFFERENCE = <?php echo MAX_TIME_DIFFERENCE?>;
yiiModel.timeAlert = ko.computed( function() {
    return Math.abs(yiiModel.summaryData.unixTime() - Date.now() / 1000) > 
        MAX_TIME_DIFFERENCE;
});
yiiModel.storageInfoText = ko.computed( function() {
<?php
$storageData = array(
    array( 'label'=>"Free", 'value' =>  "{free} {unit}" ),
    array( 'label'=>"Used", 'value' =>  "{used} {unit}" ),
    array( 'label'=>"Total", 'value' =>  "{total} {unit}" )
);
echo "    var template = ".CJavaScript::encode( 
    $this->widget('DataTable', array( 'data' => $storageData ), true)
    ) .";\n";
echo "    var link = ".CJavaScript::encode( $storageLink ).";\n";
?>
    if ( yiiModel.summaryData.storage ) {
        return template.replace("{free}", yiiModel.summaryData.storage.free())
                       .replace("{used}", yiiModel.summaryData.storage.used())
                       .replace("{total}", yiiModel.summaryData.storage.tot())
                       .replace(/{unit}/g, yiiModel.summaryData.storage.unit())+
               link;    
   } else {
       return link;
   }
});
yiiModel.cpuInfoText = ko.computed( function() {
<?php
if ( Yii::app()->device->model === 'ikebana' ){
    $cpuData = array(
        array( 'label'=>"CPU Average", 'value' =>  "{cpu}%<br/>ARM: {arm}%, DSP: {dsp}%" ),
        array( 'label'=>"Peak rendering time", 'value' =>  "{time}ms" ),
        array( 'label'=>"Dropped frames", 'value' =>  "{drop}%<br/>FPS: {fps}%, Peak: {peaks}%" )
    );
} else {
    $cpuData = array(
        array( 'label'=>"CPU Average", 'value' =>  "{cpu}%" ),
        array( 'label'=>"Peak rendering time", 'value' =>  "{time}ms" ),
        array( 'label'=>"Dropped frames", 'value' =>  "{drop}%<br/>FPS: {fps}%, Peak: {peaks}%" )
    );
}
echo "    var template = ".CJavaScript::encode( 
    $this->widget('DataTable', array( 'data' => $cpuData ), true)
    ) .";\n";
echo "    var link = ".CJavaScript::encode( $logLink ).";\n";
?>
    if ( yiiModel.summaryData.cpuInfo && yiiModel.summaryData.cpuInfo.usage ) {
        return template.replace("{cpu}", yiiModel.summaryData.cpuInfo.usage.average())
                       .replace("{arm}", yiiModel.summaryData.cpuInfo.usage.arm())
                       .replace("{dsp}", yiiModel.summaryData.cpuInfo.usage.dsp())
                       .replace("{time}", yiiModel.summaryData.cpuInfo.peak())
                       .replace("{drop}", yiiModel.summaryData.cpuInfo.dropFPS.average() + yiiModel.summaryData.cpuInfo.dropPeak.average() )
                       .replace("{fps}", yiiModel.summaryData.cpuInfo.dropFPS.average())
                       .replace("{peaks}", yiiModel.summaryData.cpuInfo.dropPeak.average())+
               link;    
   } else {
       return link;
   }
});
yiiModel.networkInfoText = ko.computed( function() {
<?php
$ipData = array(
    array( 'label'=>"IP", 'value' =>  $basicInfo->getIp() ),
    array( 'label'=>"IPv6", 'value' =>  $basicInfo->getIpv6() ),
    array( 'label'=>"Hostname", 'value' =>  $basicInfo->getHostname() .".local" )
);
echo "    var template = ".CJavaScript::encode( 
    $this->widget('DataTable', array( 'data' => $ipData ), true)
    ) .";\n";
echo "    var link = ".CJavaScript::encode( $ipConfigLink ).";\n";
?>
   if ( !yiiModel.ipChecked().success && yiiModel.ipChecked().reason ) {
        return template + "<p>" + yiiModel.ipChecked().reason + "</p>" + link;    
   } else {
       return template + link;
   }
});
yiiModel.powerSource = ko.computed( function() {
    switch (yiiModel.summaryData.power.source()) {
        case 1:
            return 'PoE';
        case 2:
            return 'USB';
        case 3:
            return 'PoE + USB';
        default:
            return 'UNKNOWN';
    }
});

<?php
if (Yii::app()->user->checkAccess('useControlCenter')) {
?>
const bullets = '\u2022\u2022\u2022\u2022';
yiiModel.pin = ko.observable(bullets);
let pinTimeout = null;
yiiModel.checkPin = () => {
    spxapi.rpc.variable_get('spx:setup:pin', (pin) => {
        yiiModel.pin(pin || 'None');
        if (pinTimeout) clearTimeout(pinTimeout);
        pinTimeout = setTimeout(() => {
            yiiModel.pin(bullets);
            pinTimeout = null;
        }, 30 * 1000);
    });
};
<?php
}
?>

const whiteList = {
    ...$.fn.popover.Constructor.DEFAULTS.whiteList,
    button: ['onclick'],
    div: ['data-bind', 'style', 'title'],
    span: ['data-bind'],
    table: [],
    tbody: [],
    tr: [],
    td: ['style']
};
$(function() {
    function updateTime(){    
        var now = moment();
        var target = moment( now + delta);
        yiiModel.summaryData.time( target.format("D MMM YYYY H:mm:ss") );
        //$('#LocalTime').text( target.format("D MMM YYYY H:mm:ss") );
        setTimeout(updateTime, 1000);
    }
    var now = moment();
    var initTime = moment( yiiModel.summaryData.time(), "D MMM YYYY H:mm:ss");
    var delta = initTime - now;
    var timer = setTimeout(updateTime, 1000);

    yiiModel.checkFirmware( 'base', false, <?php echo CJavaScript::encode(
        $firmwareUpdate->updater->fastNoUpdateCheck() ? $firmwareUpdate->
        getStatus() : null); ?>, true );
    $('[data-toggle="popover"]').popover( {
        html: true,
        container: 'body',
        whiteList
    });
    function updateData(){
        $.ajax( <?php echo CJavaScript::encode($summary);?> ).done( function( response ) {
            ko.mapping.fromJS(response.data, yiiModel.summaryData);
            now = moment();
            initTime = moment( yiiModel.summaryData.time(), "D MMM YYYY H:mm:ss");
            delta = initTime - now;
            clearTimeout(timer);
            timer = setTimeout(updateTime, 1000);
            setTimeout(updateData, 1*60*1000);
        });
    }
    setTimeout(updateData, 1*60*1000);
    
    $('#CockpitMonitor').hide();
    $.ajax({url: <?php echo CJavaScript::encode( $cockpitHost.$cockpitNewPlayer);?>, 
        type: "GET",
        crossDomain: true, 
        xhrFields: { withCredentials: true } })      
     .done(function( data, textStatus, jqXHR ){         
         if ( data.url ){
            $('#CockpitUri').val( data.url );
            $('#CockpitMonitor').show();
            $('#GoSystem').hide();
         }
     });
});
function firmwareUpdateAction( ev ){
    yiiModel.updateStart();    
}

<?php
if ( 0 ) {
    $enroll = Tools::queryEnrollment();
    echo "var enroll = ".CJavaScript::encode( $enroll ) .";\n";    
?>
if ( !enroll['enrolled'] && enroll['enabled']){
    spxapi.ui.message( { 
            type: 'warning', 
            title: "Enrollment",
            sticky: true,
            text: "Player not enrolled, please try loading the page again in a few minutes.<br/>Contact support if the problem persists."
        } );
}
<?php
}
?>
//]]></script>