<?php
/* @var $this ReportingController */
if ($playerConfig->hasMultipleVideoOutputs()) {
    $headers = array('Video output', 'Settings', 'Top', 'Left');

    $table = array();

    $outputNames = $playerConfig->getVideoOutputSelectorList();
    foreach ($playerConfig->getVideoOutputs() as $name => $output) {
        if (($mode = Mode::get($screenSettings->modes, $name))) {
            $mode = $mode->getModeString();
        }

        $table[] = array(
            $outputNames[$name] ?? $name,
            $mode ?? '',
            $output['y'],
            $output['x'],
        );
    }

    echo BsHtml::alert(
        BsHtml::ALERT_COLOR_INFO,
        $formConfig->table(
            $headers, 
            $table, 
            array('sizes' => array( '', '', '', '' ))
        ),
        array('closeText' => false , 'class' => 'table-responsive'),
    );
} else {
    foreach ($screenInfo->monitors as $mon ) {    
        if ( isset( $mon['text'] ) ) {
            $data = array();
            if ( isset( $mon['mode'] ) ) {
                $data[] = array( 'label'=>"Settings", 'value' => $mon['mode'] );
            }
            $data[] = array('label' => 'Status', 'value' => $mon['text']);
            if ( isset( $mon['width'] ) ) {
                $data[] = array( 'label'=>"Display size", 'value' => $mon['width']." x ".$mon['height']." cm" );
                $data[] = array( 'label'=>"Aspect ratio", 'value' => $mon['aspectRatio'] );
            }
            if ( isset( $mon['underscan'] ) ) {
                $data[] = array( 'label'=>"Underscan", 'value' => $mon['underscan'] );
            }
            $info = $this->widget(
                'DataTable',
                array('data' => $data, 'title' => 'Detected Display'),
                true
            );
            echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $info );
        } 
        
    }
}
