<?php
/* @var $this ConfigController */


if ( !isset( $wizard ) )
    $wizard = false;
if ( $wizard ){    
    $options = array(
        'nbBox' => null,
        'labelSize' => 12,
        'inputSize' => 12,
        'formClass' => "",
    );
} else {
    $options = array( 
        'title' => "Display",
        'id' => "Display",
        'button' => "Apply",
        'action' => array ( 'post' => array() )
    );
}

$formConfig = $this->beginWidget('SimpleForm', $options );
    $formConfig->errorSummary( $screenSettings );
    
    if ( $wizard ){        
        echo $formConfig->activeHiddenField(
            $screenSettings,
            "modeSelect",
            array('value' => 'simple')
        ) ."\n" ;        
    } else {
        
        $this->renderPartial('display/info', array(
            'screenInfo' => $screenInfo,
            'playerConfig' => $playerConfig,
            'screenSettings' => $screenSettings,
            'formConfig' => $formConfig,
        ));
        $modes = array( 'simple' => 'Simple' );
        if ( Yii::app()->branding->hasRight('displayAdvanced') ){
            $modes['advanced'] = 'Advanced';
        }
        if ( Yii::app()->branding->hasRight('displayCustom') ){
            $modes['custom'] = 'Custom';
        }
        if ($playerConfig->hasMultipleVideoOutputs()) {
            $modes['multiOutput'] = 'Multi-output';
        }
        if ( count($modes) > 1 ) {
            echo $formConfig->activeDropDownList( $screenSettings, "modeSelect", 
                $modes, array( ), true
            );
        } else {
            echo $formConfig->activeHiddenField($screenSettings, "modeSelect", array(), true ) ."\n" ;
        }
    }
    if ( Yii::app()->branding->product == "DiVA" ){
        $wizard = true; // only simplified mode in DiVA
    }
    echo CHtml::openTag("div", array(
        'data-bind' =>
            $wizard ? "visible: true" : "visible: modeSelect() == 'simple'"
    ));
    
        $vals = array();
        $cur = null;
        $arMap = array();
        
                
        foreach ($screenSettings->getPresets( $wizard ) as $id => $values){            
            if ( is_array($values) ){
                $arMap[$id] = $values[3];
                if ( $cur !== null ){
                    $vals[$cur][$id] = CHtml::encode($values[4]) ." ".CHtml::encode($values[5]);
                } else {
                    $vals[$id] = CHtml::encode($values[4]) ." ".CHtml::encode($values[5]);
                }                
            }else{
                $cur = CHtml::encode($values);                
            }
        }
        echo $formConfig->activeDropDownList( $screenSettings, "simpledisplay", 
                                              $vals, array( ) );
    echo CHtml::closeTag("div") ."\n";
    
    if ( !$wizard ){
        echo CHtml::openTag(
            "div",
            array('data-bind' => "visible: modeSelect() == 'advanced'")
        );
            
            if ( count($screenSettings->screenSelect)>0 ) {
                echo $formConfig->activeDropDownList( $screenSettings, "advancedtype", array(
                    'builtin' => 'Standard modes',
                    'screen' => 'Screen modes',
                ), array(), true );  
                echo CHtml::tag( "div", array(
                        'data-bind' => "visible: advancedtype()==='builtin'"
                    ),
                    $formConfig->activeSelect2($screenSettings, "builtin", 
                                            $screenSettings->builtinSelect, array( ) ) );
                echo CHtml::tag( "div", array(
                        'data-bind' => "visible: advancedtype()==='screen'"
                    ),
                    $formConfig->activeSelect2($screenSettings, "screen", 
                                            $screenSettings->screenSelect, array( ) ) );
            } else {	
                echo CHtml::activeHiddenField($screenSettings, "advancedtype", array( 
                    'value' => 'builtin',
                ) ) ."\n" ;
                echo $formConfig->activeSelect2($screenSettings, "builtin", 
                                                $screenSettings->builtinSelect, array() );
            }
            
            
        echo CHtml::closeTag("div") ."\n";
        
        echo CHtml::openTag(
            "div",
            array('data-bind' => "if: modeSelect() == 'custom'")
        );
            echo $formConfig->activeHiddenField( $screenSettings, "advancedtype", array( 'value'=> false ) );
            echo $formConfig->activeTextField($screenSettings, "custom", array(), true );
        echo CHtml::closeTag("div") ."\n";
        
        echo CHtml::openTag("div", array(
            'data-bind' =>
                "if: modeSelect() == 'advanced' || modeSelect() == 'custom'"
        ));
            echo $formConfig->activeHiddenField( $screenSettings, "simpledisplay", array( 'value'=> "" ) );
            if ( $screenSettings->hasUnderscanSupported() ){
                echo $formConfig->activeCheckBox(
                    $screenSettings,
                    "underscansupp",
                    array(),
                    true
                );
            }
        echo CHtml::closeTag("div") ."\n";
    }
    echo CHtml::openTag("div", array(
        'data-bind' =>
            $wizard ? "visible: true" : "visible: modeSelect() != 'multiOutput'"
    ));
        echo $formConfig->activeDropDownList( $playerConfig, "orientation", $playerConfig->getOrientationsList($wizard) );
        if ( $playerConfig->hasVideoOutputSelector() ) {
            echo $formConfig->activeDropDownList( $playerConfig, "videoOutputSelector", $playerConfig->getVideoOutputSelectorList($wizard) );        
        }
    echo CHtml::closeTag("div") ."\n";

$this->endWidget();
