<?php
class ServerSecurity extends CFormModel {
	
    public $file="/etc/apache2/conf.d/01-spxmanage-defs.conf";
    
    var $level;
    var $secureDAVPortOnly;
    
    public $options = array(
        "allow-insecure" => "Allow insecure HTTP",
        "redirect-insecure"=>"Redirect insecure HTTP to secure HTTP",
        "disable-insecure"=>"Disable insecure HTTP"
    );
    
    public function rules() {
		$res = array(
            array( "level", 'in', 'range' => array("allow-insecure", "redirect-insecure", "disable-insecure", "disable-all") ),
            array( "secureDAVPortOnly", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'level'=>'Server access',
            'secureDAVPortOnly' => "Allow connections to publish server over secure HTTP only"
		);
	}   
    function load() {
        $conf = file_get_contents( $this->file );
        $this->secureDAVPortOnly = $this->isEnabled($conf, "NOSSL_DAV_PORT_ALLOW_REMOTE")?0:1; 

        if ( $this->isEnabled($conf, "NOSSL_LOCALHOST_ONLY") ){
            if ( $this->isEnabled($conf, "SSL_LOCALHOST_ONLY") ){
                $this->level = "disable-all";
            } else {
                $this->level = "disable-insecure";
            }
        } else {
            if ( $this->isEnabled($conf, "NOSSL_REDIRECT") ){
                $this->level = "redirect-insecure";
            } else {
                $this->level = "allow-insecure";
            }
        } 
        if ( $this->level == "disable-all" && count( $this->options ) == 3){
            $this->options["disable-all"] = "Disable insecure and secure HTTP";
        }
    }
    function isEnabled( $conf, $name ){
        return preg_match("/^Define $name$/m", $conf);
    }
    function enable( $conf, $name ){
        if ( !preg_match("/#?Define $name$/m", $conf) ){
            return $conf . "\nDefine $name\n";
        }
        return preg_replace("/^#Define $name$/m","Define $name", $conf);        
    }
    function disable( $conf, $name ){
        return preg_replace("/^Define $name$/m","#Define $name", $conf);        
    }
    function save( $runValidation=true, $attributes=null )
    {
        if( $runValidation && !$this->validate($attributes)){
            return false;
        }
        
        $conf = file_get_contents( $this->file );
        $host = ServerCertificates::getActiveHost();
        $safeData = "";
        if ( $this->secureDAVPortOnly == "1" ) {
            $conf = $this->disable( $conf, "NOSSL_DAV_PORT_ALLOW_REMOTE");
        } else {
            $conf = $this->enable( $conf, "NOSSL_DAV_PORT_ALLOW_REMOTE");
        }

        switch ( $this->level ){
            case "allow-insecure":
                $conf = $this->disable( $conf, "NOSSL_LOCALHOST_ONLY");
                $conf = $this->disable( $conf, "SSL_LOCALHOST_ONLY");
                $conf = $this->disable( $conf, "NOSSL_REDIRECT");
                break;
            case "redirect-insecure":
                $conf = $this->disable( $conf, "NOSSL_LOCALHOST_ONLY") ;
                $conf = $this->disable( $conf, "SSL_LOCALHOST_ONLY") ;
                $conf = $this->enable( $conf, "NOSSL_REDIRECT") ;                
                $safeData = "NOSSL_REDIRECT\n";
                break;
            case "disable-insecure":
                $conf = $this->enable( $conf, "NOSSL_LOCALHOST_ONLY") ;
                $conf = $this->disable( $conf, "SSL_LOCALHOST_ONLY") ;                
                $safeData = "NOSSL_LOCALHOST_ONLY\n";
                break;
            case "disable-all":
                $conf = $this->enable( $conf, "NOSSL_LOCALHOST_ONLY") ;
                $conf = $this->enable( $conf, "SSL_LOCALHOST_ONLY") ;            
                $safeData = "NOSSL_LOCALHOST_ONLY\nSSL_LOCALHOST_ONLY\n";
                break;
        }
        
        if ( filter_var( $host, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6 )){
            $host = "[$host]\n";
        } else if ( filter_var( $host, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 )){
            $host = $host;
        } else if ( preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*\.?$/i", $host) //valid chars check
                    && preg_match("/^.{1,253}$/", $host) //overall length check
                    && preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*\.?$/", $host)){
            $host = $host;
        } else {
            $host = "-";
        }
        
        $safeData .= "SSL_SUBJECT_NAME=$host\n";
        $conf = preg_replace("/^Define SSL_SUBJECT_NAME \S*/m","Define SSL_SUBJECT_NAME $host", $conf);
        
        Tools::save_file( $this->file, $conf );        
        Tools::setSafeModeData( "httpd-opts", $safeData, FALSE);
        
        Tools::addReason( "Server access configuration changed" );
    }
}