<?php

require_once dirname(__FILE__).'/../utils/MainInfo.php';

class ScreenSettings extends CFormModel {
	
    protected $fileName="/etc/default/vidmode";
    protected $configFileDSOS="/etc/spxdispmanager/config.json";

    protected $strings=array(   "RESOLUTION" => 'resolution',
                                "FORCE_VFREQ" => "vfreq",
                                "USE_FIXED_MODEDB" => "fixeddb",
                                "DEFAULT_MON_AR" => "screeenar", 
                                "FIXED_MODE_TYPES" => "type", 
                                "HDMI_UNDERSCAN_IGNORE" => "underscan", 
                                "HDMI_LINK_FORCE_TYPE" => "hdmilink",
                                "CUSTOMMODE" => "custom",
                                "FORCE_AR" => "customforcear",
                                "CONFIGURATOR_VERSION" => "version");
                                
    
    protected $presetsBonsai=array( 't0' => 'TV Screen',
                           'ed' => array("hdmi","720x480","60","16:9","480p","60Hz"),
                           'hd50' => array("hdmi","1280x720","50","16:9","720p","50Hz"),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p","60Hz"),
                           't1' => 'Computer Monitor',
                           'vga' => array("vesa","640x480","60","4:3","VGA","640x480"),
                           'svga' => array("vesa","800x600","60","4:3","SVGA","800x600"),
                           'xga' => array("vesa","1024x768","60","4:3","XGA","1024x768"),
                           't2' => 'Wide Computer Monitor',
                           'wvga' => array("vesa,gtf","768x480","60","16:10","WVGA","768x480"),
                           'wsvga' => array("vesa,gtf","1024x640","60","16:10","WSVGA","1024x640")
                     );
    protected $presetsSakura=array( 't0' => 'TV Screen',
                           'hd50' => array("hdmi","1280x720","50","16:9","720p","50Hz"),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p","60Hz"),
                           
                           'fhd50' => array("hdmi","1920x1080","50","16:9","1080p","50Hz"),
                           'fhd60' => array("hdmi","1920x1080","60","16:9","1080p","60Hz"),
                           
                           't1' => 'Computer Monitor',
                           'vga' => array("vesa","640x480","60","4:3","VGA","640x480"),
                           'xga' => array("vesa","1024x768","60","4:3","XGA","1024x768"),
                           'sxga' => array("vesa","1400x1050","60","4:3","SXGA+","1400x1050"),
                           
                           't2' => 'Wide Computer Monitor',
                           'wxga' => array("vesa","1280x800","60","16:10","WXGA","1280x800"),
                           'wsxga' => array("vesa","1680x1050","60","16:10","WSXGA+","1680x1050")
                     );
    protected $presetsDSOS = array( 't0' => 'TV Screen',
                     'hd50' => array("hdmi","1280x720","50","16:9","720p","50Hz"),
                     'hd60' => array("hdmi","1280x720","60","16:9","720p","60Hz"),
                     
                     'fhd50' => array("hdmi","1920x1080","50","16:9","1080p","50Hz"),
                     'fhd60' => array("hdmi","1920x1080","60","16:9","1080p","60Hz"),

                     'uhd50' => array("hdmi","3840x2160","50","16:9","4K UHD","50Hz (HDMI 2)"),
                     'uhd60' => array("hdmi","3840x2160","60","16:9","4K UHD","60Hz (HDMI 2)"),
                     'uhd25' => array("hdmi","3840x2160","25","16:9","4K UHD","25Hz (HDMI 1.3)"),
                     'uhd30' => array("hdmi","3840x2160","30","16:9","4K UHD","30Hz (HDMI 1.3)"),
                     
                     't1' => 'Computer Monitor',
                     'vga' => array("vesa","640x480","60","4:3","VGA","640x480"),
                     'xga' => array("vesa","1024x768","60","4:3","XGA","1024x768"),
                     'sxga' => array("vesa","1400x1050","60","4:3","SXGA+","1400x1050"),
                     
                     't2' => 'Wide Computer Monitor',
                     'wxga' => array("vesa","1280x800","60","16:10","WXGA","1280x800"),
                     'wsxga' => array("vesa","1680x1050","60","16:10","WSXGA+","1680x1050")
               );
                
    protected $presetsBonsaiWizard=array(                            
						   'hd50' => array("hdmi","1280x720","50","16:9","720p", "50Hz", 'Recommended settings for European and most Asian countries.'),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p", "60Hz", 'Recommended settings for U.S., Canada, Brazil and few other countries.'),
                     );
	protected $presetsSakuraWizard=array( 
                            'eu' => 'European, African and most Asian countries',
                           'fhd50' => array("hdmi","1920x1080","50","16:9","1080p", "50Hz", 'Full HD settings, recommended settings for European and most Asian countries.'),
                           'hd50' => array("hdmi","1280x720","50","16:9","720p", "50Hz", 'Settings for European and most Asian countries.'),
                            'us' => 'U.S., Canada, Brazil, Saudi Arabia and few other countries',
                           'fhd60' => array("hdmi","1920x1080","60","16:9","1080p", "60Hz", 'Full HD settings, recommended settings for U.S., Canada, Brazil and few other countries.'),                        
                           'hd60' => array("hdmi","1280x720","60","16:9","720p", "60Hz", 'Settings for U.S., Canada, Brazil and few other countries.'),                           
                     );
    protected $presetsDSOSWizard=array( 
                        '4k' => '4K UHD settings',
                        'uhd60' => array("hdmi","3840x2160","60","16:9","4K UHD", "60Hz (HDMI 2)", '4K UHD HDMI 2 settings'),                        
                        'uhd30' => array("hdmi","3840x2160","30","16:9","4K UHD", "30Hz (HDMI 1.3)", '4K UHD HDMI 1.3 settings'),                        
                        
                        'eu' => 'European, African and most Asian countries',
                        'fhd50' => array("hdmi","1920x1080","50","16:9","1080p", "50Hz", 'Full HD settings, recommended settings for European and most Asian countries.'),
                           
                        'us' => 'U.S., Canada, Brazil, Saudi Arabia and few other countries',
                        'fhd60' => array("hdmi","1920x1080","60","16:9","1080p", "60Hz", 'Full HD settings, recommended settings for U.S., Canada, Brazil and few other countries.'),                        
                 );
	
	public $builtinSettings=array();
	public $screenSettings=array();
	public $builtinSelect=array();
	public $screenSelect=array();
	

    public $default_mon_ar=array("4:3"=>"4:3","16:9"=>"16:9","16:10"=>"16:10");
    public $hdmilink_type=array("auto" => "Automatic","HDMI"=>"HDMI","DVI"=>"DVI");

    // Variable that can be configured
    public $output;
    public $resolution=null;
    public $vfreq=null;
    
    public $fixeddb=null;
    public $screeenar=null;
    public $type=null;
    public $underscan=null;
    public $hdmilink = 'auto';
    public $custom=null;
    public $version=2;
    
    protected $customforcear="";
    
    public $simpledisplay=false;
	public $advancedtype=false;
	
    protected $error_custom_str = false;

    public $modes = array();

    protected $hasMultipleVideoOutputs = false;

    protected $vidmodName = "/usr/share/vidmode/vid.modes";

    public function hasUnderscanSupported() {
        return (  Yii::app()->device->model == 'Bonsai' || Yii::app()->device->model == 'Sakura' || Yii::app()->device->model == 'ikebana');
    }
    public function getPresets( $wizard = false ) {
        if ( $wizard ){
            if ( Yii::app()->device->model == 'Bonsai' ) 
                return $this->presetsBonsaiWizard;
            else if ( Yii::app()->device->model == 'Sakura' || Yii::app()->device->model == 'ikebana' )
                return $this->presetsSakuraWizard;
            else 
                return $this->presetsDSOSWizard;
        } else {
            if ( Yii::app()->device->model == 'Bonsai' ) 
                return $this->presetsBonsai;
            else if ( Yii::app()->device->model == 'Sakura' || Yii::app()->device->model == 'ikebana' )
                return $this->presetsSakura;
            else 
                return $this->presetsDSOS;
        }
    }
	public function getWizardPresets() {
        return $this->getPresets( true );
    }
    public function rules() {
		return array(
            array('output', 'match', 'on' => 'backup', 'pattern' => '/^card\d+-[-\w]+-\d+$/'),
            array('screeenar', 'in', 'on'=>'backup', 'range'=>$this->default_mon_ar ),
            array('hdmilink', 'in', 'on'=>'display,backup', 'range'=>array("auto","DVI","HDMI"), 'allowEmpty'=>false ),
            
            array('resolution', 'filter', 'on'=>'backup', 'filter'=>array($this,'filterResolution')),
            array('resolution', 'in', 'on'=>'backup', 'range'=>$this->supportedResolution()),
            array('vfreq', 'in', 'on'=>'backup', 'range'=>array("24","25","30","50","60") ),
            array('type', 'in', 'on'=>'backup', 'range'=>array("hdmi","vesa","gtf","vesa,gtf","hdmi,gtf","hdmi,vesa","") ),
            
            array('forcestdmode, underscansupp, advancedtype', 'safe', 'on'=>'display, backup' ),
            array('custom', 'checkCustomConfig', 'on'=>'display,backup' ),
            array('simpledisplay', 'safe', 'on'=>'display' ),
            array('builtin, screen', 'safe', 'on'=>'display' ),
		);
	}

    public function attributeLabels()
	{
		return array(
			'resolution'=>'Resolution',
            'vfreq'=>'Force vertical refresh',
            'forcestdmode'=>'Force standard video modes',
            'type'=>'Restrict video mode to',
            'underscansupp'=>'HDMI display supports underscan',
            'hdmilink'=>'HDMI link type',
            'custom'=>'Custom video mode',
			'modeSelect'=>'Configuration type',
            'simpledisplay'=>'Display settings',
            'advancedtype' => 'Advanced type',
            'builtin' => 'Custom video mode',
            'screen' => 'Custom video mode',
		);
	}
    public function filterResolution($resolution) {
        return $resolution === 'VGA' ? '640x480' : $resolution;
    }
    public function supportedResolution() {
        if (file_exists($this->vidmodName)){
            $vidmod=file_get_contents( $this->vidmodName );
            $vidmodArray=explode("\n",$vidmod);
        } else {
            $vidmodArray = array();
        }
        
        $resolutionAdv = array();
        foreach ($vidmodArray as $str){
            if (preg_match("/=\s*(.*)/",$str,$match)){
                $values=explode(" ",$match[1]);
                if (count($values)>=12){
                    if ($values[10]=='p' 
                        && in_array($values[2], array(24, 25, 30, 50, 60) ) 
                        && !in_array($values[0]."x".$values[1], $resolutionAdv)){
                        $resolutionAdv[ $values[0]."x".$values[1] ]=$values[0]."x".$values[1];	
                    }
                }	
            }
        }
        return $resolutionAdv;
    }
    
    public function getForceStdMode() {
        return $this->fixeddb=='yes';
    }
    public function getModeSelect ( ) {
        if ( $this->hasMultipleVideoOutputs ) {
            return 'multiOutput';
        }

        $ret = 'simple';
        if ( $this->error_custom_str ){
            $ret = 'custom';
        } else if ( $this->simpledisplay==false ) {
			if ( $this->advancedtype )
				$ret = 'advanced';
			else if ( $this->custom )
                $ret = 'custom';
        
        } 
        if (
            $ret == 'custom' &&
            !Yii::app()->branding->hasRight('displayCustom')
        ){
            $ret = 'simple';
        }
        if (
            $ret == 'advanced' &&
            !Yii::app()->branding->hasRight('displayAdvanced')
        ){
            $ret = 'simple';
        }
        return $ret;
    }
    public function setForceStdMode( $forced ) {
        if ( $forced )
            $this->fixeddb='yes';
        else
            $this->fixeddb='';
    }
    
    public function getUnderscanSupp() {
        return $this->underscan=='no';
    }
    
    public function setUnderscanSupp( $forced ) {
        if ( $forced )
            $this->underscan='no';
        else
            $this->underscan='';
    }
    
    public function getCustomForceAR() {
        return $this->customforcear;
    }

    public function getBuiltin() {
        return $this->custom;
    }

    public function setBuiltin($builtin) {
        if ($this->advancedtype === 'builtin') {
            $this->custom = $builtin;
        }
    }

    public function getScreen() {
        return $this->custom;
    }

    public function setScreen($screen) {
        if ($this->advancedtype === 'screen') {
            $this->custom = $screen;
        }
    }

    public function checkCustomConfig( $attribute, $params ) {
         if ( preg_match('/[^-0-9a-zA-Z+ :.]/', $this->$attribute) ) {
            $this->addError($attribute,"String contains non-ASCII chars.");
            $this->error_custom_str = true;
            return;
         }
         if ( $this->$attribute!="" ) {
            $cnt = explode(" ", $this->$attribute);

            if ( count($cnt)<5 || ( count($cnt)<11 && $cnt[4]!='p' ) || ( count($cnt)>=11 && $cnt[10]!='p' ) ){
                $this->addError($attribute,"Only progressive modes supported.");
                $this->error_custom_str = true;
            }
         }
    }
	function dbstr2array( $str ) {
		$res = array();
		if (preg_match("/(\S*)\s*=\s*(.*\s+p)\s+(\S+)/",$str,$match)){
			$desc = $match[1];
			$values=explode(" ",$match[2]);
			if ( count($values)>=11 ) {
				// only progresiye settings
				$res['hz'] = intval($values[2]);
				$res['resolution'] = $values[0]."x".$values[1];
				$res['width'] = intval($values[0]);
				$res['height'] = intval($values[1]);
				$res['ar'] = $match[3];
				$res['pcf'] =  $res['hz'] * ( $res['width'] + intval($values[3]) + intval($values[4]) + intval($values[7]) ) * ( $res['height'] + intval($values[5]) + intval($values[6]) + intval($values[7]) ) / 1000000;
				$res['settings'] = $match[2];				
				return $res;
			}
			return false;
		}
		return false;
	}
    function buildList() {
        
        if (file_exists($this->vidmodName)){
            $vidmod=file_get_contents($this->vidmodName );
            $builtIn = explode("\n",$vidmod);
        } else {
            $builtIn = array();
        }
        if (file_exists( ScreenInfoBasics::sysfs_vout_device() . "vid_modedb" )){
            $vidmod = @file_get_contents(ScreenInfoBasics::sysfs_vout_device() . "vid_modedb");
            $screen = explode("\n",$vidmod);
        } else {
            $screen = array();
        }
		
		
		//new stuff
		$this->builtinSettings=array();
		foreach ($builtIn as $str){
			$res = $this->dbstr2array( $str );
			if ( $res!==false && $res['hz']<=60 ) {
				$this->builtinSettings[ ] = $res;
				$this->builtinSelect[$res['settings']]=$res['resolution'].'@'.$res['hz'].'Hz';
			}
		}
		natsort( $this->builtinSelect );
		$this->screenSettings=array();
		foreach ($screen as $str){
			$res = $this->dbstr2array( $str );
			if ( $res!==false && $res['hz']<=60 ) {
				$this->screenSettings[ ] = $res;
				$v = $res['resolution'].'@'.$res['hz'].'Hz';
				//if ( !array_key_exists ( $res['settings'], $this->builtinSelect ) )
				$this->screenSelect[$res['settings']] = $res['resolution'].'@'.$res['hz'].'Hz';
			}
		}
		natsort( $this->screenSelect );
		
    }
    public function loadSetupJSON( $json ) {
        $this->modes = array();
        
        $config = json_decode($json, true);
        if ( !isset($config["displays"]) ) return;
        if ( count( $config["displays"] ) === 0 ){
            // default value....
            $mode = new Mode();
            $mode->resolution = "1920x1080";
            $mode->vfreq = 60;
            $mode->custom = "";
            $mode->fixeddb = 'yes';
            $this->modes['default'] = $mode;
            return;
        } 
        foreach ($config["displays"] as $display) {
            $output = isset($display['output']) ? $display['output'] : 'default';
            if (isset($this->modes[$output])) {
                continue;
            }
            
            if ( !isset($display["mode"]) ) continue;
            
            $modeParameters = $display["mode"];
            if ( !isset($modeParameters["type"]) ) continue;
            
            if ( $modeParameters["type"] === "standard" ){
                if ( !isset($modeParameters["params"]) ) continue;
                $params = $modeParameters["params"];
                if ( !isset($params["width"]) || !isset($params["height"]) ) continue;
                $mode = new Mode();
                $mode->resolution = $params["width"] . "x" . $params["height"];
                if ( isset($params["vrefresh"]) ){
                    $mode->vfreq = $params["vrefresh"];
                } else {
                    $mode->vfreq = 60;
                }
                if ( isset($params["ar"]) ){
                    $mode->customforcear = $params["ar"];
                } 
                $mode->custom = "";
                $mode->fixeddb = 'yes';
            } else if ( $modeParameters["type"] === "custom" ){
                if ( !isset($modeParameters["modeline"]) ) continue;
                $tokens = explode("=", $modeParameters["modeline"]);
                $timings = explode(" ", end($tokens));
                $mode = new Mode();
                $mode->resolution = trim($timings[0]) . "x" . trim($timings[1]);
                $mode->vfreq = intval($timings[2]);
                if (count($timings) >= 12)
                    $mode->customforcear = trim($timings[11]);
                $mode->custom = $modeParameters["modeline"];
            } else if ( $modeParameters["type"] === "cvt" || $modeParameters["type"] === "cvt-R" ){
                if ( !isset($modeParameters["params"]) ) continue;
                $params = $modeParameters["params"];
                $mode = new Mode();
                $mode->resolution = $params["width"] . "x" . $params["height"];
                $mode->vfreq = $params["vrefresh"];
                $mode->custom = $params["width"] . " " . $params["height"] . " " . $params["vrefresh"] . " " . $modeParameters["type"] . " " . $params["scan"];
                if ( isset($params["ar"]) ){
                    $mode->customforcear = $params["ar"];
                    $mode->custom .= " " . $params["ar"];
                } 
            } else {
                continue;
            }

            $this->modes[$output] = $mode;
        }
    }
    public function createJSON( ) {      
        
        Yii::log("createJSON( )", 'debug', 'spx.display');
        if ( !$this->prepareSavedData() ) return false;

        $displays = array();
        foreach ($this->modes as $output => $mode) {
            $display = array();
            if ($output !== 'default') {
                $display['output'] = $output;
            }
            $modeParameters = array();
            if ( $mode->custom === null || $mode->custom === "" ||  $mode->advancedtype == "builtin" ){
                $modeParameters["type"] = "standard";
                $dim = explode( "x", $mode->resolution);
                $modeParameters["params"] = array(
                    "width" => intval($dim[0], 10),
                    "height" => intval($dim[1], 10),
                    "vrefresh" => intval($mode->vfreq, 10)
                );
                /* // there is nothing in the UI to input this
                if ( $mode->customforcear != "" ) {
                    $modeParameters["params"]["ar"] = $mode->customforcear;
                }
                */
            } else {
                $data = explode(" ", $mode->custom );
                
                if ( ( count( $data ) == 5 || count( $data ) == 6 ) ) {
                    if ( $data[3] !== "cvt" && $data[3] !== "cvt-R") return false;
                    $modeParameters["params"] = array(
                        "width" => intval($data[0], 10),
                        "height" => intval($data[1], 10),
                        "vrefresh" => intval($data[2], 10),
                        "scan" => $data[4]
                    );
                    if ( count($data) == 6 ) {
                        $modeParameters["params"]["ar"] = $data[5];
                    }
                    
                    $modeParameters["type"] =  $data[3];
                } else {
                    $modeParameters["type"] =  "custom";
                    $modeParameters["modeline"] = $mode->custom;
                }
            }
            $display['mode'] = $modeParameters;
            $displays[] = $display;
        }
        $config = array( "displays" => $displays );
        if ($oldJson = file_get_contents( $this->configFileDSOS )) {
            $oldConfig = json_decode($oldJson, true);
            if ($config == $oldConfig) {
                Yii::log("not modified", 'debug', 'spx.display');
                return true;
            }
        }
        $json = json_encode($config, JSON_PRETTY_PRINT) ."\n";
        Yii::log($config, 'debug', 'spx.display');
        return $json;
    }
    public function loadSetup( $file, $modeOnly = false ) {
        $this->modes = array();
        
        if ( !file_exists( $file ) ) return;
        $config=file_get_contents( $file );
        $mode = new Mode();
        foreach ($this->strings as $name=>$var){
            if ($count = preg_match_all("/^\s*$name=(.*)/m",$config,$matches, PREG_SET_ORDER)){
                if ( $name=='CUSTOMMODE' ) 
                    $value=substr($matches[$count-1][1],1,-1);
                else if ( $name=='HDMI_LINK_FORCE_TYPE' && $matches[$count-1][1]=="NONE" )
                    $value= 'auto';
                else
                    $value=$matches[$count-1][1];
                
            } else {
                if ( $name=='HDMI_LINK_FORCE_TYPE' )
                    $value= 'auto';
                else
                    $value="";
            }
            if (property_exists($mode, $var)) {
                $mode->$var = $value;
            } elseif (!$modeOnly) {
                $this->$var = $value;
            }
        }
        if ( $mode->resolution === 'VGA' ) $mode->resolution = '640x480';
        if ( $mode->customforcear!="" ) {
            if ( $mode->custom!="" )
                $mode->custom .= " ".$mode->customforcear;
            $mode->customforcear = "";
        }

        $this->modes['default'] = $mode;
    }

	public function checkAdvanced( &$mode ) {
		Yii::log("checkAdvanced( )", 'trace', 'spx.display');
		$newtype = false;
		
        if ( $mode->custom=="" ) {
		    foreach ($this->builtinSettings as $idx => $val){
                if ( $mode->resolution==$val['resolution'] && $mode->vfreq==$val['hz'] ) {
                    // we got a buil-in settings 
                    $newtype = "builtin";
                    $mode->fixeddb = 'yes';
                    if (!$mode->simpledisplay) {
                        $mode->type="";
                    }
                    $mode->custom=$val['settings'];
                    if ($this->screeenar === null) {
                        $this->screeenar = '';
                    }
                }
            }
        }
		if ( $newtype===false && $mode->custom!="") {
			foreach ($this->screenSettings as $idx => $val){
                if ( $mode->custom==$val['settings']){
                    // we got a screen based settings 
                    $newtype = "screen";
                }
            }
		}
		
		$mode->advancedtype = $newtype;
	}
    public function checkPresets( &$mode ) {
        Yii::log("checkPresets( )", 'trace', 'spx.display');
        $mode->simpledisplay = false;
        if ($mode->advancedtype === 'builtin') {
            $mode->custom = '';
        }
		
        if ($mode->custom=="" && ($this->underscan === null || $this->underscan === 'no')) {
            foreach ($this->presets as $id => $val){
                if ( $mode->resolution==$val[1] && $mode->vfreq==$val[2]){
                    // we got a preset 
                    $mode->fixeddb = 'yes';
                    $mode->type = $val[0];
                    $mode->simpledisplay = $id;
                    $this->screeenar = $val[3];
                    $this->underscan = "no";
                }
            }
        }
		$this->checkAdvanced( $mode );
		
	}
    public function load($playerConfig = null) {
        if (Yii::app()->device->model !== 'ikebana'){
            $json = file_get_contents( $this->configFileDSOS );
            $this->loadSetupJSON( $json );            
        } else {
            $this->loadSetup( $this->fileName );
        }
		
		$this->buildList();
		
        foreach ($this->modes as &$mode) {
            $this->checkPresets($mode);
        }

        if ($this->scenario === 'display') {
            $this->hasMultipleVideoOutputs = $playerConfig->hasMultipleVideoOutputs();
            $this->getMode($playerConfig->getVideoOutputName());
        }
    }
    
    public function save() {
        Yii::log("save( )", 'debug', 'spx.display');
        if (Yii::app()->device->model !== 'ikebana'){
            $json = $this->createJSON();
            if ( $json === false ) return false; // error
            if ( $json === true ) return true; // nothing to do
            
            $reboot = Tools::save_file($this->configFileDSOS, $json);
        } else {
            $file = $this->createFile();        
            if ( $file===false ) return false; // error
            if ( $file===true ) return true; // nothing to do
            $reboot = Tools::save_file($this->fileName, $file);
        }
        
        
        if ( $reboot ) {
            Tools::addReason("display config change");
        }
        return true;
    }
    
    public function check() {
        Yii::log("check( )", 'debug', 'spx.display');
        
        if (Yii::app()->device->model !== 'ikebana'){
            // no check for the moment
            return true;
        } else {
            $file = $this->createFile();
        }
        if ( $file===false ) return false; // error
        if ( $file===true ) return true; // nothing to do
        
        Tools::save_file($this->fileName.".tmp", $file);
        $output=array();
        exec("/etc/init.d/vidmode probe " . escapeshellarg("{$this->fileName}.tmp"), $output, $ret);
        
        $results = new ScreenInfo;
        if (count($output)>0 && $ret == 0){
            
            unlink($this->fileName.".tmp");
            
            $sets=explode ("=",$output[1]);
            if ( count($sets)==2 )
                $vals=explode (" ",trim($sets[1]));
            else
                $vals=explode (" ",trim($sets[0]));
            if ( !is_numeric( $vals[3] ) )
                $arp = 5;
            else
                $arp = 11;
            if ($vals[$arp]=="0:0") $vals[$arp]="[auto]";
            if ($vals[$arp]=="x:x") $vals[$arp]="[unknown]";
            $results->resolution = htmlspecialchars($vals[0])."x".htmlspecialchars($vals[1]);
            $results->refresh = htmlspecialchars($vals[2]);
            $results->aspect = htmlspecialchars($vals[$arp]);
        } else {
            if ( empty($this->custom) ) {
                if ( $this->scenario == "backup" ){
                    $this->addError('display-video-mode',"The selected settings do not result in a video mode supported by the player." );
                } else {
                    $this->addError('resolution',"The selected settings do not result in a video mode supported by the player." );
                }
            } else {                
                $this->addError('custom',"The selected settings do not result in a video mode supported by the player." );
                $this->error_custom_str = true;
            }
            return false;
        }
        return $results;
        
    }
    
    public function prepareSavedData(  ) {
        $this->buildList();

        if ($this->scenario === 'display') {
            if ( $this->simpledisplay!==false && isset($this->presets[$this->simpledisplay]) ) {
                $val = $this->presets[$this->simpledisplay];
                
                $this->resolution = $val[1];
                $this->vfreq = $val[2];
                $this->underscan = "no";
                $this->custom = '';
            } else {
                foreach ($this->builtinSettings as $idx => $val){                
                    Yii::log("Checking [$idx]: '".$this->custom ."' == '".$val['settings']."'", 'trace', 'spx.display');
                    if ( $this->custom==$val['settings'] ) {
                        Yii::log("Preset: ".print_r( $val, true), 'trace', 'spx.display');
                        // we got a buil-in settings 
                        $this->resolution=$val['resolution']; 
                        $this->vfreq=$val['hz'];
                        $this->screeenar = '';
                        $this->custom = '';
                    }
                }
            }

            $this->modes = array();
            $this->setMode();
        }

        foreach ($this->modes as &$mode) {
            $this->checkPresets( $mode );
            if ( $mode->resolution!==null && !$mode->simpledisplay && !Yii::app()->branding->hasRight('displayAdvanced') ){
                $this->addError('resolution',"Only preset resolutions are supported");
                return false;
            }
            
            if ( $mode->custom!==null && !$mode->simpledisplay && !$mode->advancedtype && !Yii::app()->branding->hasRight('displayCustom') ){
                $this->addError('resolution',"Custom resolutions not supported");
                return false;
            }
        }

        return true;
    }
    public function createFile(  ) {
        Yii::log("createFile( )", 'debug', 'spx.display');
        if ( !$this->prepareSavedData() ) return false;
		
        // load the config file
        if ( !file_exists( $this->fileName ) ) {
            $this->addError('file',"Failed reading the screen config file."." Please try again, reset the device to factory default or contact ".Yii::app()->branding->email);
            return false;
        }
        $config=file_get_contents( $this->fileName );
        $modified=false;

        $this->getMode();
        
        if ( $this->custom===null )
            $this->custom = ""; // make sure that the custom mode are removed if they are not set to a specific value.
            
        
        foreach ($this->strings as $name => $var){
            
            $found=false;
                $val = $this->$var;
            if ( $name=='HDMI_LINK_FORCE_TYPE' && $val=="auto" )
                $val = 'NONE';
            if ( $val===null ) continue; // this has not beein modified, don;t touch
			if ($name=='CUSTOMMODE' && $this->advancedtype == "builtin" ) 
				$val = ""; // dont save teh custom mode when using built-in settings
            if ($name=='CUSTOMMODE' && $val!="" ){
		        $cnt = explode(" ", $val );
                if ( count($cnt)==5 || count($cnt)==11 )
                    $this->customforcear == "";
                if ( count($cnt)==6 ) {
                    $this->customforcear = $cnt[5];
                    $val = substr($val, 0, -strlen($this->customforcear)-1);
                }
                if ( count($cnt)==12 ){
                    $this->customforcear = $cnt[11];
                    $val = substr($val, 0, -strlen($this->customforcear)-1);
                }
                if ( $this->customforcear!="4:3" && $this->customforcear!="16:9" && $this->customforcear!="16:10" )
                    $this->customforcear = "";
                $val = escapeshellarg($val);
            }
            if ($count = preg_match_all("/^\s*$name=(.*)/m", $config, $matches, PREG_SET_ORDER)) {
                $previous=$matches[$count-1][1];
                $found=true;	
            } else if (preg_match("/^\s*#+\s*$name=/m",$config)) {
                $previous="";
                $found=true;	
            } else {
                $previous="";
            }
            
            if ( $previous!=$val ){
                if ($found) {
                    if ($val=="")
                        $config=preg_replace("/^\s*#*$name=.*/m","#$name=",$config);
                    else
                        $config=preg_replace("/^\s*#*$name=.*/m","$name=$val",$config);
                }else {
                    if ($val=="")
                        $config.="\n#$name=$val\n";
                    else
                        $config.="\n$name=$val\n";
                }
                $modified=true;
            }
        }
        
        if ( !$modified ){
            Yii::log("not modified", 'debug', 'spx.display');
            return true;
        }
        Yii::log($config, 'debug', 'spx.display');
        return $config;
        
    }

    public function resetMode() {
        if (Yii::app()->device->model !== 'ikebana') {
            $this->loadSetupJSON(file_get_contents(self::getDefaultFileName($this->configFileDSOS)));
        } else {
            $this->loadSetup(self::getDefaultFileName($this->fileName), true);
        }
    }

    protected function afterValidate() {
        if ($this->scenario === 'backup') {
            if ($this->resolution || $this->custom) {
                $this->setMode($this->output ? $this->output : 'default');

                $this->output = null;
                $this->resolution = null;
                $this->vfreq = null;
                $this->fixeddb = null;
                $this->type = null;
                $this->custom = null;
            }
        }

        parent::afterValidate();
    }

    protected function getMode($output = 'default') {
        if ($mode = Mode::get($this->modes, $output)) {
            foreach ($mode as $key => $value) {
                $this->$key = $value;
            };
        }
    }

    protected function setMode($output = 'default') {
        $mode = new Mode();
        foreach ($mode as $key => &$value) {
            $value = $this->$key;
        }
        $this->modes[$output] = $mode;
    }

    protected static function getDefaultFileName($baseName) {
            return "${baseName}.spxsave";
    }
}
