<?php

require_once dirname(__FILE__).'/../utils/MainInfo.php';

class ScreenInfo extends CModel {
	
    var $resolution;
    var $refresh;
    var $aspect;
    var $monitors;
    var $powersave;
    var $powersaveSupported;
    var $cecSupported = true;
    var $settingsStr;
    
    public function attributeNames() {
        return array("resolution", "refresh", "aspect", "monitors" );
    }
    public function safeAttributes() {
        return array();
    }
    public function load() {
        $info = new ScreenInfoBasics();
        $info->load();
        $this->monitors = $info->monitors;

        if( $info->resolution !== "unknown" ){
            $mode = new Mode();
            $mode->resolution = $info->resolution;
            $mode->vfreq = $info->refresh;
            $mode->customforcear = $info->aspect;
            $modes = array('default' => $mode);
            $this->powersave = $info->powersave; 
        } else {
            // using the settings until we have better info.
            $setting = new ScreenSettings();
            $setting->load();
            $modes = $setting->modes;
            $this->powersave = false; 
        }
        $this->setRendererSettings($modes);
        
        $this->powersaveSupported = false;
        foreach ( $this->monitors as &$mon ){
            if (($mode = Mode::get($modes, $mon['id']))) {
                $mon['mode'] = $mode->getModeString();
            }
            if ( count( $mon ) > 1 && isset($mon['powered']) ) {
                $monTxtSwitch = array( 'on' => 'ON', 'off' => 'OFF', 'unknown' => 'CONNECTED' );
                $mon['text'] = $monTxtSwitch[$mon['powered']];
                $mon['alert'] = $mon['powered'] === 'off';
                if ( isset($mon['pm_supported']) && $mon['pm_supported'] ){
                    $this->powersaveSupported = true;
                } else if ( isset($mon['cec_capable']) && !$mon['cec_capable'] ){
                    $this->cecSupported = false;
                }
            } else {
                $this->powersaveSupported = true;
                $mon['text'] = "NOT FOUND";
                $mon['alert'] = true;
            }
        }
        if ( count($this->monitors) === 0 ){
            $this->powersaveSupported = true;
            $this->monitors[0] = array( 'text' => "NOT FOUND", 'alert' => true);
        } else if ( count($this->monitors) > 1 ) {
            // active monitor should be the first one
            $config = new PlayerConfig;
            if ( $config->hasVideoOutputSelector() && !$config->hasMultipleVideoOutputs() ) {
                $selected = $config->getVideoOutputSelector();
                $found = null;
                
                foreach ( $this->monitors as $idx => $monitor ){
                    if ( $monitor['name'] === $selected ) {                        
                        $found = $idx;
                    }
                }
                
                if ( $found ){
                    $new_value = $this->monitors[$found];                    
                    unset($this->monitors[$found]);
                    array_unshift($this->monitors, $new_value);
                }            
            }
        }
    }

    private function setRendererSettings($modes)
    {
        $config = new PlayerConfig();
        $outputs = $config->getVideoOutputs();
        if ($outputs) {
            $region = new Region();
            $refresh = 0;
            foreach($outputs as $name => $output) {
                if (!($mode = Mode::get($modes, $name))) {
                    syslog(LOG_ERR, 'No mode configured for output ' . $name);
                    return;
                }
                $region->merge(PlayerConfig::getVideoOutputRegion($output, $mode));
                if ($mode->vfreq > $refresh) {
                    $refresh = $mode->vfreq;
                }
            }
            $this->resolution = $region->width() . 'x' . $region->height();
            $this->refresh = $refresh;
            $this->aspect = count($outputs) === 1 ? Mode::get($modes, array_key_first($outputs))->customforcear : '';
        } else {
            if (isset($modes['default'])) {
                $this->resolution = $modes['default']->resolution;
                $this->refresh = $modes['default']->vfreq;
                $this->aspect = $modes['default']->customforcear;
            }
        }
        $this->settingsStr = Mode::stringify($this->resolution, $this->refresh, $this->aspect);
    }
}
