<?php

class SSLConfig extends CFormModel {
	
    static $sslfolder = "/etc/pki/spxmanage/certs/";
    static $certExt = ".crt";
    
	var $uploadedfile;
    var $target;
	
    private $exe;
    public function init()
	{
        parent::init();
        
        $this->exe = "openssl";
        if ( PHP_OS == "WINNT" && file_exists( "c:\OpenSSL-Win32\bin\openssl.exe" ) ) {
            $this->exe = "c:\OpenSSL-Win32\bin\openssl";
        }
	}
	public function rules() {
		$res = array(
            array( 'uploadedfile', 'file', 'types'=>'pem,crt,cer', 'on'=>'upload' ),
            array( 'target', 'validateTarget', 'on'=>'delete,dump' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
			'target'=>'Selected Certificate',
            'uploadedfile'=>'Add Certificates',
		);
	}
    public function validateTarget( ){
        if ( !preg_match('/^[^\.]*'.self::$certExt.'$/', $this->target ) ){
            $this->addError('target', 'Target is not valid');
			return false;
		}
		$file = self::$sslfolder . $this->target;
		if ( !file_exists( $file ) ){
            $this->addError('target', 'Certificate not found');
			return false;
		}
    }
	static function dec2hex($str)
    {
        $hex = array('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
        // Result value
        $hexval = '';
        // The quotient of each division operation
        $quotient = $str;
        $divisor = $str;
        // The ending condition
        $flag = true;
        while($flag)
        {
            $len = strlen($divisor);
            $pos = 1;
            $quotient = 0;
            // Take the first two digits as temp divisor and advance by 1 each iteration
            $div = substr($divisor, 0, 2);
            $remainder = $div[0];
            while($pos < $len)
            {
                // Calculate the next div
                $div = $remainder == 0 ? $divisor[$pos] : $remainder.$divisor[$pos];
                $remainder = $div % 16;
                $quotient = $quotient.floor($div/16);
                $pos++;
            }
            // Recast the divisor as string to make the $divisor[$pos] work
            $quotient = self::trim_left_zeros($quotient);
            $divisor = "$quotient";
            $hexval = $hex[$remainder].$hexval;
            // If the divisor is smaller than 15 then end the iteration
            if (strlen($divisor)<=2)
            {
                if ($divisor<15)
                {
                    $flag = false;
                }
            }
        }
        $hexval = $hex[$quotient].$hexval;
        $hexval = self::trim_left_zeros($hexval);
        
        // Pad zeros
        if ( strlen($hexval) % 2 == 1 )
            $hexval = "0" . $hexval;
            
        return $hexval;
    }
    // Trim the zeros at the left of a number
    static function trim_left_zeros($str)
    {
        $str = ltrim($str, '0');
        if (empty($str))
        {
            $str = '0';
        }
        return $str;
    }  
    static function certificateInfo( $cert ){
        $data = openssl_x509_parse( $cert );
        
        if ( isset($data['subject']) ) {
            if ( isset($data['subject']['C']) )
                $f['country'] = $data['subject']['C'];
            else
                $f['country'] = "";
            if ( isset($data['subject']['O']) )
                $f['organization'] = $data['subject']['O'];
            elseif ( isset($data['subject']['CN']) )
                $f['organization'] = $data['subject']['CN'];
            else
                $f['organization'] = "";
            $f['name'] = $data['subject']['CN'];
        } else {
            $f['name'] = "unknown";
        }
        $s = $data['serialNumber'];
        if ( substr( $s, 0, 2 ) == "0x" ) {
        	$s = substr( $s, 2 );
        } else {
        	$s = self::dec2hex( $s );
        }
        $f['serial'] = implode( ":", str_split($s,2) );
        $f['validTo'] = date( DATE_RFC1123, $data['validTo_time_t'] );
        $f['validFrom'] = date( DATE_RFC1123, $data['validFrom_time_t'] );
        if ( isset($data['extensions']) && isset($data['extensions']['subjectAltName']) ) {
            $allNames = array( $f['name'] );
            $alt = explode( ",", $data['extensions']['subjectAltName'] );
            foreach ($alt as $a){
                $name = explode( ":", $a, 2);
                if (count( $name ) == 2 && !in_array($name[1], $allNames)){
                    $allNames[] = $name[1];
                }
                $f['allNames'] = join(", ", $allNames);
            }
        } else {
            $f['allNames'] = $f['name'];
        }
        
        $f['certificate'] = $cert;
        return $f;
    }
    static function certificateFileInfo( $file, $allInfo = true ){
        $exe = "openssl";
        if ( PHP_OS == "WINNT" && file_exists( "c:\OpenSSL-Win32\bin\openssl.exe" ) ) {
            $exe = "c:\OpenSSL-Win32\bin\openssl";
        }
        $f = array();
        if ( $allInfo ) {
            $cert = file_get_contents( self::$sslfolder . $file );
            $f = self::certificateInfo( $cert );
            $f['uploaded'] = !is_link(  self::$sslfolder . $file );
            $output = array();
            $dest = self::$sslfolder . $file;
            exec(escapeshellarg($exe) . " x509 -in device.crt -text -noout -certopt ext_error -in " . escapeshellarg($dest), $output, $ret);
            $f['text'] = implode( "\n",$output );
        }
        $f['filename'] = $file;        
        return $f;
    }
	function getFileList( $allInfo=true ) {
		$filelist=array( );
		if ( !file_exists(self::$sslfolder ) )
            return $filelist;
		$filelist1=scandir(self::$sslfolder);
		
		foreach ($filelist1 as $file){
			if ($file=="." || $file==".." || substr($file, -4)!=self::$certExt) continue;			
            if ( $allInfo || !is_link( self::$sslfolder. $file ) ){
                $filelist[] = self::certificateFileInfo( $file, $allInfo );
            }
		}
		return $filelist;
	}
	function backupCertificate( $target=null ) {
        if ( $target!== null ){
            $this->target = $target;
        }
        if ( !$this->validate() ){
            return false;
        }          
        $file = self::$sslfolder . $this->target;
		return file_get_contents( $file );
	}
    function dump( $target=null  ) {
        
		$data = $this->backupCertificate( $target );
        if ( $data === false ){
            return false;
        }
        $name = rawurlencode($this->target);
        header("Content-type: application/x-x509-user-cert");
        header('Content-Disposition: attachment; filename=\'$name\'; filename*=utf-8\'\''.$name);
        
        echo $data;
        return true;
	}
	function restoreCertificate( $cert ) {
	
		// Check that this is an X.509 certificate
		if ( !preg_match("/^-----BEGIN (X509 |TRUSTED |)CERTIFICATE-----/", $cert ) ) {
			$this->addError('uploadedfile', 'Only X509 certificates are supported');
			return;
		}
		$name =  uniqid("Cert_") .  self::$certExt;
		$dest = self::$sslfolder. $name;
		
		file_put_contents( $dest, $cert );
		
		$this->writeCertificate( $name, true );
	}
	function clearCertificates( ) {
        $this->scenario = 'delete';
        
		$list = $this->getFileList( false );
        
		foreach ($list as $file){
            $this->target = $file['filename'];
			$this->delete( );
        }
	}
	
	function saveCertificate( $file ) {

		// Check that this is an X.509 certificate
		$cert = file_get_contents( $file->tempName );
		
		// Check that this is an X.509 certificate
		if ( !preg_match("/^-----BEGIN (X509 |TRUSTED |)CERTIFICATE-----/", $cert ) ) {
			$this->addError('uploadedfile', 'Only X509 certificates are supported');
			return null;
		}
		
		// save the file
		$name =  uniqid("Cert_") . self::$certExt;
		$dest = self::$sslfolder. $name;
		if ( !$file->saveAs( $dest ) ) {
            $this->addError('uploadedfile', 'Saving certificate failed');
			return null;
		}
		
		if ( !$this->writeCertificate( $name ) )
            return null;
		
        return self::certificateFileInfo( $name );
	}
	
	function writeCertificate( $name, $ignoreDuplicates=false ) {
			
		$dest = self::$sslfolder. $name;
        
        exec(escapeshellarg($this->exe) . " pkcs12 -export -passout pass: -out /dev/null -nokeys -in " . escapeshellarg($dest), $output, $ret);
        if ( $ret!=0 ) {
			// something wrong with the certificate
			$this->addError('uploadedfile', 'Certificate not valid');
			unlink( $dest );
			return false;
		}
            
		// Recover the subject hash and certificate fingerprint 
		exec(escapeshellarg($this->exe) . " x509 -noout -hash -fingerprint -in " . escapeshellarg($dest), $output, $ret);
		if ( $ret!=0 ) {
			// something wrong
			$this->addError('uploadedfile', 'Certificate not valid');
			unlink( $dest );
			return false;
		}
		
		$md5 = $output[1];
        
		$files = scandir( self::$sslfolder );        
        foreach ($files as $file) {
            if ( $file == $name || substr($file, -4) != self::$certExt || substr($file, 0, 5) != "Cert_"){
                continue;
            }
            $output2 = array();
            //throw new Exception( "$this->exe x509 -noout -hash -fingerprint -in ".self::$sslfolder.$file );
			exec(escapeshellarg($this->exe) . " x509 -noout -hash -fingerprint -in " . escapeshellarg(self::$sslfolder.$file), $output2, $ret);            
			if ( $output2[1]==$md5 ){
				// this is the same certificate
				if ( !$ignoreDuplicates ){
					$this->addError('uploadedfile', 'Certificate already uploaded');
                }
				unlink( $dest );
				return false;
			} 
		}
		
        exec('sync');        
        exec('update-ca-certificates -f');
        exec('sync');

		Tools::addReason("update https certificate");
        
		return true;
	}
	function delete(  ) {
		if ( !$this->validate() ){
            return false;
        }		
		
		$file = self::$sslfolder . $this->target;
		
		if ( is_link($file) ) {
            $this->addError('target', 'Cannot remove built-in self-signed certificate');
            return false;
        }
        if ( !unlink( $file ) ) {
            $this->addError('target', 'Cannot remove certificate');
            return false;
        }
        
        exec('sync');        
        exec('update-ca-certificates -f');
        exec('sync');
        
        Tools::addReason("removed https certificate");
		return true;
    }
}
